/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.epm.AttributeMapping;
import com.ca.siteminder.sdk.adminapi.ca.epm.Role;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent4x;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.ODBCQuery;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserPolicy;
import com.ca.siteminder.sdk.adminapi.ca.xps.Expression;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.CheckAuthentication;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseAuth;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class RoleExpSetup
extends SetupConnection {
    protected String appendStr = Long.toString(random);
    protected AuthSchemeType authSchemeType;
    protected SetupType setupType;
    private String strAgentName = "Agent" + this.appendStr;
    private String strAuthSchemeName = "";
    private String strUDName = "UserDir" + this.appendStr;
    private String strAppName = "Application" + this.appendStr;
    private String strRoleName = "Role" + this.appendStr;
    private String strRoleExpr = "(100 = 100)";
    private String strGroupDN = null;
    private String queryString = null;
    public CheckAuthentication checkAuth;
    public String currentExpression;

    public RoleExpSetup(TestSuite testSuite, AuthSchemeType authSchemeType, SetupType setupType) {
        super(testSuite);
        this.authSchemeType = authSchemeType;
        this.setupType = setupType;
    }

    public RoleExpSetup(Class<? extends TestBase> clazz, AuthSchemeType authSchemeType, SetupType setupType, String string) {
        this(clazz, authSchemeType, setupType);
        this.queryString = string;
    }

    public RoleExpSetup(Class<? extends TestBase> clazz, AuthSchemeType authSchemeType, SetupType setupType) {
        super(clazz);
        this.authSchemeType = authSchemeType;
        this.setupType = setupType;
    }

    public RoleExpSetup(Class<? extends TestBase> clazz) {
        this(clazz, AuthSchemeType.Basic, SetupType.Basic);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.doSetup();
        TestBaseAuth.expSetup = this;
    }

    @Override
    public void tearDown() {
        this.checkAuth.logout();
        super.tearDown();
    }

    protected void SetGroupPaths() {
        Object var1_1 = null;
        String string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (string.equals("ODBC:")) {
            this.strGroupDN = "ExprGroup";
        } else if (string.equals("LDAP:") || string.equals("AD:")) {
            String string2 = SetupConnection.properties.get("LDAP_SEARCH_ROOT");
            String string3 = SetupConnection.properties.get("LDAP_GROUP_SEARCH_ATTR1");
            String string4 = SetupConnection.properties.get("LDAP_GROUP_ATTR");
            this.strGroupDN = string4 + "=ExprGroup," + string3 + "=Groups," + string2;
        }
    }

    public void doSetup() throws XPSException {
        this.strAuthSchemeName = "BasicAuth" + this.appendStr;
        this.createAuthSchemeBasic(this.strAuthSchemeName);
        this.createAgent4x(this.strAgentName);
        this.checkAndCreateUserDirIfNeeded(this.strUDName);
        this.createEPMAppln(this.strAppName, this.strAgentName, this.strUDName, this.strAuthSchemeName);
        this.createRole(this.strRoleName, this.strRoleExpr, this.strAppName);
        this.createPolicy(this.strRoleName, this.strAppName, this.strUDName);
        if (this.setupType == SetupType.RiskSetup) {
            SetupConnection.configSM.setValue("ConfidenceLevelSupportEnabled", "true");
            this.updateRealm(this.strAppName, null, true);
            String string = "(INTEGER (SM_USER_CONFIDENCE_LEVEL) >= INTEGER (SM_MIN_CONFIDENCE_LEVEL))";
            this.updateRole(this.strRoleName, string);
        } else {
            this.updateRole(this.strRoleName, null);
        }
        InternalTesting.Server_updateCaches(session);
        this.SetGroupPaths();
        this.createAttributeMapping("IsPremiumUser", AttributeMapping.Type.Group, this.strGroupDN);
        this.createAttributeMapping("IsUser", AttributeMapping.Type.Constant, "TRUE");
        this.createAttributeMapping("IsBoss", AttributeMapping.Type.Expression, "(telephoneNumber CONTAINS \"6666\")");
        this.createAttributeMapping("IsPeon", AttributeMapping.Type.Expression, "(NOT (telephoneNumber CONTAINS \"6666\"))");
        this.createAttributeMapping("CarLicensePlusFive", AttributeMapping.Type.Expression, "(NUMBER(carLicense) + 5)");
        this.createAttributeMapping("CarLicenseBasedString", AttributeMapping.Type.Expression, "(\"1234\" + carLicense)");
        this.login(this.queryString);
    }

    public void login() {
        this.login(null);
    }

    public void setQueryString(String string) {
        this.login(string);
    }

    void login(String string) {
        this.strAgentName = "Agent" + this.getAppendStr();
        String string2 = SetupConnection.properties.get("PS_IP");
        this.checkAuth = new CheckAuthentication(string2, this.strAgentName);
        String string3 = "ExprTestUser";
        if (!this.checkAuth.isProtected(string)) {
            RoleExpSetup.fail((String)"Resource must be protected");
        }
        if (!this.checkAuth.isAuthenticated(string3, "firewall")) {
            RoleExpSetup.fail((String)("Authentication of user '" + string3 + "' failed"));
        }
    }

    public boolean isProtected(String string) {
        return this.checkAuth.isProtected(string);
    }

    private void createAgent4x(String string) throws XPSException {
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        if (string != null) {
            Agent4x agent4x = (Agent4x)SetupConnection.policyData.newObject((IClass)Agent4x.ddclass);
            agent4x.setName(string.toLowerCase());
            agent4x.setAgentType(agentType);
            agent4x.setDesc("XPSAPI JUnit Sample Agent");
            agent4x.setRealmHintAttrId(Integer.valueOf(0));
            agent4x.setSecret("firewall");
            agent4x.clearIpAddr();
            this.createRoleObject((XPSObject)agent4x);
        }
    }

    public void checkAndCreateUserDirIfNeeded(String string) throws XPSException {
        UserDirectory userDirectory = null;
        try {
            userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (userDirectory != null) {
            return;
        }
        if (string != null) {
            UserDirectory userDirectory2 = (UserDirectory)SetupConnection.policyData.newObject((IClass)UserDirectory.ddclass);
            userDirectory2.setName(string);
            userDirectory2.setDesc("XPSAPI JUnit Sample UserDirectory");
            String string2 = SetupConnection.properties.get("USERDIR_NAMESPACE");
            userDirectory2.setNamespace(string2);
            if (string2.equals("ODBC:")) {
                ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.policyData.newObject((IClass)ODBCQuery.ddclass);
                oDBCQuery.setName(string + "_query");
                oDBCQuery.setDesc("XPSAPI JUnit Sample Query Scheme");
                SetupConnection.createObject((XPSObject)oDBCQuery);
                userDirectory2.setODBCQuery(oDBCQuery);
                userDirectory2.setUniversalIDAttribute("name");
                userDirectory2.setServer(SetupConnection.properties.get("ODBC_USER_STORE_SERVER"));
            }
            if (string2.equals("LDAP:")) {
                userDirectory2.setUniversalIDAttribute("uid");
            }
            if (string2.equals("AD:")) {
                userDirectory2.setUniversalIDAttribute("CN");
            }
            if (string2.equals("LDAP:") || string2.equals("AD:")) {
                userDirectory2.setServer(SetupConnection.properties.get("LDAP_USER_STORE_SERVER"));
                userDirectory2.setSearchRoot(SetupConnection.properties.get("LDAP_SEARCH_ROOT"));
                userDirectory2.setSearchResults(Integer.valueOf(0));
                userDirectory2.setSearchScope(UserDirectory.SearchScope.SubTree);
                userDirectory2.setSearchTimeout(Integer.valueOf(30));
                userDirectory2.setUserLookupStart(SetupConnection.properties.get("LDAP_USER_LOOKUP_START"));
                userDirectory2.setUserLookupEnd(SetupConnection.properties.get("LDAP_USER_LOOKUP_END"));
            }
            if (SetupConnection.properties.get("USERDIR_CREDENTIALS_USERNAME") != null && SetupConnection.properties.get("USERDIR_CREDENTIALS_PASSWORD") != null) {
                userDirectory2.setUsername(SetupConnection.properties.get("USERDIR_CREDENTIALS_USERNAME"));
                userDirectory2.setPassword(SetupConnection.properties.get("USERDIR_CREDENTIALS_PASSWORD"));
                userDirectory2.setRequireCredentials(Boolean.valueOf(true));
            } else {
                userDirectory2.setRequireCredentials(Boolean.valueOf(false));
            }
            userDirectory2.setSecureConnection(Boolean.valueOf(false));
            userDirectory2.setEnableSecurityContext(Boolean.valueOf(false));
            SetupConnection.createObject((XPSObject)userDirectory2);
        }
    }

    public void createAttributeMapping(String string, AttributeMapping.Type type, String string2) {
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, this.strUDName);
        AttributeMapping attributeMapping = (AttributeMapping)SetupConnection.policyData.newObject((IClass)AttributeMapping.ddclass);
        attributeMapping.setParent(userDirectory);
        attributeMapping.setName(string);
        attributeMapping.setType(type);
        attributeMapping.setDefinition(string2);
        this.createRoleObject((XPSObject)attributeMapping);
    }

    private void createEPMAppln(String string, String string2, String string3, String string4) throws XPSException {
        List<UserDirectory> list = SetupConnection.builder.getUserDirs(string3);
        Agent agent = (Agent)SetupConnection.fetchByName(Agent.ddclass, string2.toLowerCase());
        AuthScheme authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, string4);
        Application application = SetupConnection.builder.makeApplication(string, list);
        this.createRoleObject((XPSObject)application);
        Realm realm = (Realm)SetupConnection.policyData.newObject((IClass)Realm.ddclass);
        realm.setName(string);
        realm.setAgent(agent);
        realm.setAuthScheme(authScheme);
        realm.setParent((Domain)application);
        realm.setDesc("XPSAPI JUnit Sample Realm");
        realm.setResourceFilter("/test/");
        realm.setProcessAuthEvents(Boolean.valueOf(true));
        realm.setProcessAzEvents(Boolean.valueOf(true));
        realm.setProtectAll(Boolean.valueOf(true));
        realm.setMaxTimeout(Integer.valueOf(10800));
        realm.setIdleTimeout(Integer.valueOf(3600));
        realm.setSyncAudit(Boolean.valueOf(false));
        realm.setSessionType(Realm.SessionType.Nonperistent);
        realm.setSessionDrift(Integer.valueOf(-1));
        this.createRoleObject((XPSObject)realm);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Get");
        arrayList.add("Put");
        arrayList.add("Post");
        Rule rule = (Rule)SetupConnection.policyData.newObject((IClass)Rule.ddclass);
        rule.setName(string);
        rule.setParent(realm);
        rule.setDesc("XPSAPI JUnit Sample Rule");
        rule.setActions(arrayList);
        rule.setResource("*");
        rule.setAllowAccess(Boolean.valueOf(true));
        rule.setRegularExpression(Boolean.valueOf(false));
        rule.setIsEnabled(Boolean.valueOf(true));
        this.createRoleObject((XPSObject)rule);
    }

    private void createRole(String string, String string2, String string3) throws XPSException {
        Application application = (Application)SetupConnection.fetchByName(Application.ddclass, string3);
        Role role = (Role)SetupConnection.policyData.newObject((IClass)Role.ddclass);
        role.setName(string);
        role.setDescription("XPSAPI JUnit Sample Expression");
        role.clearFlags();
        role.setExpression(string2);
        role.setParent((Domain)application);
        this.createRoleObject((XPSObject)role);
    }

    private void createPolicy(String string, String string2, String string3) throws XPSException {
        Application application = (Application)SetupConnection.fetchByName(Application.ddclass, string2);
        Role role = (Role)SetupConnection.fetchByName(Role.ddclass, string);
        Rule rule = (Rule)SetupConnection.fetchByName(Rule.ddclass, string2);
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, string3);
        Policy policy = (Policy)SetupConnection.policyData.newObject((IClass)Policy.ddclass);
        policy.setName(string);
        policy.setParent((Domain)application);
        policy.setDesc("XPSAPI JUnit Sample policy");
        policy.setAllowAccess(Boolean.valueOf(true));
        policy.setIsEnabled(Boolean.valueOf(true));
        policy.setActiveExprString("<@lib=\"EPMObjects\" func=\"Role\" param=\"" + role.getXid() + "\"@>");
        this.createRoleObject((XPSObject)policy);
        PolicyLink policyLink = (PolicyLink)SetupConnection.policyData.newObject((IClass)PolicyLink.ddclass);
        policyLink.setParent(policy);
        policyLink.setRule(rule);
        this.createRoleObject((XPSObject)policyLink);
        UserPolicy userPolicy = (UserPolicy)SetupConnection.policyData.newObject((IClass)UserPolicy.ddclass);
        userPolicy.setParent(policy);
        userPolicy.setUserDirectory(userDirectory);
        userPolicy.setPolicyFlags(UserPolicy.PolicyFlags.Default);
        userPolicy.setFilterClass("All");
        userPolicy.setFilterPath("All");
        userPolicy.setPolicyResolution(UserPolicy.PolicyResolution.All);
        this.createRoleObject((XPSObject)userPolicy);
    }

    public void updateRole(String string, String string2) throws XPSException {
        Filter filter = new Filter((IAttribute)Policy.NAME, Clause.Operator.EQUAL, (Object)string);
        List list = SetupConnection.policyData.search((IClass)Policy.ddclass, filter);
        Role role = (Role)SetupConnection.fetchByName(Role.ddclass, string);
        if (string2 != null) {
            role.setExpression(string2);
        }
        role.setPolicies(list);
        SetupConnection.updateObject((XPSObject)role);
    }

    public void updateRole(String string) throws XPSException {
        this.currentExpression = string;
        this.updateRole(this.strRoleName, string);
    }

    public void createExpression(String string, String string2) throws XPSException {
        Expression expression = (Expression)SetupConnection.policyData.newObject((IClass)Expression.ddclass);
        expression.setName(string);
        expression.setDescription("XPSAPI JUnit Sample Expression");
        expression.setExpression(string2);
        this.createRoleObject((XPSObject)expression);
    }

    public void createAuthSchemeBasic(String string) throws XPSException {
        if (string != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
            authScheme.setName(string);
            authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
            authScheme.setLevel(Integer.valueOf(5));
            authScheme.setLibrary("smauthdir");
            authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
            authScheme.setType(AuthScheme.Type.Basic);
            this.createRoleObject((XPSObject)authScheme);
        }
    }

    public void createOrModifyExpression(String string, String string2) throws XPSException {
        Expression expression = null;
        try {
            expression = (Expression)SetupConnection.fetchByName(Expression.ddclass, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (expression == null) {
            this.createExpression(string, string2);
        } else {
            expression.setName(string);
            expression.setDescription("XPSAPI JUnit Sample Expression");
            expression.setExpression(string2);
            this.updateRoleObject((XPSObject)expression);
        }
    }

    public void createAuthSchemeHTML(String string) throws XPSException {
        if (string != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
            authScheme.setName(string);
            authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
            authScheme.setLevel(Integer.valueOf(5));
            authScheme.setLibrary("smauththtml");
            authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
            authScheme.setType(AuthScheme.Type.HTMLForm);
            authScheme.setParam("http://" + SetupConnection.properties.get("CLIENT_HOST_NAME") + ":" + SetupConnection.properties.get("CLIENT_PORT") + "/siteminderagent/forms/login.fcc;ACS=0;REL=0");
            this.createRoleObject((XPSObject)authScheme);
        }
    }

    public void createAuthSchemeTest(String string) throws XPSException {
        if (string != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
            authScheme.setName(string);
            authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
            authScheme.setLevel(Integer.valueOf(5));
            authScheme.setLibrary("smauthtest");
            authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
            authScheme.setType(AuthScheme.Type.Custom);
            this.createRoleObject((XPSObject)authScheme);
        }
    }

    public void updateRealm(String string, String string2, boolean bl) {
        Realm realm = (Realm)SetupConnection.fetchByName(Realm.ddclass, string);
        if (string2 != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, string2);
            realm.setAuthScheme(authScheme);
        }
        if (bl) {
            realm.setMinUserConfidenceLevel(Integer.valueOf(300));
        }
        SetupConnection.updateObject((XPSObject)realm);
    }

    public void updateRealm(String string, boolean bl) {
        this.updateRealm(this.strAppName, string, bl);
    }

    private void updateRoleObject(XPSObject xPSObject) throws XPSException {
        SetupConnection.updateObject(xPSObject);
    }

    private void createRoleObject(XPSObject xPSObject) throws XPSException {
        RoleExpSetup.createObject(xPSObject);
    }

    public String getAppendStr() {
        return this.appendStr;
    }

    public String getRoleName() {
        return this.strRoleName;
    }

    public void setRoleName(String string) {
        this.strRoleName = string;
    }

    public String getAppName() {
        return this.strAppName;
    }

    public static enum SetupType {
        Basic,
        RiskSetup;

    }

    public static enum AuthSchemeType {
        Basic,
        FormAuthScheme,
        CustomAuthScheme;

    }
}

