/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentConfig;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalResponse;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalRule;
import com.ca.siteminder.sdk.adminapi.ca.sm.HostConfig;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSAdditionalProperties;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSAdditionalPropertiesSet;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSBLTH;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSEnvironment;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSIdentityPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSIdentityPolicySet;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSManagedObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSManagedObjectAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRole;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleAdminPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleChangePolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleMemberPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleOwnerPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleRule;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleScopeRule;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSScreen;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSScreenDefinition;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSScreenField;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSTab;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSTabDefinition;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSTask;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSValidationRule;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSValidationRuleSet;
import com.ca.siteminder.sdk.adminapi.ca.sm.IdentityMapping;
import com.ca.siteminder.sdk.adminapi.ca.sm.PasswordPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.TrustedHost;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class ObjectBuilder {
    public Agent makeAgent(String string) throws XPSException {
        Agent agent = (Agent)SetupConnection.policyData.newObject((IClass)Agent.ddclass);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        if (string != null) {
            agent.setName(string);
        }
        agent.setAgentType(agentType);
        agent.setDesc("XPSAPI JUnit Sample Agent");
        agent.setRealmHintAttrId(Integer.valueOf(0));
        return agent;
    }

    public AuthScheme makeAuthScheme(String string) throws XPSException {
        AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
        if (string != null) {
            authScheme.setName(string);
        }
        authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
        authScheme.setLevel(Integer.valueOf(5));
        authScheme.setLibrary("smauthdir");
        authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
        authScheme.setType(AuthScheme.Type.Basic);
        return authScheme;
    }

    public UserDirectory makeUserDirectory(String string) throws XPSException {
        UserDirectory userDirectory = (UserDirectory)SetupConnection.policyData.newObject((IClass)UserDirectory.ddclass);
        if (string != null) {
            userDirectory.setName(string);
        }
        userDirectory.setDesc("XPSAPI JUnit Sample UserDirectory");
        userDirectory.setBlobAttribute("blob attribute");
        userDirectory.setNamespace("LDAP:");
        userDirectory.setServer("localhost:389");
        userDirectory.setSearchRoot("ou=people,o=idpusers");
        userDirectory.setSearchResults(Integer.valueOf(0));
        userDirectory.setSearchScope(UserDirectory.SearchScope.Base);
        userDirectory.setSearchTimeout(Integer.valueOf(30));
        userDirectory.setUserLookupStart("(uid=");
        userDirectory.setUserLookupEnd(")");
        userDirectory.setPassword("Firewall1");
        userDirectory.setSecureConnection(Boolean.valueOf(false));
        userDirectory.setRequireCredentials(Boolean.valueOf(false));
        userDirectory.setEnableSecurityContext(Boolean.valueOf(false));
        return userDirectory;
    }

    public Domain makeDomain(String string, List<UserDirectory> list) throws XPSException {
        Domain domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        if (string != null) {
            domain.setName(string);
        }
        if (list != null && list.size() != 0) {
            domain.setUserDirectories(list);
        }
        domain.setDesc("XPSAPI JUnit Sample Domain");
        domain.setMode(Domain.Mode.Default);
        return domain;
    }

    public Realm makeRealm(String string, Agent agent, AuthScheme authScheme, Domain domain) throws XPSException {
        Realm realm = (Realm)SetupConnection.policyData.newObject((IClass)Realm.ddclass);
        if (string != null) {
            realm.setName(string);
        }
        if (agent != null) {
            realm.setAgent(agent);
        }
        if (authScheme != null) {
            realm.setAuthScheme(authScheme);
        }
        if (domain != null) {
            realm.setParent(domain);
        }
        realm.setDesc("XPSAPI JUnit Sample Realm");
        realm.setResourceFilter("/abc/");
        realm.setProcessAuthEvents(Boolean.valueOf(true));
        realm.setProcessAzEvents(Boolean.valueOf(true));
        realm.setProtectAll(Boolean.valueOf(true));
        realm.setMaxTimeout(Integer.valueOf(10800));
        realm.setIdleTimeout(Integer.valueOf(3600));
        realm.setSyncAudit(Boolean.valueOf(false));
        realm.setSessionType(Realm.SessionType.Nonperistent);
        realm.setSessionDrift(Integer.valueOf(3600));
        return realm;
    }

    public Rule makeRule(String string, Realm realm) throws XPSException {
        Rule rule = (Rule)SetupConnection.policyData.newObject((IClass)Rule.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Get");
        arrayList.add("Put");
        arrayList.add("Post");
        if (string != null) {
            rule.setName(string);
        }
        if (realm != null) {
            rule.setParent(realm);
        }
        rule.setDesc("XPSAPI JUnit Sample Rule");
        rule.setActions(arrayList);
        rule.setResource("*");
        rule.setTimeRestriction("46ba9140-00000000-7f7f7f7f7f7f7f7f7f7f7f7d7d7d7d7d7d7f7f7f7f7f7f7f");
        rule.setAllowAccess(Boolean.valueOf(true));
        rule.setRegularExpression(Boolean.valueOf(true));
        rule.setIsEnabled(Boolean.valueOf(true));
        rule.setActiveExprString("<@lib=\"lib-test\"func=\"test\" param=\"param1\"@>");
        return rule;
    }

    public Response makeResponse(String string, Domain domain, AgentType agentType) throws XPSException {
        Response response = (Response)SetupConnection.policyData.newObject((IClass)Response.ddclass);
        if (string != null) {
            response.setName(string);
        }
        if (agentType != null) {
            response.setAgentType(agentType);
        }
        if (domain != null) {
            response.setParent(domain);
        }
        response.setDesc("XPSAPI JUnit Sample Response");
        response.setAccessAccept(Boolean.valueOf(false));
        response.setAccessReject(Boolean.valueOf(false));
        response.setAccessChallenge(Boolean.valueOf(false));
        return response;
    }

    public Policy makePolicy(String string, Domain domain) throws XPSException {
        Policy policy = (Policy)SetupConnection.policyData.newObject((IClass)Policy.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("fr.ca.com");
        if (string != null) {
            policy.setName(string);
        }
        if (domain != null) {
            policy.setParent(domain);
        }
        policy.setDesc("XPSAPI JUnit Sample policy");
        policy.setAllowAccess(Boolean.valueOf(false));
        policy.setIsEnabled(Boolean.valueOf(true));
        policy.setIPAddresses(arrayList);
        policy.setTimeRestriction("00000000-00000000-7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f6f5f5f5f5f5f7f");
        policy.setActiveExprString("<@lib=\"lib-test\" func=\"test\"@>");
        return policy;
    }

    public GlobalResponse makeGlobalResponse(String string) throws XPSException {
        GlobalResponse globalResponse = (GlobalResponse)SetupConnection.policyData.newObject((IClass)GlobalResponse.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OnAuthAccept");
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        if (string != null) {
            globalResponse.setName(string);
        }
        globalResponse.setDesc("XPSAPI JUnit Sample GlobalResponse");
        globalResponse.setAgentType(agentType);
        globalResponse.setAccessChallenge(Boolean.valueOf(true));
        globalResponse.setAccessReject(Boolean.valueOf(true));
        globalResponse.setAccessAccept(Boolean.valueOf(true));
        globalResponse.setIsGlobal(GlobalResponse.IsGlobal.YES);
        return globalResponse;
    }

    public GlobalRule makeGlobalRule(String string, Agent agent) throws XPSException {
        GlobalRule globalRule = (GlobalRule)SetupConnection.policyData.newObject((IClass)GlobalRule.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OnAuthAccept");
        if (string != null) {
            globalRule.setName(string);
        }
        if (agent != null) {
            globalRule.setAgent(agent);
        }
        globalRule.setDesc("XPSAPI JUnit Sample GlobalRule");
        globalRule.setActions(arrayList);
        globalRule.setIsEnabled(Boolean.valueOf(true));
        globalRule.setIsGlobal(GlobalRule.IsGlobal.YES);
        globalRule.setAllowAccess(Boolean.valueOf(true));
        return globalRule;
    }

    public GlobalPolicy makeGlobalPolicy(String string, Domain domain) throws XPSException {
        GlobalPolicy globalPolicy = (GlobalPolicy)SetupConnection.policyData.newObject((IClass)GlobalPolicy.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("127.0.0.1");
        if (string != null) {
            globalPolicy.setName(string);
        }
        if (domain != null) {
            globalPolicy.setParent(domain);
        }
        globalPolicy.setDesc("XPSAPI JUnit Sample GlobalPolicy");
        globalPolicy.setAllowAccess(Boolean.valueOf(true));
        globalPolicy.setTimeRestriction("00000000-00000000-7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f");
        globalPolicy.setIsEnabled(Boolean.valueOf(true));
        globalPolicy.setIsGlobal(GlobalPolicy.IsGlobal.YES);
        globalPolicy.setIPAddresses(arrayList);
        return globalPolicy;
    }

    public PasswordPolicy makePasswordPolicy(String string, UserDirectory userDirectory) throws XPSException {
        PasswordPolicy passwordPolicy = (PasswordPolicy)SetupConnection.policyData.newObject((IClass)PasswordPolicy.ddclass);
        if (string != null) {
            passwordPolicy.setName(string);
        }
        if (userDirectory != null) {
            passwordPolicy.setUserDirectory(userDirectory);
        }
        passwordPolicy.setDesc("XPSAPI JUnit Sample PasswordPolicy");
        passwordPolicy.set_class("pwdclass");
        passwordPolicy.setPriority(Integer.valueOf(2));
        passwordPolicy.setPWMaxLength(Integer.valueOf(18));
        passwordPolicy.setPWMinLength(Integer.valueOf(6));
        passwordPolicy.setPWMinNonAlpha(Integer.valueOf(2));
        passwordPolicy.setPwdChangeDaysGrace(Integer.valueOf(3));
        passwordPolicy.setPwdChangeGraceLogins(Integer.valueOf(3));
        passwordPolicy.setPwdChangePeriod(Integer.valueOf(3));
        passwordPolicy.setPWMaxRepeatingChar(Integer.valueOf(3));
        passwordPolicy.setPWMinAlpha(Integer.valueOf(3));
        passwordPolicy.setPWMinAlphaNum(Integer.valueOf(3));
        passwordPolicy.setPWMinLowerAlpha(Integer.valueOf(3));
        passwordPolicy.setPWMinUpperAlpha(Integer.valueOf(3));
        passwordPolicy.setPWPercentSequence(Integer.valueOf(3));
        passwordPolicy.setPWReuseCount(Integer.valueOf(3));
        passwordPolicy.setPWReuseDelay(Integer.valueOf(3));
        passwordPolicy.setPWSpecialsLength(Integer.valueOf(3));
        passwordPolicy.setReenablement(Integer.valueOf(3));
        return passwordPolicy;
    }

    public Application makeApplication(String string, List<UserDirectory> list) throws XPSException {
        Application application = (Application)SetupConnection.policyData.newObject((IClass)Application.ddclass);
        if (string != null) {
            application.setName(string);
        }
        if (list != null) {
            application.setUserDirectories(list);
        }
        application.setDesc("XPSAPI JUnit Sample Application");
        application.setMode(Domain.Mode.Default);
        return application;
    }

    public Administrator makeAdministrator(String string) throws XPSException {
        Administrator administrator = (Administrator)SetupConnection.policyData.newObject((IClass)Administrator.ddclass);
        EnumSet<Administrator.Flags> enumSet = EnumSet.noneOf(Administrator.Flags.class);
        EnumSet<Administrator.MethodsAllowed> enumSet2 = EnumSet.of(Administrator.MethodsAllowed.RemoteAPI, Administrator.MethodsAllowed.LocalAPI);
        if (string != null) {
            administrator.setName(string);
            administrator.setUserPath(string);
        } else {
            administrator.setUserPath(SecuritySetup.getLegacyNamespace() + "Default");
        }
        administrator.setDescription("XPSAPI JUnit Sample Administrator");
        administrator.setFlags(enumSet);
        administrator.setMethodsAllowed(enumSet2);
        return administrator;
    }

    public IdentityMapping makeIdentityMapping(String string, String string2) throws XPSException {
        IdentityMapping identityMapping = (IdentityMapping)SetupConnection.policyData.newObject((IClass)IdentityMapping.ddclass);
        if (string != null) {
            identityMapping.setName(string);
        }
        identityMapping.setDescription("XPSAPI JUnit Sample IdentityMapping");
        if (string2.equals("az")) {
            identityMapping.setMappingType(IdentityMapping.MappingType.AzMapping);
        } else if (string2.equals("validate")) {
            identityMapping.setMappingType(IdentityMapping.MappingType.ValidateMapping);
        }
        return identityMapping;
    }

    public Domain doDomainSetUp(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws XPSException {
        Realm realm;
        Object object;
        UserDirectory userDirectory = this.makeUserDirectory(string);
        SetupConnection.createObject((XPSObject)userDirectory);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        Agent agent = this.makeAgent(string2);
        SetupConnection.createObject((XPSObject)agent);
        if (string3 != null) {
            object = this.makeAgent(string3);
            SetupConnection.createObject((XPSObject)object);
        }
        object = this.getUserDirs(string);
        AuthScheme authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, "Basic");
        Domain domain = this.makeDomain(string4, (List<UserDirectory>)object);
        SetupConnection.createObject((XPSObject)domain);
        if (string5 != null) {
            realm = this.makeRealm(string5, agent, authScheme, domain);
            SetupConnection.createObject((XPSObject)realm);
            if (string6 != null) {
                Rule rule = this.makeRule(string6, realm);
                SetupConnection.createObject((XPSObject)rule);
            }
        }
        if (string7 != null) {
            realm = this.makeResponse(string7, domain, agentType);
            SetupConnection.createObject((XPSObject)realm);
        }
        if (string8 != null) {
            realm = this.makePolicy(string8, domain);
            SetupConnection.createObject((XPSObject)realm);
        }
        return domain;
    }

    public UserDirectory doUserDirSetUp(String string) throws XPSException {
        UserDirectory userDirectory = this.makeUserDirectory(string);
        SetupConnection.createObject((XPSObject)userDirectory);
        return userDirectory;
    }

    public Agent doAgentSetUp(String string) throws XPSException {
        Agent agent = this.makeAgent(string);
        SetupConnection.createObject((XPSObject)agent);
        return agent;
    }

    public AuthScheme doAuthSchemeSetUp(String string) throws XPSException {
        AuthScheme authScheme = SetupConnection.builder.makeAuthScheme(string);
        SetupConnection.createObject((XPSObject)authScheme);
        return authScheme;
    }

    public Application doApplicationSetUp(String string, String string2) throws XPSException {
        UserDirectory userDirectory = this.makeUserDirectory(string);
        SetupConnection.createObject((XPSObject)userDirectory);
        ArrayList<UserDirectory> arrayList = new ArrayList<UserDirectory>();
        arrayList.add(userDirectory);
        Application application = this.makeApplication(string2, arrayList);
        SetupConnection.createObject((XPSObject)application);
        return application;
    }

    public IdentityMapping doIdentityMappingSetup(String string, String string2) throws XPSException {
        IdentityMapping identityMapping = SetupConnection.builder.makeIdentityMapping(string, string2);
        SetupConnection.createObject((XPSObject)identityMapping);
        return identityMapping;
    }

    public List<UserDirectory> getUserDirs(String string) {
        Filter filter = new Filter((IAttribute)UserDirectory.NAME, Clause.Operator.EQUAL, (Object)string);
        Filter filter2 = new Filter((IAttribute)UserDirectory.SEARCHTIMEOUT, Clause.Operator.GREATER, (Object)"25");
        filter.AND(filter2);
        List list = SetupConnection.policyData.search((IClass)UserDirectory.ddclass, filter);
        if (list.size() != 1) {
            throw new XPSException("getUserDirectories", new Object[]{filter.getClass().getName(), string});
        }
        return list;
    }

    public AgentConfig makeAgentConfig(String string) throws XPSException {
        AgentConfig agentConfig = (AgentConfig)SetupConnection.policyData.newObject((IClass)AgentConfig.ddclass);
        if (string != null) {
            agentConfig.setName(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Id=2=9999");
        arrayList.add("Enable=1=yes");
        arrayList.add("LogFile=3=no");
        agentConfig.setDesc("XPSAPI JUnit Sample AgentConfig");
        agentConfig.setAttributes(arrayList);
        return agentConfig;
    }

    public HostConfig makeHostConfig(String string) throws XPSException {
        HostConfig hostConfig = (HostConfig)SetupConnection.policyData.newObject((IClass)HostConfig.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("127.0.0.1,44441,44442,44443");
        if (string != null) {
            hostConfig.setName(string);
        }
        hostConfig.setDesc("XPSAPI JUnit Sample HostConfig");
        hostConfig.setPolicyServer(arrayList);
        hostConfig.setMaxSocketsPerPort(Integer.valueOf(20));
        hostConfig.setMinSocketsPerPort(Integer.valueOf(2));
        hostConfig.setNewSocketStep(Integer.valueOf(2));
        hostConfig.setRequestTimeout(Integer.valueOf(60));
        hostConfig.setEnableFailOver(Boolean.valueOf(true));
        return hostConfig;
    }

    public TrustedHost makeTrustedHost(String string) throws XPSException {
        TrustedHost trustedHost = (TrustedHost)SetupConnection.policyData.newObject((IClass)TrustedHost.ddclass);
        if (string != null) {
            trustedHost.setName(string);
        }
        trustedHost.setDesc("XPSAPI JUnit Sample trustedHost");
        trustedHost.setIpAddr("127.0.0.1");
        trustedHost.setSecret("firewall");
        trustedHost.setRolloverEnabled(Boolean.valueOf(false));
        return trustedHost;
    }

    public IMSAdditionalPropertiesSet makeIMSAdditionalPropertiesSet(String string) throws XPSException {
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = (IMSAdditionalPropertiesSet)SetupConnection.policyData.newObject((IClass)IMSAdditionalPropertiesSet.ddclass);
        if (string != null) {
            iMSAdditionalPropertiesSet.setName(string);
        }
        iMSAdditionalPropertiesSet.setDescription("XPSAPI JUnit Sample IMSAdditionalPropertiesSet");
        return iMSAdditionalPropertiesSet;
    }

    public IMSAdditionalProperties makeIMSAdditionalProperties(String string) throws XPSException {
        IMSAdditionalProperties iMSAdditionalProperties = (IMSAdditionalProperties)SetupConnection.policyData.newObject((IClass)IMSAdditionalProperties.ddclass);
        if (string != null) {
            iMSAdditionalProperties.setName(string);
        }
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        iMSAdditionalProperties.setParent(iMSAdditionalPropertiesSet);
        iMSAdditionalProperties.setDescription("XPSAPI JUnit Sample IMSAdditionalProperties");
        return iMSAdditionalProperties;
    }

    public IMSDirectory makeIMSDirectory(String string) throws XPSException {
        IMSDirectory iMSDirectory = (IMSDirectory)SetupConnection.policyData.newObject((IClass)IMSDirectory.ddclass);
        if (string != null) {
            iMSDirectory.setName(string);
        }
        iMSDirectory.setDescription("XPSAPI JUnit Sample IMSDirectory");
        iMSDirectory.setProviderLibrary("ProviderLibrary");
        iMSDirectory.setLibraryEntryName("LibraryEntryName");
        iMSDirectory.setSearchMaxPageSize(Integer.valueOf(40));
        iMSDirectory.setSearchMaxRows(Integer.valueOf(20));
        iMSDirectory.setSearchTimeout(Integer.valueOf(100));
        iMSDirectory.setVersion("12.0");
        UserDirectory userDirectory = this.makeUserDirectory(string);
        SetupConnection.createObject((XPSObject)userDirectory);
        iMSDirectory.setUserDirectory(userDirectory);
        List list = iMSDirectory.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSDirectory.setAdditionalProperties(list);
        return iMSDirectory;
    }

    public IMSManagedObject makeIMSManagedObject(String string) throws XPSException {
        IMSManagedObject iMSManagedObject = (IMSManagedObject)SetupConnection.policyData.newObject((IClass)IMSManagedObject.ddclass);
        if (string != null) {
            iMSManagedObject.setName(string);
        }
        IMSDirectory iMSDirectory = this.makeIMSDirectory(string);
        SetupConnection.createObject((XPSObject)iMSDirectory);
        iMSManagedObject.setParent(iMSDirectory);
        iMSManagedObject.setDescription("XPSAPI JUnit Sample IMSManagedObject");
        iMSManagedObject.setObjectType(IMSManagedObject.ObjectType.User);
        iMSManagedObject.setObjectTypeTag("ObjectTypeTag");
        iMSManagedObject.setObjectClass("ObjectClass");
        iMSManagedObject.setContainer("Container");
        List list = iMSManagedObject.getDefaultAttributeList();
        list.add(new String("attr1"));
        list.add(new String("attr2"));
        iMSManagedObject.setDefaultAttributeList(list);
        List list2 = iMSManagedObject.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list2.add(iMSAdditionalPropertiesSet);
        iMSManagedObject.setAdditionalProperties(list2);
        return iMSManagedObject;
    }

    public IMSManagedObjectAttr makeIMSManagedObjectAttr(String string) throws XPSException {
        IMSManagedObjectAttr iMSManagedObjectAttr = (IMSManagedObjectAttr)SetupConnection.policyData.newObject((IClass)IMSManagedObjectAttr.ddclass);
        if (string != null) {
            iMSManagedObjectAttr.setName(string);
        }
        IMSManagedObject iMSManagedObject = this.makeIMSManagedObject(string);
        SetupConnection.createObject((XPSObject)iMSManagedObject);
        iMSManagedObjectAttr.setParent(iMSManagedObject);
        iMSManagedObjectAttr.setDescription("XPSAPI JUnit Sample IMSManagedObjectAttr");
        iMSManagedObjectAttr.setDisplayName("DisplayName");
        iMSManagedObjectAttr.setWellKnown("WellKnown");
        iMSManagedObjectAttr.setBindType("BindType");
        iMSManagedObjectAttr.setObjectClass("ObjectClass");
        iMSManagedObjectAttr.setDisplayHint("DisplayHint");
        iMSManagedObjectAttr.setDisplayHintData("DisplayHintData");
        iMSManagedObjectAttr.setMaxLen(Integer.valueOf(1024));
        iMSManagedObjectAttr.setOptions(Integer.valueOf(1));
        IMSValidationRuleSet iMSValidationRuleSet = this.makeIMSValidationRuleSet(string);
        SetupConnection.createObject((XPSObject)iMSValidationRuleSet);
        iMSManagedObjectAttr.setValidationRuleSet(iMSValidationRuleSet);
        List list = iMSManagedObjectAttr.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSManagedObjectAttr.setAdditionalProperties(list);
        return iMSManagedObjectAttr;
    }

    public IMSValidationRule makeIMSValidationRule(String string) throws XPSException {
        IMSValidationRule iMSValidationRule = (IMSValidationRule)SetupConnection.policyData.newObject((IClass)IMSValidationRule.ddclass);
        if (string != null) {
            iMSValidationRule.setName(string);
        }
        IMSDirectory iMSDirectory = this.makeIMSDirectory(string);
        SetupConnection.createObject((XPSObject)iMSDirectory);
        iMSValidationRule.setParent(iMSDirectory);
        iMSValidationRule.setDescription("XPSAPI JUnit Sample IMSValidationRule");
        iMSValidationRule.setMessageId("MessageId");
        iMSValidationRule.setScript("Script");
        iMSValidationRule.setScriptSourceType(IMSValidationRule.ScriptSourceType.File);
        iMSValidationRule.setScriptType(IMSValidationRule.ScriptType.Java);
        List list = iMSValidationRule.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSValidationRule.setAdditionalProperties(list);
        return iMSValidationRule;
    }

    public IMSValidationRuleSet makeIMSValidationRuleSet(String string) throws XPSException {
        IMSValidationRuleSet iMSValidationRuleSet = (IMSValidationRuleSet)SetupConnection.policyData.newObject((IClass)IMSValidationRuleSet.ddclass);
        if (string != null) {
            iMSValidationRuleSet.setName(string);
        }
        IMSDirectory iMSDirectory = this.makeIMSDirectory(string);
        SetupConnection.createObject((XPSObject)iMSDirectory);
        iMSValidationRuleSet.setParent(iMSDirectory);
        iMSValidationRuleSet.setDescription("XPSAPI JUnit Sample IMSValidationRuleSet");
        List list = iMSValidationRuleSet.getValidationRules();
        IMSValidationRule iMSValidationRule = this.makeIMSValidationRule(string + "-1");
        IMSValidationRule iMSValidationRule2 = this.makeIMSValidationRule(string + "-2");
        SetupConnection.createObject((XPSObject)iMSValidationRule);
        SetupConnection.createObject((XPSObject)iMSValidationRule2);
        list.add(iMSValidationRule);
        list.add(iMSValidationRule2);
        iMSValidationRuleSet.setValidationRules(list);
        List list2 = iMSValidationRuleSet.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list2.add(iMSAdditionalPropertiesSet);
        iMSValidationRuleSet.setAdditionalProperties(list2);
        return iMSValidationRuleSet;
    }

    public IMSEnvironment makeIMSEnvironment(String string) throws XPSException {
        IMSEnvironment iMSEnvironment = (IMSEnvironment)SetupConnection.policyData.newObject((IClass)IMSEnvironment.ddclass);
        if (string != null) {
            iMSEnvironment.setName(string);
        }
        iMSEnvironment.setDescription("XPSAPI JUnit Sample IMSEnvironment");
        iMSEnvironment.setProtectedAlias("ProtectedAlias");
        iMSEnvironment.setPublicAlias("PublicAlias");
        iMSEnvironment.setVersion("Version");
        Domain domain = this.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        iMSEnvironment.setDomain(domain);
        Agent agent = this.makeAgent(string);
        SetupConnection.createObject((XPSObject)agent);
        iMSEnvironment.setRoleSecurityAgent(agent);
        IMSDirectory iMSDirectory = this.makeIMSDirectory(string + "-1");
        SetupConnection.createObject((XPSObject)iMSDirectory);
        iMSEnvironment.setLogicalDirectory(iMSDirectory);
        IMSDirectory iMSDirectory2 = this.makeIMSDirectory(string + "-2");
        SetupConnection.createObject((XPSObject)iMSDirectory2);
        iMSEnvironment.setProvisioningDirectory(iMSDirectory2);
        List list = iMSEnvironment.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSEnvironment.setAdditionalProperties(list);
        return iMSEnvironment;
    }

    public IMSScreenDefinition makeIMSScreenDefinition(String string) throws XPSException {
        IMSScreenDefinition iMSScreenDefinition = (IMSScreenDefinition)SetupConnection.policyData.newObject((IClass)IMSScreenDefinition.ddclass);
        if (string != null) {
            iMSScreenDefinition.setTag(string);
        }
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSScreenDefinition.setParent(iMSEnvironment);
        iMSScreenDefinition.setScreenClassname("ScreenClassname");
        iMSScreenDefinition.setScreenPageClassname("ScreenPageClassname");
        iMSScreenDefinition.setConfigPageClassname("ConfigPageClassname");
        iMSScreenDefinition.setDisplayName("DisplayName");
        iMSScreenDefinition.setScreenType(Integer.valueOf(1));
        List list = iMSScreenDefinition.getObjectTypes();
        list.add(new String("objtype1"));
        list.add(new String("objtype2"));
        iMSScreenDefinition.setObjectTypes(list);
        List list2 = iMSScreenDefinition.getObjectActions();
        list2.add(new String("objaction1"));
        list2.add(new String("objaction2"));
        iMSScreenDefinition.setObjectActions(list2);
        List list3 = iMSScreenDefinition.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list3.add(iMSAdditionalPropertiesSet);
        iMSScreenDefinition.setAdditionalProperties(list3);
        return iMSScreenDefinition;
    }

    public IMSScreen makeIMSScreen(String string) throws XPSException {
        IMSScreen iMSScreen = (IMSScreen)SetupConnection.policyData.newObject((IClass)IMSScreen.ddclass);
        if (string != null) {
            iMSScreen.setTag(string);
        }
        IMSScreenDefinition iMSScreenDefinition = this.makeIMSScreenDefinition(string);
        SetupConnection.createObject((XPSObject)iMSScreenDefinition);
        iMSScreen.setParent(iMSScreenDefinition);
        iMSScreen.setDisplayName("DisplayName");
        iMSScreen.setObjectType("ObjectType");
        List list = iMSScreen.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSScreen.setAdditionalProperties(list);
        return iMSScreen;
    }

    public IMSScreenField makeIMSScreenField(String string) throws XPSException {
        IMSScreenField iMSScreenField = (IMSScreenField)SetupConnection.policyData.newObject((IClass)IMSScreenField.ddclass);
        if (string != null) {
            iMSScreenField.setName(string);
        }
        IMSScreen iMSScreen = this.makeIMSScreen(string);
        SetupConnection.createObject((XPSObject)iMSScreen);
        iMSScreenField.setParent(iMSScreen);
        iMSScreenField.setAttribute("Attribute");
        iMSScreenField.setListName("ListName");
        iMSScreenField.setPermissions("Permissions");
        iMSScreenField.setOrder(Integer.valueOf(1));
        List list = iMSScreenField.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSScreenField.setAdditionalProperties(list);
        return iMSScreenField;
    }

    public IMSTabDefinition makeIMSTabDefinition(String string) throws XPSException {
        IMSTabDefinition iMSTabDefinition = (IMSTabDefinition)SetupConnection.policyData.newObject((IClass)IMSTabDefinition.ddclass);
        if (string != null) {
            iMSTabDefinition.setTag(string);
        }
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSTabDefinition.setParent(iMSEnvironment);
        iMSTabDefinition.setTabClassname("TabClassname");
        iMSTabDefinition.setTabPageClassname("TabPageClassname");
        iMSTabDefinition.setConfigPageClassname("ConfigPageClassname");
        iMSTabDefinition.setDisplayName("DisplayName");
        List list = iMSTabDefinition.getObjectTypes();
        list.add(new String("objtype1"));
        list.add(new String("objtype2"));
        iMSTabDefinition.setObjectTypes(list);
        List list2 = iMSTabDefinition.getObjectActions();
        list2.add(new String("objaction1"));
        list2.add(new String("objaction2"));
        iMSTabDefinition.setObjectActions(list2);
        List list3 = iMSTabDefinition.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list3.add(iMSAdditionalPropertiesSet);
        iMSTabDefinition.setAdditionalProperties(list3);
        return iMSTabDefinition;
    }

    public IMSTab makeIMSTab(String string) throws XPSException {
        IMSTab iMSTab = (IMSTab)SetupConnection.policyData.newObject((IClass)IMSTab.ddclass);
        if (string != null) {
            iMSTab.setTag(string);
        }
        IMSTabDefinition iMSTabDefinition = this.makeIMSTabDefinition(string);
        SetupConnection.createObject((XPSObject)iMSTabDefinition);
        iMSTab.setParent(iMSTabDefinition);
        iMSTab.setExecutionOrder(Integer.valueOf(1));
        IMSTask iMSTask = this.makeIMSTask(string);
        SetupConnection.createObject((XPSObject)iMSTask);
        iMSTab.setTask(iMSTask);
        List list = iMSTab.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSTab.setAdditionalProperties(list);
        return iMSTab;
    }

    public IMSTask makeIMSTask(String string) throws XPSException {
        IMSTask iMSTask = (IMSTask)SetupConnection.policyData.newObject((IClass)IMSTask.ddclass);
        if (string != null) {
            iMSTask.setName(string);
        }
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSTask.setParent(iMSEnvironment);
        iMSTask.setDescription("XPSAPI JUnit Sample IMSTask");
        iMSTask.setCategory("Category");
        iMSTask.setCategory2("Category2");
        iMSTask.setCategory3("Category3");
        iMSTask.setWorkflowProcessId("WorkflowProcessId");
        iMSTask.setApplication("Application");
        iMSTask.setExternalURL("ExternalURL");
        iMSTask.setReserved1("Reserved1");
        iMSTask.setReserved2("Reserved2");
        iMSTask.setReserved3("Reserved3");
        iMSTask.setReserved4("Reserved4");
        iMSTask.setReserved5("Reserved5");
        iMSTask.setReserved6("Reserved6");
        iMSTask.setReserved7("Reserved7");
        iMSTask.setReserved8("Reserved8");
        iMSTask.setReserved9("Reserved9");
        iMSTask.setReserved10("Reserved10");
        iMSTask.setTaskTag("TaskTag");
        iMSTask.setTaskPriority(Integer.valueOf(0));
        iMSTask.setTaskOrder(Integer.valueOf(4));
        iMSTask.setCategoryOrder(Integer.valueOf(1));
        iMSTask.setCategory2Order(Integer.valueOf(2));
        iMSTask.setCategory3Order(Integer.valueOf(3));
        iMSTask.setTypeId(IMSTask.TypeId.Access);
        iMSTask.setTaskFlags(Integer.valueOf(32));
        iMSTask.setActionType(Integer.valueOf(1));
        iMSTask.setObjectType(IMSTask.ObjectType.User);
        iMSTask.setAutomaticExecutionFlag(Integer.valueOf(0));
        IMSScreen iMSScreen = this.makeIMSScreen(string);
        SetupConnection.createObject((XPSObject)iMSScreen);
        iMSTask.setSearchScreen(iMSScreen);
        List list = iMSTask.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSTask.setAdditionalProperties(list);
        return iMSTask;
    }

    public IMSRole makeIMSRole(String string) throws XPSException {
        IMSRole iMSRole = (IMSRole)SetupConnection.policyData.newObject((IClass)IMSRole.ddclass);
        if (string != null) {
            iMSRole.setName(string);
        }
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSRole.setParent(iMSEnvironment);
        iMSRole.setDescription("XPSAPI JUnit Sample IMSRole");
        iMSRole.setCustomField01("CustomField01");
        iMSRole.setCustomField02("CustomField02");
        iMSRole.setCustomField03("CustomField03");
        iMSRole.setCustomField04("CustomField04");
        iMSRole.setCustomField05("CustomField05");
        iMSRole.setCustomField06("CustomField06");
        iMSRole.setCustomField07("CustomField07");
        iMSRole.setCustomField08("CustomField08");
        iMSRole.setCustomField09("CustomField09");
        iMSRole.setCustomField10("CustomField10");
        iMSRole.setTypeId(IMSRole.TypeId.Access);
        iMSRole.setEnabled(Boolean.valueOf(true));
        iMSRole.setAssignable(Boolean.valueOf(true));
        iMSRole.setAdminAssignable(Boolean.valueOf(false));
        List list = iMSRole.getTasks();
        IMSTask iMSTask = this.makeIMSTask(string + "-1");
        IMSTask iMSTask2 = this.makeIMSTask(string + "-2");
        SetupConnection.createObject((XPSObject)iMSTask);
        SetupConnection.createObject((XPSObject)iMSTask2);
        list.add(iMSTask);
        list.add(iMSTask2);
        iMSRole.setTasks(list);
        List list2 = iMSRole.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list2.add(iMSAdditionalPropertiesSet);
        iMSRole.setAdditionalProperties(list2);
        return iMSRole;
    }

    public IMSRoleRule makeIMSRoleRule(String string) throws XPSException {
        IMSRoleRule iMSRoleRule = (IMSRoleRule)SetupConnection.policyData.newObject((IClass)IMSRoleRule.ddclass);
        if (string != null) {
            iMSRoleRule.setName(string);
        }
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSRoleRule.setParent(iMSEnvironment);
        iMSRoleRule.setSource("Source");
        iMSRoleRule.setCompiled("Compiled");
        iMSRoleRule.setEvalType(IMSRoleRule.EvalType.Directory);
        List list = iMSRoleRule.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSRoleRule.setAdditionalProperties(list);
        return iMSRoleRule;
    }

    public IMSRoleScopeRule makeIMSRoleScopeRule(String string) throws XPSException {
        IMSRoleScopeRule iMSRoleScopeRule = (IMSRoleScopeRule)SetupConnection.policyData.newObject((IClass)IMSRoleScopeRule.ddclass);
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSRoleScopeRule.setParent(iMSEnvironment);
        iMSRoleScopeRule.setObjectType("ObjectType");
        IMSRoleRule iMSRoleRule = this.makeIMSRoleRule(string);
        SetupConnection.createObject((XPSObject)iMSRoleRule);
        iMSRoleScopeRule.setScopeRule(iMSRoleRule);
        List list = iMSRoleScopeRule.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSRoleScopeRule.setAdditionalProperties(list);
        return iMSRoleScopeRule;
    }

    public IMSIdentityPolicySet makeIMSIdentityPolicySet(String string) throws XPSException {
        IMSIdentityPolicySet iMSIdentityPolicySet = (IMSIdentityPolicySet)SetupConnection.policyData.newObject((IClass)IMSIdentityPolicySet.ddclass);
        if (string != null) {
            iMSIdentityPolicySet.setName(string);
        }
        IMSEnvironment iMSEnvironment = this.makeIMSEnvironment(string);
        SetupConnection.createObject((XPSObject)iMSEnvironment);
        iMSIdentityPolicySet.setParent(iMSEnvironment);
        iMSIdentityPolicySet.setDescription("XPSAPI JUnit Sample IMSIdentityPolicySet");
        iMSIdentityPolicySet.setCategory("Category");
        List list = iMSIdentityPolicySet.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSIdentityPolicySet.setAdditionalProperties(list);
        return iMSIdentityPolicySet;
    }

    public IMSIdentityPolicy makeIMSIdentityPolicy(String string) throws XPSException {
        IMSIdentityPolicy iMSIdentityPolicy = (IMSIdentityPolicy)SetupConnection.policyData.newObject((IClass)IMSIdentityPolicy.ddclass);
        if (string != null) {
            iMSIdentityPolicy.setName(string);
        }
        IMSIdentityPolicySet iMSIdentityPolicySet = this.makeIMSIdentityPolicySet(string);
        SetupConnection.createObject((XPSObject)iMSIdentityPolicySet);
        iMSIdentityPolicy.setParent(iMSIdentityPolicySet);
        iMSIdentityPolicy.setPolicyApplication(Integer.valueOf(1));
        iMSIdentityPolicy.setFlags(Integer.valueOf(16));
        IMSRoleRule iMSRoleRule = this.makeIMSRoleRule(string + "-1");
        SetupConnection.createObject((XPSObject)iMSRoleRule);
        iMSIdentityPolicy.setMemberRule(iMSRoleRule);
        IMSRoleRule iMSRoleRule2 = this.makeIMSRoleRule(string + "-2");
        SetupConnection.createObject((XPSObject)iMSRoleRule2);
        iMSIdentityPolicy.setAllocation(iMSRoleRule2);
        IMSRoleRule iMSRoleRule3 = this.makeIMSRoleRule(string + "-3");
        SetupConnection.createObject((XPSObject)iMSRoleRule3);
        iMSIdentityPolicy.setDeallocation(iMSRoleRule3);
        Domain domain = this.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        Policy policy = this.makePolicy(string, domain);
        SetupConnection.createObject((XPSObject)policy);
        iMSIdentityPolicy.setPolicy(policy);
        List list = iMSIdentityPolicy.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSIdentityPolicy.setAdditionalProperties(list);
        return iMSIdentityPolicy;
    }

    public IMSRoleChangePolicy makeIMSRoleChangePolicy(String string) throws XPSException {
        IMSRoleChangePolicy iMSRoleChangePolicy = (IMSRoleChangePolicy)SetupConnection.policyData.newObject((IClass)IMSRoleChangePolicy.ddclass);
        IMSRole iMSRole = this.makeIMSRole(string);
        SetupConnection.createObject((XPSObject)iMSRole);
        iMSRoleChangePolicy.setParent(iMSRole);
        IMSRoleRule iMSRoleRule = this.makeIMSRoleRule(string + "-1");
        SetupConnection.createObject((XPSObject)iMSRoleRule);
        iMSRoleChangePolicy.setAddMember(iMSRoleRule);
        IMSRoleRule iMSRoleRule2 = this.makeIMSRoleRule(string + "-2");
        SetupConnection.createObject((XPSObject)iMSRoleRule2);
        iMSRoleChangePolicy.setRemoveMember(iMSRoleRule2);
        IMSRoleRule iMSRoleRule3 = this.makeIMSRoleRule(string + "-3");
        SetupConnection.createObject((XPSObject)iMSRoleRule3);
        iMSRoleChangePolicy.setAddAdmin(iMSRoleRule3);
        IMSRoleRule iMSRoleRule4 = this.makeIMSRoleRule(string + "-4");
        SetupConnection.createObject((XPSObject)iMSRoleRule4);
        iMSRoleChangePolicy.setRemoveAdmin(iMSRoleRule4);
        List list = iMSRoleChangePolicy.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSRoleChangePolicy.setAdditionalProperties(list);
        return iMSRoleChangePolicy;
    }

    public IMSRoleAdminPolicy makeIMSRoleAdminPolicy(String string) throws XPSException {
        IMSRoleAdminPolicy iMSRoleAdminPolicy = (IMSRoleAdminPolicy)SetupConnection.policyData.newObject((IClass)IMSRoleAdminPolicy.ddclass);
        IMSRole iMSRole = this.makeIMSRole(string);
        SetupConnection.createObject((XPSObject)iMSRole);
        iMSRoleAdminPolicy.setParent(iMSRole);
        iMSRoleAdminPolicy.setAssignable(Boolean.valueOf(true));
        iMSRoleAdminPolicy.setAdminAssignable(Boolean.valueOf(false));
        Domain domain = this.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        Policy policy = this.makePolicy(string, domain);
        SetupConnection.createObject((XPSObject)policy);
        iMSRoleAdminPolicy.setPolicy(policy);
        IMSRoleScopeRule iMSRoleScopeRule = this.makeIMSRoleScopeRule(string);
        SetupConnection.createObject((XPSObject)iMSRoleScopeRule);
        iMSRoleAdminPolicy.setUserScopeRule(iMSRoleScopeRule);
        IMSRoleRule iMSRoleRule = this.makeIMSRoleRule(string);
        SetupConnection.createObject((XPSObject)iMSRoleRule);
        iMSRoleAdminPolicy.setTriggerRule(iMSRoleRule);
        List list = iMSRoleAdminPolicy.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSRoleAdminPolicy.setAdditionalProperties(list);
        return iMSRoleAdminPolicy;
    }

    public IMSRoleMemberPolicy makeIMSRoleMemberPolicy(String string) throws XPSException {
        IMSRoleMemberPolicy iMSRoleMemberPolicy = (IMSRoleMemberPolicy)SetupConnection.policyData.newObject((IClass)IMSRoleMemberPolicy.ddclass);
        IMSRole iMSRole = this.makeIMSRole(string);
        SetupConnection.createObject((XPSObject)iMSRole);
        iMSRoleMemberPolicy.setParent(iMSRole);
        Domain domain = this.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        Policy policy = this.makePolicy(string, domain);
        SetupConnection.createObject((XPSObject)policy);
        iMSRoleMemberPolicy.setPolicy(policy);
        IMSRoleRule iMSRoleRule = this.makeIMSRoleRule(string);
        SetupConnection.createObject((XPSObject)iMSRoleRule);
        iMSRoleMemberPolicy.setTriggerRule(iMSRoleRule);
        List list = iMSRoleMemberPolicy.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSRoleMemberPolicy.setAdditionalProperties(list);
        return iMSRoleMemberPolicy;
    }

    public IMSRoleOwnerPolicy makeIMSRoleOwnerPolicy(String string) throws XPSException {
        IMSRoleOwnerPolicy iMSRoleOwnerPolicy = (IMSRoleOwnerPolicy)SetupConnection.policyData.newObject((IClass)IMSRoleOwnerPolicy.ddclass);
        IMSRole iMSRole = this.makeIMSRole(string);
        SetupConnection.createObject((XPSObject)iMSRole);
        iMSRoleOwnerPolicy.setParent(iMSRole);
        Domain domain = this.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        Policy policy = this.makePolicy(string, domain);
        SetupConnection.createObject((XPSObject)policy);
        iMSRoleOwnerPolicy.setPolicy(policy);
        IMSIdentityPolicySet iMSIdentityPolicySet = this.makeIMSIdentityPolicySet(string);
        SetupConnection.createObject((XPSObject)iMSIdentityPolicySet);
        iMSRoleOwnerPolicy.setIdentityPolicySet(iMSIdentityPolicySet);
        IMSRoleRule iMSRoleRule = this.makeIMSRoleRule(string);
        SetupConnection.createObject((XPSObject)iMSRoleRule);
        iMSRoleOwnerPolicy.setTriggerRule(iMSRoleRule);
        List list = iMSRoleOwnerPolicy.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSRoleOwnerPolicy.setAdditionalProperties(list);
        return iMSRoleOwnerPolicy;
    }

    public IMSBLTH makeIMSBLTH(String string) throws XPSException {
        IMSBLTH iMSBLTH = (IMSBLTH)SetupConnection.policyData.newObject((IClass)IMSBLTH.ddclass);
        if (string != null) {
            iMSBLTH.setName(string);
        }
        IMSTask iMSTask = this.makeIMSTask(string);
        SetupConnection.createObject((XPSObject)iMSTask);
        iMSBLTH.setParent(iMSTask);
        iMSBLTH.setDescription("XPSAPI JUnit Sample IMSBLTH");
        iMSBLTH.setClassName("ClassName");
        iMSBLTH.setScript("Script");
        iMSBLTH.setScriptType(IMSBLTH.ScriptType.Java);
        iMSBLTH.setExecutionOrder(Integer.valueOf(1));
        List list = iMSBLTH.getAdditionalProperties();
        IMSAdditionalPropertiesSet iMSAdditionalPropertiesSet = this.makeIMSAdditionalPropertiesSet(string);
        SetupConnection.createObject((XPSObject)iMSAdditionalPropertiesSet);
        list.add(iMSAdditionalPropertiesSet);
        iMSBLTH.setAdditionalProperties(list);
        return iMSBLTH;
    }
}

