/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.netegrity.policyserver.smapi.SmAuthStatus;

public class SmAuthenticationResult {
    public static final int REASON_NONE = 0;
    public static final int REASON_PW_MUST_CHANGE = 1;
    public static final int REASON_INVALID_SESSION = 2;
    public static final int REASON_REVOKED_SESSION = 3;
    public static final int REASON_EXPIRED_SESSION = 4;
    public static final int REASON_AUTH_LEVEL_TOO_LOW = 5;
    public static final int REASON_UNKNOWN_USER = 6;
    public static final int REASON_USER_DISABLED = 7;
    public static final int REASON_INVALID_SESSION_ID = 8;
    public static final int REASON_INVALID_SESSION_IP = 9;
    public static final int REASON_CERTIFICATE_REVOKED = 10;
    public static final int REASON_CRL_OUT_OF_DATE = 11;
    public static final int REASON_CERT_REVOKED_KEY_COMPROMISED = 12;
    public static final int REASON_CERT_REVOKED_AFFILIATION_CHANGE = 13;
    public static final int REASON_CERT_ON_HOLD = 14;
    public static final int REASON_TOKEN_CARD_CHALLENGE = 15;
    public static final int REASON_IMPERSONATED_USER_NOT_IN_DIR = 16;
    public static final int REASON_ANONYMOUS = 17;
    public static final int REASON_PW_WILL_EXPIRE = 18;
    public static final int REASON_PW_EXPIRED = 19;
    public static final int REASON_IMMED_PW_CHANGE_REQUIRED = 20;
    public static final int REASON_PW_CHANGE_FAILED = 21;
    public static final int REASON_BAD_PW_CHANGE = 22;
    public static final int REASON_PW_CHANGE_ACCEPTED = 23;
    public static final int REASON_EXCESSIVE_FAILED_LOGIN_ATTEMPTS = 24;
    public static final int REASON_ACCOUNT_INACTIVITY = 25;
    public static final int REASON_NO_REDIRECT_CONFIGURED = 26;
    public static final int REASON_ERROR_MESSAGE_IS_REDIRECT = 27;
    public static final int REASON_NEXT_TOKEN_CODE = 28;
    public static final int REASON_NEW_PIN_SELECT = 29;
    public static final int REASON_NEW_PIN_SYS_TOKENCODE = 30;
    public static final int REASON_NEW_USER_PIN_TOKENCODE = 31;
    public static final int REASON_NEW_PIN_ACCEPTED = 32;
    public static final int REASON_GUEST = 33;
    public static final int REASON_PW_SELF_CHANGE = 34;
    public static final int REASON_SERVER_EXCEPTION = 35;
    public static final int REASON_UNKNOWN_SCHEME = 36;
    public static final int REASON_UNSUPPORTED_SCHEME = 37;
    public static final int REASON_MISCONFIGURED = 38;
    public static final int REASON_BUFFER_OVERFLOW = 39;
    public static final int REASON_SET_PERSISTENT_SESSION_FAILED = 40;
    public static final int REASON_USER_LOGOUT = 41;
    public static final int REASON_IDLE_SESSION = 42;
    public static final int REASON_POLICY_SERVER_ENFORCED_TIMEOUT = 43;
    public static final int REASON_POLICY_SERVER_ENFORCED_IDLE = 44;
    public static final int REASON_FEDERATION_NO_LOGIN_ID = 47;
    public static final int REASON_FEDERATION_USER_NOT_IN_DIR = 48;
    public static final int REASON_FEDERATION_INVALID_MESSAGE = 49;
    public static final int REASON_FEDERATION_UNACCEPTED_MESSAGE = 50;
    public static final int REASON_MAX_DEFINED = 50;
    private SmAuthStatus m_status;
    private int m_reason;

    public SmAuthenticationResult() {
        this.m_status = SmAuthStatus.SMAUTH_SUCCESS;
        this.m_reason = 0;
    }

    public SmAuthenticationResult(SmAuthStatus smAuthStatus, int n) {
        this.m_status = smAuthStatus;
        this.m_reason = n < 0 || n > 655535 ? 0 : n;
    }

    public SmAuthStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(SmAuthStatus smAuthStatus) {
        this.m_status = smAuthStatus;
    }

    public int getReason() {
        return this.m_reason;
    }

    public void setReason(int n) throws IllegalArgumentException {
        if (n < 0 || n > 655535) {
            throw new IllegalArgumentException("reason range is 0 to 65535");
        }
        this.m_reason = n;
    }

    protected int toInt() {
        return (this.m_reason & 0xFFFF) << 16 | this.m_status.toInt() & 0xFFFF;
    }

    public String toString() {
        return "reason " + this.m_reason + ", " + this.m_status;
    }
}

