/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.type;

import com.ca.siteminder.rpc.type.Tree;
import com.ca.siteminder.rpc.type.TypeConstants;

public class InStream
implements TypeConstants {
    int cur;
    int end;
    String buf;

    public InStream() {
        this.reset("");
    }

    public void reset(String string) {
        this.buf = string;
        this.cur = 0;
        this.end = this.buf.length();
    }

    char nextToken(StringPtr stringPtr) {
        if (this.cur == this.end) {
            return 'd';
        }
        char c = this.buf.charAt(this.cur);
        ++this.cur;
        int n = this.cur;
        while (this.buf.charAt(this.cur) != '\n') {
            ++this.cur;
        }
        stringPtr.value = this.buf.substring(n, this.cur);
        ++this.cur;
        return c;
    }

    public Tree nextTree() {
        return this.nextTree(null);
    }

    Tree nextTree(Tree tree) {
        StringPtr stringPtr = new StringPtr();
        char c = this.nextToken(stringPtr);
        if (c == 'd') {
            return null;
        }
        if (c == '>') {
            return null;
        }
        Tree tree2 = new Tree(stringPtr.value);
        if (c == '.') {
            c = this.nextToken(stringPtr);
            if (c != ':') {
                throw new RuntimeException("broken simple element : unexpected type " + c);
            }
            tree2.value = InStream.unescape(stringPtr.value);
        } else if (c == '<') {
            Tree tree3;
            tree2.firstChild = tree3 = this.getChildren(tree2);
        } else {
            throw new RuntimeException("broken tree: unexpected type " + c);
        }
        return tree2;
    }

    Tree getChildren(Tree tree) {
        Tree tree2;
        Tree tree3 = this.nextTree(tree);
        if (tree3 == null) {
            return tree3;
        }
        Tree tree4 = tree3;
        while ((tree2 = this.nextTree(tree)) != null) {
            tree4.nextSibling = tree2;
            tree4 = tree2;
        }
        return tree3;
    }

    static String unescape(String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (n3 == 92 && (n3 = string.charAt(++i)) == 110) {
                n3 = 10;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static class StringPtr {
        String value = null;

        StringPtr() {
        }
    }
}

