/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.rpc;

import com.ca.siteminder.rpc.rpc.CallContext;
import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.RpcConnection;
import com.ca.siteminder.rpc.rpc.Transport;
import com.ca.siteminder.rpc.rpc.TransportConstants;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RpcTransport
implements Transport,
TransportConstants,
ContextConstants {
    RpcConnection connection;
    Map parameters;
    Map serverParameters;
    String sessionId;
    String sessionCookie;

    private void moveParameter(String string) {
        Object v = this.parameters.get(string);
        if (v != null) {
            this.serverParameters.put(string, v);
        }
    }

    public void setParameters(Map map) {
        this.parameters = map;
        this.serverParameters = new HashMap();
        this.moveParameter("library");
        this.moveParameter("version");
        this.moveParameter("userId");
        this.moveParameter("sessionTicket");
        this.moveParameter("adminPwd");
        this.moveParameter("service");
        this.moveParameter("ns");
    }

    public void setConnection(RpcConnection rpcConnection) {
        this.connection = rpcConnection;
    }

    public void configureTaskManager(Map map) {
        StringBuffer stringBuffer = this.makeBuffer('\u0007');
        RpcTransport.encodeMap(map, stringBuffer);
        this.sendBuffer(stringBuffer);
    }

    public synchronized void connect(String string) {
        int n;
        if (string != null && string.length() > 0) {
            this.serverParameters.put("service", string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001');
        RpcTransport.encodeMap(this.serverParameters, stringBuffer);
        this.connection.connect(this.parameters);
        this.sessionId = this.sendBuffer(stringBuffer);
        if (this.sessionId == null || this.sessionId.length() == 0) {
            throw new RuntimeException("login failure");
        }
        if (this.sessionId != null && this.sessionId.startsWith("!!")) {
            String string2 = this.sessionId.substring(2);
            this.sessionId = null;
            throw new RuntimeException(string2);
        }
        if (this.sessionId.charAt(0) == '$' && (n = this.sessionId.indexOf(0)) > 0 && this.sessionId.charAt(n + 1) == '$') {
            this.sessionCookie = this.sessionId.substring(n + 2);
            this.sessionId = this.sessionId.substring(0, n);
        }
    }

    public synchronized void disconnect() {
        StringBuffer stringBuffer = this.makeBuffer('\u0003');
        this.sendBuffer(stringBuffer);
        this.sessionId = null;
        this.sessionCookie = null;
        this.connection.disconnect();
        this.connection = null;
    }

    public void send(String string, CallContext callContext) {
        StringBuffer stringBuffer = this.makeBuffer('\u0002');
        stringBuffer.append(string);
        callContext.currentMsg = this.sendBuffer(stringBuffer);
    }

    public void relogin(String string, CallContext callContext) {
        StringBuffer stringBuffer = this.makeBuffer('\b');
        stringBuffer.append(string);
        callContext.currentMsg = this.sendBuffer(stringBuffer);
    }

    public synchronized void cancel() {
        if (this.sessionId == null) {
            System.out.println("cancel too late");
            return;
        }
        System.out.println("canceling ..,");
        StringBuffer stringBuffer = this.makeBuffer('\u0005');
        this.sendBuffer(stringBuffer);
    }

    public String importClasses() {
        StringBuffer stringBuffer = this.makeBuffer('\u0006');
        return this.sendBuffer(stringBuffer);
    }

    public String getCurrentMessage(CallContext callContext) {
        String string = callContext.currentMsg;
        callContext.currentMsg = null;
        return string;
    }

    public String receive(boolean bl, CallContext callContext) {
        if (callContext.currentMsg != null) {
            String string = callContext.currentMsg;
            callContext.currentMsg = null;
            return string;
        }
        if (!bl) {
            return null;
        }
        StringBuffer stringBuffer = this.makeBuffer('\u0004');
        String string = "";
        int n = 5;
        int n2 = 5000;
        int n3 = 0;
        while (string.length() == 0) {
            ++n3;
            if ((n *= 2) > n2) {
                n = n2;
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            string = this.sendBuffer(stringBuffer);
        }
        return string;
    }

    static void encodeMap(Map map, StringBuffer stringBuffer) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            stringBuffer.append(entry.getKey()).append('\u0000');
            stringBuffer.append(entry.getValue().toString()).append('\u0000');
        }
    }

    StringBuffer makeBuffer(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        stringBuffer.append(this.sessionId).append('\u0000');
        if (this.sessionId != null && this.sessionId.charAt(0) == '$') {
            stringBuffer.append('$');
            stringBuffer.append(this.sessionCookie);
            stringBuffer.append('\u0000');
        }
        return stringBuffer;
    }

    String sendBuffer(StringBuffer stringBuffer) {
        String string;
        byte[] byArray;
        try {
            byArray = stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        byte[] byArray2 = this.connection.send(byArray);
        if (byArray2 != null) {
            try {
                string = new String(byArray2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        } else {
            string = "";
        }
        return string;
    }

    public int getServerRpcVersion() {
        if (this.sessionId == null || this.sessionId.length() == 0) {
            return -1;
        }
        if (this.sessionId.charAt(0) != '$') {
            return 0;
        }
        return this.sessionId.charAt(1) - 48;
    }

    public void setCookie(String string) {
        if (string != null) {
            this.sessionCookie = string;
        }
    }
}

