/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.rpc;

import com.ca.siteminder.rpc.rpc.ApplicationContext;
import com.ca.siteminder.rpc.rpc.CallContext;
import com.ca.siteminder.rpc.rpc.ClientDispatcher;
import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.LocalConnection;
import com.ca.siteminder.rpc.rpc.RpcConnection;
import com.ca.siteminder.rpc.rpc.ServiceProxy;
import com.ca.siteminder.rpc.rpc.Transport;
import com.ca.siteminder.rpc.rpc.TunnelConnection;
import com.ca.siteminder.rpc.type.TypeRegistry;
import com.ca.siteminder.rpc.type.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class RpcContext
implements ContextConstants {
    Class service;
    Transport transport;
    ClientDispatcher dispatcher;

    public RpcContext(TypeRegistry typeRegistry, Map map) {
        String string;
        boolean bl = map.containsKey("local");
        RpcConnection rpcConnection = bl ? new LocalConnection() : new TunnelConnection();
        this.setup(typeRegistry, rpcConnection.getTransport());
        map.put("library", typeRegistry.getLibraryName());
        map.put("version", new Integer(typeRegistry.getVersion()));
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        map.put("clientIP", string);
        this.transport.setParameters(map);
    }

    void setup(TypeRegistry typeRegistry, Transport transport) {
        ResourceBundle resourceBundle;
        this.transport = transport;
        try {
            Package package_ = typeRegistry.getClass().getPackage();
            String string = package_.getName() + "." + "ErrorMessages";
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        this.dispatcher = new ClientDispatcher(resourceBundle, typeRegistry, transport);
    }

    public RpcContext(TypeRegistry typeRegistry, Transport transport) {
        this.setup(typeRegistry, transport);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.dispatcher.SetApplicationContext(applicationContext);
    }

    public void relogin(String string, String string2, CallContext callContext) {
        this.dispatcher.relogin(string, string2, callContext);
    }

    public Object lookup(Class clazz) {
        return this.lookup(clazz, null);
    }

    public Object lookup(Class clazz, Object object) {
        this.service = clazz;
        String string = Util.simpleNameOf(clazz);
        this.transport.connect(string);
        this.dispatcher.setProxyInterface(this.service);
        if (object != null) {
            this.dispatcher.setCallback(this.service, object);
        }
        int n = this.transport.getServerRpcVersion();
        this.dispatcher.setServerRpcVersion(n);
        if (n < 2) {
            this.dispatcher.instantiate(clazz);
        }
        return ServiceProxy.getProxy(clazz, this.dispatcher);
    }

    public int getServerRpcVersion() {
        return this.dispatcher.getServerRpcVersion();
    }

    public void setCallback(Object object) {
        this.dispatcher.setCallback(this.service, object);
    }

    public void release() {
        CallContext callContext = this.dispatcher.newCallContext();
        callContext.ser.done();
        String string = callContext.ser.getMessages();
        this.transport.send(string, callContext);
        this.transport.disconnect();
    }

    public void cancel() {
        if (this.transport != null) {
            this.transport.cancel();
        }
    }

    public String importClasses() {
        return this.transport.importClasses();
    }

    public void configureTaskManager(Map map) {
        this.transport.configureTaskManager(map);
    }
}

