/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.rpc;

import com.ca.siteminder.rpc.rpc.ApplicationContext;
import com.ca.siteminder.rpc.rpc.ApplicationError;
import com.ca.siteminder.rpc.rpc.ApplicationFault;
import com.ca.siteminder.rpc.rpc.CallContext;
import com.ca.siteminder.rpc.rpc.Dispatcher;
import com.ca.siteminder.rpc.rpc.SystemError;
import com.ca.siteminder.rpc.rpc.Transport;
import com.ca.siteminder.rpc.type.InterfaceType;
import com.ca.siteminder.rpc.type.Tree;
import com.ca.siteminder.rpc.type.TypeRegistry;
import com.ca.siteminder.rpc.type.Util;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ClientDispatcher
extends Dispatcher {
    private static final Logger logger = Logger.getLogger(ClientDispatcher.class);
    ResourceBundle bundle;
    int serverRpcVersion;

    public int getServerRpcVersion() {
        return this.serverRpcVersion;
    }

    public void setServerRpcVersion(int n) {
        this.serverRpcVersion = n;
    }

    public ClientDispatcher(ResourceBundle resourceBundle, TypeRegistry typeRegistry, Transport transport) {
        super(typeRegistry, transport);
        this.bundle = resourceBundle;
    }

    public void setCallback(Class clazz, Object object) {
        InterfaceType interfaceType = this.reg.getCallback(clazz);
        this.setInstance(object, interfaceType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dispatch(Tree tree, CallContext callContext) {
        if (tree == null) {
            return;
        }
        String string = tree.tag;
        Tree tree2 = tree.firstChild;
        if (string.equals("mcall")) {
            this.callback(tree, callContext);
            return;
        } else if (string.equals("return")) {
            this.retval(tree.firstChild, callContext);
            return;
        } else if (string.equals("done")) {
            this.done(callContext);
            return;
        } else if (string.equals("fault")) {
            this.fault(tree, callContext);
            return;
        } else {
            if (this.getServerRpcVersion() < 2) throw new RuntimeException("Unknown Message " + string);
            if (string.equals("bg")) {
                callContext.isBG = true;
                return;
            } else if (string.equals("cookie")) {
                this.setCookie(tree);
                return;
            } else {
                if (!string.equals("reset")) throw new RuntimeException("rpc version 2 Message " + string);
                this.resetSession(tree.firstChild, callContext);
            }
        }
    }

    void callback(Tree tree, CallContext callContext) {
        this.mcall(tree, callContext);
    }

    void fault(Tree tree, CallContext callContext) {
        Object object4;
        Object object2;
        Tree tree2 = tree.firstChild;
        String string = tree2.value;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Tree tree3 = tree2.nextSibling;
        String string2 = "UnknownError";
        Object object3 = null;
        if (tree3 != null && tree3.tag.equals("exception")) {
            object2 = tree3.firstChild;
            string2 = ((Tree)object2).tag;
            try {
                object3 = this.des.deserialize((Tree)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            tree3 = tree3.nextSibling;
        }
        while (tree3 != null) {
            object2 = this.des.deserialize(tree3);
            arrayList.add(object2);
            tree3 = tree3.nextSibling;
        }
        object2 = new StringBuffer(string);
        for (Object object4 : arrayList) {
            ((StringBuffer)object2).append(" '").append(object4).append("'");
        }
        boolean bl = true;
        if (object3 == null) {
            if (string != null && string.equals("sys")) {
                string2 = "SystemError";
                if (arrayList.size() == 1 && ((String)(object4 = (String)arrayList.get(0))).startsWith("session ") && ((String)object4).endsWith(" does not exist")) {
                    string = "session.lost";
                    bl = false;
                }
                object3 = new SystemError(string);
            } else {
                string2 = "ApplicationError";
                object3 = new ApplicationError(string);
            }
        }
        if (!(object3 instanceof ApplicationFault)) {
            System.out.println("bad Exception class: " + string2);
            object3 = new ApplicationError(string);
        }
        object4 = "fault " + string2 + "(" + object3 + ") " + object2;
        if (bl) {
            logger.error(object4);
        } else {
            logger.info(object4);
        }
        callContext.fault = (ApplicationFault)object3;
        callContext.fault.setTag(string);
        callContext.fault.setArgs(arrayList.toArray());
        callContext.fault.setBundle(this.bundle);
        throw callContext.fault;
    }

    void retval(Tree tree, CallContext callContext) {
        callContext.retValue = tree == null ? null : this.des.deserialize(tree);
        callContext.isDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object called(Method method, Object[] objectArray) {
        int n = this.getServerRpcVersion();
        if (n < 2) {
            ClientDispatcher clientDispatcher = this;
            synchronized (clientDispatcher) {
                return this.calledImpl(method, objectArray);
            }
        }
        return this.calledImpl(method, objectArray);
    }

    Object calledImpl(Method method, Object[] objectArray) {
        CallContext callContext = this.newCallContext();
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("call ").append(method.getName());
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(" ").append(objectArray[i]);
                }
            }
            logger.debug((Object)stringBuffer);
        }
        try {
            return this.trycall(method, objectArray, callContext);
        }
        catch (ResetServerSessionException resetServerSessionException) {
            return this.trycall(method, objectArray, callContext);
        }
    }

    Object trycall(Method method, Object[] objectArray, CallContext callContext) {
        String string = this.proxyType.getMethodSignature(method);
        callContext.ser.mcall(string, objectArray);
        int n = this.getServerRpcVersion();
        callContext.isVoid = method.getReturnType() == Void.TYPE;
        String string2 = callContext.ser.getMessages();
        this.transport.send(string2, callContext);
        if (callContext.isVoid && n < 2) {
            this.checkError(callContext);
            return null;
        }
        callContext.retValue = null;
        callContext.fault = null;
        if (n < 2) {
            this.process(callContext);
        } else {
            this.processV2(callContext);
        }
        if (callContext.isDone) {
            return callContext.retValue;
        }
        return null;
    }

    public void instantiate(Class clazz) {
        CallContext callContext = this.newCallContext();
        String string = Util.simpleNameOf(clazz);
        callContext.ser.instantiate(string);
        String string2 = callContext.ser.getMessages();
        this.transport.send(string2, callContext);
        this.checkError(callContext);
    }

    public void relogin(String string, String string2, CallContext callContext) {
        callContext.ser.relogin(string, string2);
        String string3 = callContext.ser.getMessages();
        this.transport.relogin(string3, callContext);
        this.checkError(callContext);
    }

    private void checkError(CallContext callContext) {
        String string = this.transport.getCurrentMessage(callContext);
        if (string != null && string.length() > 0) {
            this.processError(string, callContext);
        }
    }

    void setCookie(Tree tree) {
        if (tree == null) {
            return;
        }
        Tree tree2 = tree.firstChild;
        if (tree2 == null) {
            return;
        }
        String string = tree2.value;
        this.transport.setCookie(string);
    }

    void resetSession(Tree tree, CallContext callContext) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (tree != null) {
            string = tree.tag;
            string2 = tree.value;
            if (string2 != null) {
                bl = string2.equals("1");
            }
        }
        boolean bl2 = false;
        ApplicationContext applicationContext = callContext.ser.getApplicationContext();
        if (applicationContext != null) {
            bl2 = applicationContext.onResetServerSession(string, callContext.isBG, bl, callContext);
        }
        if (bl2) {
            if (callContext.isBG || bl) {
                throw new ResetServerSessionException(string, bl);
            }
        } else {
            throw new SystemError("cannot reset session");
        }
    }

    class ResetServerSessionException
    extends RuntimeException {
        public String tag;
        public boolean needRelogin;

        public ResetServerSessionException(String string, boolean bl) {
            this.tag = string;
            this.needRelogin = bl;
        }
    }
}

