/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.rpc;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ApplicationFault
extends RuntimeException {
    private Object[] args;
    private ResourceBundle bundle;
    private static final String sysMessage = "System Error: {0}";
    private String tag;

    protected ApplicationFault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        this.tag = string;
        this.bundle = resourceBundle;
        this.args = objectArray;
    }

    protected ApplicationFault(String string, Object[] objectArray) {
        this.tag = string;
        this.args = objectArray;
    }

    protected ApplicationFault(String string) {
        this.tag = string;
    }

    protected ApplicationFault() {
    }

    void setTag(String string) {
        this.tag = string;
    }

    public String getTag() {
        return this.tag;
    }

    protected void setArgs(Object[] objectArray) {
        this.args = objectArray;
    }

    void setArgs(Object object) {
        if (object == null) {
            this.args = null;
        } else if (object instanceof Object[]) {
            this.args = (Object[])object;
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            this.args = collection.toArray();
        } else {
            this.args = new Object[]{object};
        }
    }

    public Object[] getArgs() {
        return this.args;
    }

    void setBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getMessage() {
        Throwable throwable = super.getCause();
        if (throwable != null) {
            return throwable.getMessage();
        }
        if (this.tag == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.tag);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                stringBuffer.append(" ").append(this.args[i]);
            }
        }
        return stringBuffer.toString();
    }

    public String getLocalizedMessage() {
        Throwable throwable = super.getCause();
        if (throwable != null) {
            return throwable.getLocalizedMessage();
        }
        return this.bundle == null ? this.getMessage() : this.formatMessage();
    }

    String formatMessage() {
        String string;
        if (this.tag.equals("sys")) {
            string = sysMessage;
        } else {
            try {
                string = this.bundle.getString(this.tag);
            }
            catch (MissingResourceException missingResourceException) {
                return this.getMessage();
            }
        }
        return MessageFormat.format(string, this.args);
    }
}

