/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.tools;

import com.ca.siteminder.rpcutil.BeanUtil;
import com.ca.siteminder.rpcutil.CommandLineOptions;
import com.ca.siteminder.rpcutil.IOUtil;
import com.ca.siteminder.sdk.adminapi.ConnectionHelper;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.ca.xps.Product;
import com.ca.siteminder.sdk.adminapi.ca.xps.Vendor;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.dd.IProduct;
import com.ca.siteminder.sdk.adminapi.tools.ClassHelper;
import com.ca.siteminder.sdk.adminapi.tools.ProductHelper;
import com.ca.siteminder.sdk.adminapi.tools.Unpack;
import com.ca.siteminder.sdk.adminapi.tools.VendorHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import netegrity.siteminder.javaagent.AgentAPI;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class SdkBuilder {
    public static final String fileMarkup = "====file:";
    String templateFile;
    Writer writer;
    Template template;
    Session session;
    boolean silent = false;
    static Session session_;

    void init() throws Exception {
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init();
        this.template = Velocity.getTemplate((String)this.templateFile);
        VendorHelper.init(this.session);
    }

    public SdkBuilder(Options options, Session session, Writer writer) throws Exception {
        this.templateFile = options.template;
        this.silent = options.silent;
        this.writer = writer;
        this.session = session;
        this.init();
    }

    void run(Product product, Class clazz) throws Exception {
        ProductHelper productHelper = ProductHelper.get((IProduct)product);
        ClassHelper classHelper = ClassHelper.get((IClass)clazz);
        productHelper.setSpecialClass(classHelper);
        this.run(productHelper);
    }

    void run(Product product) throws Exception {
        ProductHelper productHelper = ProductHelper.get((IProduct)product);
        this.run(productHelper);
    }

    void run(ProductHelper productHelper) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("product", (Object)productHelper);
        velocityContext.put("fileMarkup", (Object)fileMarkup);
        velocityContext.put("date", (Object)(new Date().getTime() / 1000L));
        this.template.merge((Context)velocityContext, this.writer);
        this.writer.flush();
    }

    void run(VendorHelper vendorHelper) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("vendor", (Object)vendorHelper);
        velocityContext.put("fileMarkup", (Object)fileMarkup);
        velocityContext.put("date", (Object)(new Date().getTime() / 1000L));
        this.template.merge((Context)velocityContext, this.writer);
        this.writer.flush();
    }

    void run(Vendor vendor, boolean bl) throws Exception {
        if (bl) {
            VendorHelper vendorHelper = new VendorHelper(vendor);
            this.run(vendorHelper);
        } else {
            List list = vendor.getProducts();
            for (Product product : list) {
                this.run(product);
            }
        }
    }

    public static void setSession(Session session) {
        session_ = session;
    }

    public static boolean doExit(String string) {
        System.err.println(string);
        System.exit(1);
        return false;
    }

    static boolean processOptions(String[] stringArray, Options options) throws IOException {
        boolean bl;
        boolean bl2 = options.process(stringArray, (Object)options);
        if (!bl2) {
            return SdkBuilder.doExit("errors in parameters");
        }
        if (options.debug) {
            BeanUtil.printFields((Object)((Object)options));
        }
        if (options.out != null && !(bl = IOUtil.checkOutputFilename((String)options.out))) {
            return SdkBuilder.doExit("cannot create output file:" + options.out);
        }
        if (options.classname != null && options.installDir != null) {
            return SdkBuilder.doExit("-classname and -installdir are mutually exclusive options");
        }
        if (options.language >= 0) {
            options.template = "templates/" + Options.languages[options.language] + ".vm";
        }
        return true;
    }

    static boolean setupSession(Options options) throws Exception {
        ConnectionHelper connectionHelper = new ConnectionHelper();
        boolean bl = false;
        Map map = options.properties != null ? connectionHelper.propertiesToMap(new String[]{options.properties}) : new HashMap();
        if (options.properties == null && options.admin == null && options.password == null && options.psip == null) {
            map.put("local", "true");
            bl = true;
        }
        if (options.admin != null) {
            map.put("PS_ADMIN_NAME", options.admin);
        }
        if (options.password != null) {
            map.put("PS_ADMIN_PWD", options.password);
        }
        if (options.psip != null) {
            map.put("PS_IP", options.psip);
        } else if (!map.containsKey("PS_IP")) {
            map.put("PS_IP", "127.0.0.1");
        }
        session_ = new Session();
        if (!bl) {
            AgentAPI agentAPI = connectionHelper.connect(map);
            connectionHelper.PMAPI_login();
            session_.setContext(connectionHelper.toMap());
        }
        session_.connect();
        return true;
    }

    static void startMessage(boolean bl, String string) {
        if (!bl) {
            System.out.print(string + " ... ");
            System.out.flush();
        }
    }

    static void doneMessage(boolean bl) {
        if (!bl) {
            System.out.println("done");
            System.out.flush();
        }
    }

    public static void main(String ... stringArray) throws Exception {
        Options options = new Options();
        boolean bl = SdkBuilder.processOptions(stringArray, options);
        if (!bl) {
            return;
        }
        if (options.installDir != null && options.out == null) {
            options.out = File.createTempFile("jjjout", ".txt").getAbsolutePath();
        }
        if (options.out == null) {
            options.silent = true;
        }
        if (session_ == null) {
            SdkBuilder.setupSession(options);
        }
        Writer writer = options.out != null ? new BufferedWriter(new FileWriter(options.out)) : new OutputStreamWriter(System.out);
        writer.write(new Date().toString() + "\n");
        SdkBuilder sdkBuilder = new SdkBuilder(options, session_, writer);
        if (options.vendor != null) {
            SdkBuilder.startMessage(options.silent, "generating vendor " + options.vendor);
            Vendor vendor = session_.getDictionary().fetchVendor(options.vendor);
            sdkBuilder.run(vendor, options.servicegeneration);
            SdkBuilder.doneMessage(options.silent);
        } else if (options.product != null) {
            SdkBuilder.startMessage(options.silent, "generating product " + options.product);
            Product product = session_.getDictionary().fetchProduct(options.product);
            sdkBuilder.run(product);
            SdkBuilder.doneMessage(options.silent);
        } else {
            Class clazz = session_.getDictionary().fetchClass(options.classname);
            Product product = clazz.getProduct();
            Vendor vendor = product.getVendor();
            sdkBuilder.run(product, clazz);
        }
        if (options.installDir != null) {
            SdkBuilder.startMessage(options.silent, "insalling into " + options.installDir);
            Unpack.main("-dir", options.installDir, "-file", options.out);
            SdkBuilder.doneMessage(options.silent);
        }
    }

    public static Session getSession() {
        return session_;
    }

    public static class Options
    extends CommandLineOptions {
        public boolean servicegeneration = false;
        public boolean debug = false;
        public String out = null;
        public boolean silent = false;
        public String product = null;
        public String vendor = null;
        public String classname = null;
        public String template = null;
        public String admin;
        public String password;
        public String psip;
        public String properties;
        public String installDir;
        public int language = -1;
        static String[] languages = new String[]{"java", "cpp", "perl"};

        Options() {
            super("SdkBuilder");
            this.addSwitch("-silent", "false", null);
            this.oneOf(this.addOptional("-product", "product id, e.g. CA.EPM"), this.addOptional("-vendor", "vendor name"), this.addOptional("-classname", null));
            this.addOptional("-out", "output filename");
            this.addSwitch("-servicegeneration", "true", null);
            this.addSwitch("-debug", "true", null);
            this.addOptional("-admin", "SM admin");
            this.addOptional("-password", "SM admin password");
            this.addOptional("-psip", "Policy Server ip adress or name");
            this.addOptional("-properties", "properties file containing data for agent connection");
            this.addOptional("-installDir", "directory to install generated classes");
            this.oneOf(this.addEnum("-language", languages, "language to generate Sdk for"), this.addOptional("-template", null));
        }
    }
}

