/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.tools;

import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.tools.AttributeHelper;
import com.ca.siteminder.sdk.adminapi.tools.Named;
import com.ca.siteminder.sdk.adminapi.tools.ProductHelper;
import com.ca.siteminder.sdk.adminapi.tools.SdkBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper
extends Named {
    private IClass<? extends XPSObject> iclass;
    private ProductHelper productHelper;
    private List<AttributeHelper> attributes;
    private List<AttributeHelper> relations;
    private List<ClassHelper> children;
    private static IClass<? extends XPSObject> metadataClass;
    static Map<IClass, ClassHelper> classes;
    static List<Class> classList;
    static List<Attribute> attrList;

    public String getPrefixName() {
        return this.productHelper.getUname() + this.iclass.getName();
    }

    public List<AttributeHelper> getRelations() {
        return this.relations;
    }

    public List<ClassHelper> getChildren() {
        return this.children;
    }

    public boolean isClassHasNameAttribute() {
        boolean bl = false;
        for (AttributeHelper attributeHelper : this.attributes) {
            if (!attributeHelper.getFullName().equalsIgnoreCase("Name")) continue;
            bl = true;
            break;
        }
        if (!bl && this.isExtension()) {
            return this.getBaseOrExt().isClassHasNameAttribute();
        }
        return bl;
    }

    private static String name(IClass<? extends XPSObject> iClass) {
        if (iClass.getFQName().equalsIgnoreCase("CA.XPS::Metadata")) {
            metadataClass = iClass;
            return "XPSObject";
        }
        return iClass.getName();
    }

    public String getNameInDoubleQuotes() {
        return "\"" + this.iclass.getName() + "\"";
    }

    static boolean isMetadata(ClassHelper classHelper) {
        return classHelper.iclass == metadataClass;
    }

    static boolean isMetadata(IClass iClass) {
        return iClass == metadataClass;
    }

    ClassHelper(IClass<? extends XPSObject> iClass, ProductHelper productHelper) {
        super(ClassHelper.name(iClass));
        this.iclass = iClass;
        this.productHelper = productHelper;
        classes.put(iClass, this);
        this.attributes = new ArrayList<AttributeHelper>();
        List list = iClass.getAttributes();
        for (IAttribute iAttribute : list) {
            if (iAttribute.isCalculated()) continue;
            this.attributes.add(new AttributeHelper(iAttribute));
        }
    }

    void finishCreation() {
        String string = this.iclass.getFQName();
        List<IClass<? extends XPSObject>> list = ClassHelper.getChildClasses(string);
        this.children = new ArrayList<ClassHelper>();
        for (IClass<? extends XPSObject> object2 : list) {
            this.children.add(ClassHelper.get(object2));
        }
        List<Attribute> list2 = ClassHelper.getLinkageAttributes(string);
        this.relations = new ArrayList<AttributeHelper>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.relations.add(AttributeHelper.get((IAttribute)attribute));
        }
    }

    public ClassHelper getParentClass() {
        if (this.isExtension()) {
            return null;
        }
        IClass iClass = this.iclass.getParentClass();
        return iClass == null ? null : ClassHelper.get(iClass);
    }

    public String getFqname() {
        return this.iclass.getFQName();
    }

    public String getJavaClassName() {
        return this.iclass.getDynamicJavaClass().getCanonicalName();
    }

    public ProductHelper getProduct() {
        return this.productHelper;
    }

    public List<AttributeHelper> getAttributes() {
        return this.attributes;
    }

    public boolean isExtension() {
        return this.iclass.isExtension();
    }

    public ClassHelper getBase() {
        IClass iClass = this.iclass.getBaseClass();
        return ClassHelper.get(iClass);
    }

    static ClassHelper get(IClass iClass) {
        return classes.get(iClass);
    }

    Set<ClassHelper> getReferencedClasses(boolean bl) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!this.iclass.isExtension() && (object = this.iclass.getParentClass()) != null) {
            hashSet.add(object);
        }
        object = this.iclass.getAttributes();
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            IClass iClass;
            IAttribute iAttribute = (IAttribute)object2.next();
            if (iAttribute.getDataType() != IAttribute.DataType.Link || (iClass = iAttribute.getLinkToClass()) == null) continue;
            hashSet.add(iClass);
        }
        object2 = new HashSet();
        for (IClass iClass : hashSet) {
            if (bl && iClass.getProduct().equals(this.productHelper.product)) continue;
            object2.add(ClassHelper.get(iClass));
        }
        return object2;
    }

    public Set<ClassHelper> getReferencedClassesFromOtherPackages() {
        return this.getReferencedClasses(true);
    }

    public Set<ClassHelper> getReferencedClasses() {
        return this.getReferencedClasses(false);
    }

    public ClassHelper getBaseOrExt() {
        return this.isExtension() ? this.getBase() : this.getParentClass();
    }

    public String getExtraDeclarationsCpp() {
        String string = this.getFqname();
        if ("CA.XPS::Class".equalsIgnoreCase(string)) {
            return "ADMINAPIEXPORT Attribute getAttribute(const char* name);\n   ADMINAPIEXPORT operator ::xps::IClass& () const;";
        }
        if ("CA.XPS::Attribute".equalsIgnoreCase(string)) {
            return "ADMINAPIEXPORT operator ::xps::IAttribute&() const;";
        }
        return null;
    }

    static synchronized List<IClass<? extends XPSObject>> getChildClasses(String string) {
        Object object;
        if (classList == null) {
            object = SdkBuilder.getSession().getDictionary();
            classList = object.search1((IClass)Class.ddclass);
        }
        object = new ArrayList();
        for (Class clazz : classList) {
            if (clazz.getParentClass() == null || clazz.isExtension() || !string.equalsIgnoreCase(clazz.getParentClass().getFQName())) continue;
            object.add(clazz);
        }
        return object;
    }

    static synchronized List<Attribute> getLinkageAttributes(String string) {
        Object object;
        if (attrList == null) {
            object = SdkBuilder.getSession().getDictionary();
            attrList = object.search1((IClass)Attribute.ddclass);
        }
        object = new ArrayList();
        for (Attribute attribute : attrList) {
            String string2;
            Class clazz;
            if (attribute.getDataType() != IAttribute.DataType.Link || (clazz = attribute.getLinkToClass()) == null || !string.equalsIgnoreCase(string2 = clazz.getFQName())) continue;
            object.add(attribute);
        }
        return object;
    }

    public int hashCode() {
        return this.getFqname().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClassHelper)) {
            return false;
        }
        ClassHelper classHelper = (ClassHelper)object;
        return this.getFqname().equals(classHelper.getFqname());
    }

    static {
        classes = new HashMap<IClass, ClassHelper>();
    }
}

