/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.tools;

import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IBit;
import com.ca.siteminder.sdk.adminapi.tools.BitHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitMasksHelper {
    IAttribute attr;
    int minValue;
    int maxValue;
    List<BitHelper> bits;

    public List<BitHelper> getBits() {
        return this.bits;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    BitMasksHelper(IAttribute iAttribute) {
        this.attr = iAttribute;
        this.bits = new ArrayList<BitHelper>();
        for (IBit iBit : iAttribute.getBits()) {
            this.bits.add(new BitHelper(iBit));
        }
        Comparator<BitHelper> comparator = new Comparator<BitHelper>(){

            @Override
            public int compare(BitHelper bitHelper, BitHelper bitHelper2) {
                int n;
                int n2 = bitHelper.getBitMask();
                if (n2 == (n = bitHelper2.getBitMask())) {
                    return 0;
                }
                return n2 < n ? -1 : 1;
            }
        };
        Collections.sort(this.bits, comparator);
        int n = this.bits.size();
        if (n == 0) {
            this.minValue = -1;
            this.maxValue = -1;
        } else {
            this.minValue = this.bits.get(0).getBitMask();
            this.maxValue = this.bits.get(n - 1).getBitMask();
        }
    }
}

