/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.tools;

import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.tools.ClassHelper;
import com.ca.siteminder.sdk.adminapi.tools.EnumHelper;
import com.ca.siteminder.sdk.adminapi.tools.FlagsHelper;
import com.ca.siteminder.sdk.adminapi.tools.Named;
import java.util.HashMap;
import java.util.Map;

public class AttributeHelper
extends Named {
    private IAttribute attribute;
    IAttribute.Handling handling;
    IAttribute.DataType dataType;
    IAttribute.APIAccess access;
    private FlagsHelper flagsHelper;
    private EnumHelper enumHelper;
    static Map<IAttribute, AttributeHelper> attributes = new HashMap<IAttribute, AttributeHelper>();

    static AttributeHelper get(IAttribute iAttribute) {
        return attributes.get(iAttribute);
    }

    public AttributeHelper(IAttribute iAttribute) {
        super(AttributeHelper.normalizeName(iAttribute));
        this.attribute = iAttribute;
        this.dataType = iAttribute.getDataType();
        this.handling = iAttribute.getHandling();
        this.access = iAttribute.getAPIAccess();
        if (this.dataType == IAttribute.DataType.Integer) {
            if (this.isEnumAttr()) {
                this.enumHelper = new EnumHelper(iAttribute);
            } else if (this.isFlagsAttr()) {
                this.flagsHelper = new FlagsHelper(iAttribute);
            }
        }
        attributes.put(iAttribute, this);
    }

    private static String normalizeName(IAttribute iAttribute) {
        IClass iClass;
        String string = iAttribute.getName();
        IClass iClass2 = iAttribute.getAttributeClass();
        if (iClass2.isExtension() && (iClass = iClass2.getBaseClass()).getAttribute(string) != null) {
            ClassHelper classHelper = ClassHelper.get(iClass2);
            string = classHelper.getName() + string;
        }
        if (iAttribute.getDataType() == IAttribute.DataType.Link && string.endsWith("Link") && string.length() > 7) {
            string = string.substring(0, string.length() - 4);
        }
        if (string.equalsIgnoreCase("Class")) {
            string = "_class";
        } else if (string.equalsIgnoreCase("Origin")) {
            string = "_origin";
        }
        return string;
    }

    public String getFullName() {
        return this.attribute.getName();
    }

    public String getFQName() {
        return this.attribute.getFQName();
    }

    public String getFQNameInDoubleQuotes() {
        String string = this.attribute.getFQName();
        return "\"" + string + "\"";
    }

    public boolean isReadOnly() {
        return this.attribute.getAPIAccess() == IAttribute.APIAccess.ReadOnly || this.attribute.isCalculated();
    }

    public boolean isAccesible() {
        return this.attribute.getAPIAccess() != IAttribute.APIAccess.None;
    }

    public boolean isList() {
        return this.attribute.isList();
    }

    public boolean isLink() {
        return this.dataType == IAttribute.DataType.Link;
    }

    public int getMaxCount() {
        return this.attribute.getMaxElements();
    }

    public int getMinCount() {
        return this.attribute.getMinElements();
    }

    public String getType() {
        String string = this.dataType.getClassName();
        if (this.dataType == IAttribute.DataType.Link) {
            IClass iClass = this.attribute.getLinkToClass();
            ClassHelper classHelper = ClassHelper.get(iClass);
            string = classHelper.getName();
        }
        return string;
    }

    public String getClassName() {
        String string = this.attribute.getAttributeClass().getName();
        return string;
    }

    public ClassHelper getLinkClass() {
        if (this.dataType != IAttribute.DataType.Link) {
            return null;
        }
        IClass iClass = this.attribute.getLinkToClass();
        return ClassHelper.get(iClass);
    }

    public boolean isLinkClassHasNameAttribute() {
        if (this.dataType != IAttribute.DataType.Link) {
            return false;
        }
        IClass iClass = this.attribute.getLinkToClass();
        ClassHelper classHelper = ClassHelper.get(iClass);
        return classHelper.isClassHasNameAttribute();
    }

    public String getDataType() {
        return this.dataType.name();
    }

    public String getHandling() {
        return this.handling.name();
    }

    public String getAccess() {
        return this.access.name();
    }

    public boolean isEnumAttr() {
        return this.handling == IAttribute.Handling.Enumeration;
    }

    public boolean isFlagsAttr() {
        return this.handling == IAttribute.Handling.Flags;
    }

    public FlagsHelper getFlags() {
        return this.flagsHelper;
    }

    public EnumHelper getEnum() {
        return this.enumHelper;
    }
}

