/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.netegrity.util.AesKeyWrapper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class SmServerCrypto {
    final String RC2SHA_FORMAT = "{RC2}";
    final String AES_FORMAT = "{AES}";
    private static boolean c_bStubbed = false;
    private static byte[] c_masterKey = SmServerCrypto.generateMasterKey();
    private static byte[] c_psKey = null;
    private static byte[] c_ksKey = null;
    private static boolean c_isFIPS = false;
    private boolean m_isKeyStore = false;

    public SmServerCrypto(boolean isKeyStore) {
        this.m_isKeyStore = isKeyStore;
    }

    public String encrypt(byte[] input) throws SmCryptoProviderException, UnsupportedEncodingException {
        if (c_bStubbed || input == null) {
            return null;
        }
        String inputString = new String(input, "UTF-8");
        String format = c_isFIPS ? "{AES}" : "{RC2}";
        if (inputString.startsWith(format)) {
            return inputString;
        }
        byte[] key = this.decryptInternal(c_masterKey, this.getEncryptionKey());
        byte[] outputBytes = this.encryptInternal(key, input);
        String output = format + new String(outputBytes, "UTF-8");
        Arrays.fill(outputBytes, (byte)0);
        Arrays.fill(key, (byte)0);
        return output;
    }

    byte[] encryptInternal(byte[] key, byte[] input) throws SmCryptoProviderException, UnsupportedEncodingException {
        if (!c_isFIPS) {
            SmCryptoProvider provider = SmCryptoProvider.getInstance("RC2/SHA", null, true);
            provider.init(key, key, null, 128, true);
            return provider.encrypt(input);
        }
        AesKeyWrapper aesKeyWrapper = new AesKeyWrapper(key);
        return aesKeyWrapper.WrapAscii(input, input.length);
    }

    public byte[] decrypt(String input) throws SmCryptoProviderException, UnsupportedEncodingException {
        String format;
        if (c_bStubbed || input == null) {
            return null;
        }
        String string = format = c_isFIPS ? "{AES}" : "{RC2}";
        if (!input.startsWith(format)) {
            return input.getBytes("UTF-8");
        }
        byte[] inputBytes = input.substring(format.length()).getBytes("UTF-8");
        byte[] key = this.decryptInternal(c_masterKey, this.getEncryptionKey());
        byte[] output = this.decryptInternal(key, inputBytes);
        Arrays.fill(key, (byte)0);
        return output;
    }

    public byte[] decryptInternal(byte[] key, byte[] input) throws SmCryptoProviderException, UnsupportedEncodingException {
        if (!c_isFIPS) {
            SmCryptoProvider provider = SmCryptoProvider.getInstance("RC2/SHA", null, true);
            provider.init(key, key, null, 128, true);
            return provider.decrypt(input);
        }
        AesKeyWrapper aesKeyWrapper = new AesKeyWrapper(key);
        return aesKeyWrapper.UnwrapAscii(input, 0, input.length);
    }

    private static byte[] generateMasterKey() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(1255072322);
        buffer.putInt(861109358);
        buffer.putInt(317994786);
        buffer.putInt(-1207138008);
        return buffer.array();
    }

    private byte[] getEncryptionKey() {
        return this.m_isKeyStore ? c_ksKey : c_psKey;
    }

    static native byte[] getEncryptionKeyNative(boolean var0);

    static native boolean getFIPSMode();

    static {
        try {
            System.loadLibrary("smutilities");
            c_psKey = SmServerCrypto.getEncryptionKeyNative(false);
            c_ksKey = SmServerCrypto.getEncryptionKeyNative(true);
            c_isFIPS = SmServerCrypto.getFIPSMode();
        }
        catch (Throwable t) {
            c_bStubbed = true;
        }
    }
}

