/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

class SmDES3CryptoProvider
extends SmCryptoProvider {
    protected IvParameterSpec m_params = null;

    SmDES3CryptoProvider(String keyDigestAlg, boolean bAscii) throws SmCryptoProviderException {
        this.m_transformation = "DESede/CBC/PKCS5Padding";
        this.m_algorithm = "DESede";
        this.m_keyDigestAlg = keyDigestAlg;
        this.m_verifyDigest = false;
        this.m_bAscii = bAscii;
        try {
            this.m_digestLength = this.getBlockSize();
        }
        catch (GeneralSecurityException e) {
            throw new SmCryptoProviderException(e);
        }
    }

    public Key generateKey() throws SmCryptoProviderException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(this.m_algorithm, (Provider)m_provider);
            keygen.init(this.m_keyStrength, SmSecureRandom.get());
            return keygen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SmCryptoProviderException(e);
        }
    }

    protected void initParams() {
        this.m_params = new IvParameterSpec(this.m_initVector);
    }

    protected Cipher getEncrypter() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(1, this.m_encryptKey, this.m_params, SmSecureRandom.get());
        return cipher;
    }

    protected Cipher getDecrypter() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(2, this.m_decryptKey, this.m_params, SmSecureRandom.get());
        return cipher;
    }

    protected byte[] makeDigest(byte[] input, boolean mode) throws GeneralSecurityException {
        return this.makeDigest(input, input.length, mode);
    }

    protected byte[] makeDigest(byte[] input, int inLength, boolean mode) throws GeneralSecurityException {
        int digestSize = this.getDigestLength();
        byte[] digest = new byte[digestSize];
        SmSecureRandom.nextBytes(digest);
        return digest;
    }
}

