/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmConnectionWaiter;
import com.ca.siteminder.sdk.agentapi.connection.SmHandle;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.connection.SmRequestCounter;
import com.ca.siteminder.sdk.agentapi.connection.SmServerConnection;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliBuffer;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;

class SmServer
extends SmHandle
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmServer";
    private static final String MESSAGES_CLASSNAME = SmConnectionMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    protected static final int CLIENT_IDLE_TIMEOUT = 30;
    protected static final int MAX_TIME_IN_TIMEDOUT_STATE = 60;
    protected int m_maxBufferSize = SmAgentTliBuffer.getDefaultBufferSize();
    protected SocketAddress m_serverAddress;
    protected SmConfigFile m_smConfigFile;
    protected SmInitDef m_initDef;
    protected String m_hostName;
    protected String m_sharedSecret;
    protected int m_maxConnections;
    protected int m_defaultConnections;
    protected int m_connectionIncrement;
    protected long m_timeout;
    protected int m_version;
    protected SmServerConnection[] m_connections = null;
    protected Vector m_waiterQueue = new Vector();
    protected int m_connectionCount;
    private Object m_serverLock = new Object();
    private boolean m_failedHandShake = false;

    SmServer() {
        try {
            this.m_counter = new SmRequestCounter(20000L, true);
        }
        catch (SmAgentApiConnectionException smAgentApiConnectionException) {
            // empty catch block
        }
    }

    String getSharedSecret() {
        return this.m_sharedSecret;
    }

    void setSharedSecret(String sharedSecret) {
        this.m_sharedSecret = sharedSecret;
    }

    synchronized void init(SocketAddress serverAddress, SmInitDef initDef, int version) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "init";
        if (initDef == null) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Null initDef ");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONFIG_INFO"));
        }
        this.m_initDef = initDef;
        this.m_serverAddress = serverAddress;
        this.m_version = version;
        this.m_smConfigFile = initDef.getSmConfigFile();
        if (this.m_smConfigFile != null) {
            this.m_sharedSecret = this.m_smConfigFile.getAttribute(SM_CONF_SHARED_SECRET);
            this.m_initDef.setSharedSecret(this.m_sharedSecret);
        } else {
            this.m_sharedSecret = this.m_initDef.getSharedSecret();
        }
        this.m_hostName = this.m_initDef.getHostName();
        this.m_maxConnections = this.m_initDef.getMaxConnections();
        this.m_defaultConnections = this.m_initDef.getDefaultConnections();
        this.m_connectionIncrement = this.m_initDef.getConnectionIncrement();
        this.m_timeout = this.m_initDef.getTimeout() * 1000L;
        if (this.m_hostName == null || this.m_hostName.length() == 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Null or empty hostName");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_HOST_NAME"));
        }
        if (this.m_sharedSecret == null || this.m_sharedSecret.length() == 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Null or empty shared secret");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_SHARED_SECRET"));
        }
        if (this.m_maxConnections <= 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Max connection <= 0");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_MAXIMAL_CONNECTION_COUNT"));
        }
        if (this.m_defaultConnections <= 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Default connection count <= 0");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_DEFAULT_CONNECTION_COUNT"));
        }
        if (this.m_timeout < 0L) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Timeout < 0");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_TIMEOUT"));
        }
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "init", "Initialized server - defaultConnections = " + this.m_defaultConnections + ", maxConnections = " + this.m_maxConnections);
        }
        this.m_connections = new SmServerConnection[this.m_maxConnections];
        for (int index = 0; index < this.m_connections.length; ++index) {
            this.m_connections[index] = new SmServerConnection();
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "init", "Initialized server " + this.m_serverAddress);
        }
    }

    boolean enable() throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "enable";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "enable", "started");
        }
        if (this.createConnections(this.m_defaultConnections)) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "enable", "Setting server " + this.m_serverAddress + " to active");
            }
            return true;
        }
        if (Util.isLogEnabled()) {
            Util.display(2, CLASS_NAME, "enable", "Failed to enable server " + this.m_serverAddress);
        }
        return false;
    }

    void disable() {
        this.releaseAllConnections();
    }

    long getTimeout() {
        return this.m_timeout / 1000L;
    }

    protected boolean createConnections(int howMany) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "createConnections";
        if (howMany <= 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "createConnections", "Attempt to start <= 0 connections");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONNECTION_NUMBER"));
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "createConnections", "Attempt to create connections = " + howMany);
        }
        this.retryTimedoutConnections();
        boolean bRet = true;
        for (int count = 0; count < howMany; ++count) {
            if (this.createConnection()) continue;
            if (Util.isLogEnabled()) {
                Util.display(3, CLASS_NAME, "createConnections", "Failed to create connection " + count + " of " + howMany);
            }
            bRet = false;
            break;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createConnection() throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "createConnection";
        if (this.getConnectionCount() >= this.m_maxConnections) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "createConnection", "Already at max connections, returning success");
            }
            return true;
        }
        SmServerConnection connection = null;
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "createConnection", "Currently have " + this.getConnectionCount() + " connections to server.");
        }
        Object object = this.m_serverLock;
        synchronized (object) {
            for (int index = 0; index < this.m_connections.length; ++index) {
                SmServerConnection con = this.m_connections[index];
                if (con == null || con.getState() != 0) continue;
                if (this.m_smConfigFile != null) {
                    this.m_sharedSecret = this.m_smConfigFile.getAttribute(SM_CONF_SHARED_SECRET);
                }
                connection = con;
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "createConnection", "Creating a server connection, index = " + index);
                }
                connection.init(this.m_serverAddress, this.m_smConfigFile, this.m_hostName, this.m_sharedSecret, this.m_version, this.m_timeout);
                ++this.m_connectionCount;
                break;
            }
        }
        if (connection == null) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "createConnection", "All connections in use, returning success");
            }
            return true;
        }
        if (!connection.connect()) {
            this.releaseConnection(connection);
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "createConnection", "Failed to connect; release connection.");
            }
            return false;
        }
        this.m_failedHandShake = false;
        if (!connection.handshake()) {
            this.releaseConnection(connection);
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "createConnection", "Failed to handshake; release connection.");
            }
            this.m_failedHandShake = true;
            return false;
        }
        String sharedSecret = connection.getSharedSecret();
        this.m_initDef.setSharedSecret(sharedSecret);
        this.setSharedSecret(sharedSecret);
        if (!this.setMaxBufferSize(connection) && Util.isLogEnabled()) {
            Util.display(2, CLASS_NAME, "createConnection", "Failed to negotiate the maximal buffer size.");
        }
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "createConnection", "Connection successfully created. state = " + connection.getState());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SmServerConnection getConnection(boolean bMakeNew) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "getConnection";
        SmServerConnection connection = null;
        SmConnectionWaiter waiter = null;
        Object object = this.m_serverLock;
        synchronized (object) {
            for (int index = 0; index < this.m_connections.length; ++index) {
                SmServerConnection con = this.m_connections[index];
                if (con.getState() != 1) continue;
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "getConnection", "Found a free connection, index = " + index);
                }
                connection = con;
                connection.setState(2);
                break;
            }
            if (connection == null && bMakeNew) {
                waiter = new SmConnectionWaiter();
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "getConnection", "No free connections found, enqueuing waiter " + Integer.toHexString(waiter.hashCode()));
                }
                this.m_waiterQueue.add(waiter);
            }
        }
        if (waiter != null) {
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "getConnection", "No free connections found, creating more within max.");
            }
            if (!this.createConnections(this.m_connectionIncrement)) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "getConnection", "Failed to create any connections, dequeueing waiter " + Integer.toHexString(waiter.hashCode()));
                }
                object = this.m_serverLock;
                synchronized (object) {
                    if (!waiter.isNotified()) {
                        this.m_waiterQueue.remove(waiter);
                        waiter = null;
                    } else if (Util.isLogEnabled()) {
                        Util.display(2, CLASS_NAME, "getConnection", "Waiter is notified, no need to dequeue " + Integer.toHexString(waiter.hashCode()));
                    }
                }
            }
            if (waiter != null) {
                if (waiter.isNotified()) {
                    connection = waiter.getConnection();
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "getConnection", "Done waiting, got connection " + (connection == null ? "<null>" : Integer.toHexString(connection.hashCode())) + " from waiter " + Integer.toHexString(waiter.hashCode()));
                    }
                } else {
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "getConnection", "About to wait on waiter " + Integer.toHexString(waiter.hashCode()) + " for a free connection.");
                    }
                    try {
                        object = waiter;
                        synchronized (object) {
                            waiter.wait(this.m_timeout);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "getConnection", "Done waiting, dequeuing waiter " + Integer.toHexString(waiter.hashCode()));
                    }
                    object = this.m_serverLock;
                    synchronized (object) {
                        this.m_waiterQueue.remove(waiter);
                        connection = waiter.getConnection();
                    }
                }
            }
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "getConnection", "Returning connection " + (connection == null ? "<null>" : Integer.toHexString(connection.hashCode())));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean freeConnection(SmServerConnection connection) {
        String methodName = "freeConnection";
        Object object = this.m_serverLock;
        synchronized (object) {
            if (connection == null || connection.getState() != 2 && connection.getState() != 3) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "freeConnection", "Nothing freed for connection + " + connection + ", state = " + (connection == null ? -1 : connection.getState()));
                }
                return false;
            }
            long now = System.currentTimeMillis();
            long past = connection.getRequestStartTimestamp();
            connection.setLastResponseTimestamp(now);
            if (this.m_counter != null && past >= 0L) {
                this.m_counter.addRequestTimeSample(now, now - past);
            }
            SmConnectionWaiter waiter = null;
            if (this.m_waiterQueue.size() > 0) {
                waiter = (SmConnectionWaiter)this.m_waiterQueue.remove(0);
            }
            if (waiter != null) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "freeConnection", "Handing connection " + Integer.toHexString(connection.hashCode()) + " to waiter " + Integer.toHexString(waiter.hashCode()));
                }
                waiter.setConnection(connection);
                waiter.setNotified();
            } else {
                connection.setState(1);
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "freeConnection", "Freed connection " + Integer.toHexString(connection.hashCode()));
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(SmServerConnection connection) {
        String methodName = "releaseConnection";
        Object object = this.m_serverLock;
        synchronized (object) {
            if (connection == null || connection.getState() == 0) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "releaseConnection", "Nothing released for connection + " + connection + ", state = " + (connection == null ? -1 : connection.getState()));
                }
                return;
            }
            connection.release();
            --this.m_connectionCount;
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "releaseConnection", "Released connection " + Integer.toHexString(connection.hashCode()) + ", count = " + this.m_connectionCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseAllConnections() {
        Object object = this.m_serverLock;
        synchronized (object) {
            while (this.m_waiterQueue.size() > 0) {
                SmConnectionWaiter waiter = (SmConnectionWaiter)this.m_waiterQueue.remove(0);
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "releaseAllConnections", "Waking waiter " + Integer.toHexString(waiter.hashCode()));
                }
                waiter.setConnection(null);
                waiter.setNotified();
            }
            for (int index = 0; index < this.m_connections.length; ++index) {
                this.releaseConnection(this.m_connections[index]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIdleConnections(boolean bDeleteTimeout) {
        Object object = this.m_serverLock;
        synchronized (object) {
            for (int index = 0; index < this.m_connections.length; ++index) {
                SmServerConnection connection;
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "releaseAllConnection", "enter");
                }
                if ((connection = this.m_connections[index]).getState() == 1) {
                    if (System.currentTimeMillis() - connection.getLastResponseTimestamp() <= 30000L) continue;
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "releaseAllConnection", "free");
                    }
                    this.releaseConnection(connection);
                    continue;
                }
                if (connection.getState() != 3 || !bDeleteTimeout || connection.getTimedOutTimestamp() - connection.getLastResponseTimestamp() <= 30000L + this.m_timeout) continue;
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "releaseAllConnection", "timeout");
                }
                this.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int retryTimedoutConnections() {
        String methodName = "retryTimedoutConnections";
        boolean hasFree = false;
        boolean hasTimedOut = false;
        Object object = this.m_serverLock;
        synchronized (object) {
            for (int index = 0; index < this.m_connections.length; ++index) {
                SmServerConnection connection = this.m_connections[index];
                if (connection.getState() == 1) {
                    hasFree = true;
                    continue;
                }
                if (connection.getState() != 3) continue;
                hasTimedOut = true;
                try {
                    connection.setState(2);
                    int ret = connection.flush();
                    if (ret == 0) {
                        this.freeConnection(connection);
                        return 0;
                    }
                    if (ret == -1) {
                        if (Util.isLogEnabled()) {
                            Util.display(2, CLASS_NAME, "retryTimedoutConnections", "Error retrying connection failed");
                        }
                        this.releaseConnection(connection);
                        return -1;
                    }
                    if (ret != -2) continue;
                    if (Util.isLogEnabled()) {
                        Util.display(2, CLASS_NAME, "retryTimedoutConnections", "TIMEOUT1 Error retrying connection timed");
                    }
                    this.releaseConnection(connection);
                    return -1;
                }
                catch (Exception e) {
                    if (Util.isLogEnabled()) {
                        Util.display(2, CLASS_NAME, "retryTimedoutConnections", "Error retrying connection = " + connection + ": " + e);
                    }
                    this.releaseConnection(connection);
                    return -1;
                }
            }
        }
        if (hasFree && !hasTimedOut) {
            return 0;
        }
        if (Util.isLogEnabled()) {
            Util.display(2, CLASS_NAME, "retryTimedoutConnections", "Error retrying connection NO CONN");
        }
        return -3;
    }

    SmAgentPacket processRequest(SmAgentPacket request, int[] status) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        return this.processRequest(request, null, status);
    }

    SmAgentPacket processRequest(SmAgentPacket request, SmServerConnection connection, int[] status) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        boolean bMakeNew = true;
        boolean bRetry = false;
        boolean bReset = false;
        String methodName = "processRequest";
        while (true) {
            if (connection == null) {
                connection = this.getConnection(bMakeNew);
            }
            if (connection == null) {
                if (bMakeNew) {
                    if (Util.isLogEnabled()) {
                        Util.display(2, CLASS_NAME, "processRequest", "Failed request as timeout, unable to get a connection.");
                    }
                    status[0] = -2;
                    return null;
                }
                if (!bRetry && bReset) {
                    bMakeNew = true;
                    bRetry = true;
                    continue;
                }
                status[0] = -1;
                return null;
            }
            bMakeNew = false;
            SmAgentPacket response = null;
            try {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Writing the request; type = " + request.getType());
                }
                connection.setRequestStartTimestamp(System.currentTimeMillis());
                int code = connection.write(request, this.m_timeout);
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Writing the request; return code = " + code);
                }
                if (code == -1) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Error writing request to server.");
                    }
                    this.releaseConnection(connection);
                    connection = null;
                    bReset = true;
                    continue;
                }
                int[] readStatus = new int[1];
                response = connection.read(this.m_timeout, readStatus);
                if (readStatus[0] == -2) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Timeout reading response from server.");
                    }
                    connection.setState(3);
                    connection.setTimedOutTimestamp(System.currentTimeMillis());
                    connection.setRequestStartTimestamp(0L);
                    status[0] = -2;
                    return null;
                }
                if (readStatus[0] == -1) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Error reading response from server.");
                    }
                    this.releaseConnection(connection);
                    connection = null;
                    bReset = true;
                    continue;
                }
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "processRequest", "Successfully read response.");
                }
                status[0] = 0;
                this.freeConnection(connection);
                return response;
            }
            catch (IOException e) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Exception reading server response.");
                    e.printStackTrace();
                }
                this.releaseConnection(connection);
                connection = null;
                bReset = true;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setMaxBufferSize(SmServerConnection connection) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(140);
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.processRequest(request, connection, status);
        if (status[0] == 0 && response != null && response.getType() == 2) {
            List attributes = response.getAttributes();
            if (attributes != null) {
                for (SmAttribute attr : attributes) {
                    if (attr == null || attr.getId() != 168) continue;
                    try {
                        int limit = ByteBuffer.wrap(attr.getValue()).getInt();
                        Object object = this.m_serverLock;
                        synchronized (object) {
                            if (limit > this.m_maxBufferSize) {
                                this.m_maxBufferSize = limit;
                            }
                            break;
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SmAgentApiConnectionException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxBufferSize() {
        Object object = this.m_serverLock;
        synchronized (object) {
            return this.m_maxBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getConnectionCount() {
        Object object = this.m_serverLock;
        synchronized (object) {
            return this.m_connectionCount;
        }
    }

    void logStats(OutputStream stream) {
        int freeConnections = 0;
        int busyConnections = 0;
        int timedoutConnections = 0;
        block5: for (int index = 0; index < this.m_connections.length; ++index) {
            SmServerConnection connection = this.m_connections[index];
            switch (connection.getState()) {
                case 1: {
                    ++freeConnections;
                    continue block5;
                }
                case 2: {
                    ++busyConnections;
                    continue block5;
                }
                case 3: {
                    ++timedoutConnections;
                }
            }
        }
        PrintStream out = null;
        out = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream);
        out.println("    Server [" + this.m_serverAddress.toString() + "]:");
        out.println("        state is " + this.getStatus());
        out.println("        average response time is " + String.valueOf(this.m_counter.getAverageResponseTime()) + " (msec)");
        out.println("        throughput is " + String.valueOf(this.m_counter.getCurrentThroughput()) + " (req/sec)");
        out.println("        max throughput is " + String.valueOf(this.m_counter.getMaxThroughput()) + " (req/sec)");
        out.println("        min throughput is " + String.valueOf(this.m_counter.getMinThroughput()) + " (req/sec)");
        out.println("        avg throughput is " + String.valueOf(this.m_counter.getAverageThroughput()) + " (req/sec)");
        out.println("        Connections:");
        out.println("            connection count is " + String.valueOf(freeConnections + busyConnections + timedoutConnections));
        out.println("            free connection count is " + String.valueOf(freeConnections));
        out.println("            busy connection count is " + String.valueOf(busyConnections));
        out.println("            timedout connection count is " + String.valueOf(timedoutConnections));
    }

    boolean isHandShakeFailed() {
        return this.m_failedHandShake;
    }
}

