/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi;

import com.ca.siteminder.sdk.agentapi.SmAgentApi;
import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiImpl;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.resources.SmRegHostMessages;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesResult;
import com.ca.siteminder.sdk.agentapi.services.SmTunnelServiceRequest;
import com.netegrity.util.Fips140Mode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class SmRegHost
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmRegHost";
    private static final String MESSAGES_CLASSNAME = SmRegHostMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final int EXIT_FAILURE = -1;
    private static final int EXIT_SUCCESS = 0;
    private static String TUNNEL_SUCCESS = "<status=16>";
    private static String TUNNEL_LIBRARY = "smtransactems2";
    private static String TUNNEL_FUNCTION = "SmExecuteCommand";
    private static String TUNNEL_COMMAND = "command";
    private static String TUNNEL_LOGIN = "login";
    private static String TUNNEL_REGISTER_HOST = "smregisterhost";
    private static String TUNNEL_PARAMS = "params";
    private static String TUNNEL_USERNAME = "user";
    private static String TUNNEL_PASSWORD = "password";
    private static String TUNNEL_HOSTNAME = "name";
    private static String TUNNEL_HOSTCONFIG = "hostconfobj";
    private static String TUNNEL_ADDRESS = "ipaddress";
    private static String TUNNEL_ROLLOVER = "rolloverenabled";
    private static String TUNNEL_OVERWRITE = "overwritehost";
    private static String TUNNEL_SESSION_SPEC = "sessionspec";
    private static String TUNNEL_SHARED_SECRET = "secret";
    private static String TUNNEL_MESSAGE = "message";
    private static String DEFAULT_TUNNEL_NAME = "SMTUNNEL";
    private static String DEFAULT_TUNNEL_SECRET = "SMTUNNEL";
    private static int DEFAULT_REQUEST_TIMEOUT = 60;
    private static final String TUNNEL_SEPARATOR = "-";
    private static final String PORT_SEPARATOR = ",";
    private static final String TUNNEL_TOKEN_BEGIN = "<";
    private static final String TUNNEL_TOKEN_DELIM = "=";
    private static final String TUNNEL_TOKEN_END = ">";
    private static final String TOKEN_SEPARATOR = "\n";
    private static String BACKUP_SUFFIX = ".bk";
    private SmAgentApi m_handle = null;
    private String m_address = null;
    private String m_filename = "SmHost.conf";
    private String m_username = null;
    private String m_password = null;
    private String m_hostname = null;
    private String m_hostconfig = null;
    private String m_sharedSecret = null;
    private String m_sessionSpec = null;
    private boolean m_bRollover = false;
    private boolean m_bOverwrite = false;

    public SmRegHost() {
    }

    public SmRegHost(String address, String filename, String hostname, String hostconfig, String username, String password, boolean bRollover, boolean bOverwrite) {
        this.m_address = address;
        this.m_filename = filename;
        this.m_hostname = hostname;
        this.m_hostconfig = hostconfig;
        this.m_username = username;
        this.m_password = password;
        this.m_bRollover = bRollover;
        this.m_bOverwrite = bOverwrite;
    }

    public SmRegHost(String address, String filename, String hostname, String hostconfig, String sharedSecret) {
        this.m_address = address;
        this.m_filename = filename;
        this.m_hostname = hostname;
        this.m_hostconfig = hostconfig;
        this.m_sharedSecret = sharedSecret;
    }

    public String getAddress() {
        return this.m_address;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getHostName() {
        return this.m_hostname;
    }

    public String getHostConfigObject() {
        return this.m_hostconfig;
    }

    public String getAdminName() {
        return this.m_username;
    }

    public String getAdminPassword() {
        return this.m_password;
    }

    public String getSharedSecret() {
        return this.m_sharedSecret;
    }

    public boolean canRollover() {
        return this.m_bRollover;
    }

    public boolean canOverwriteHost() {
        return this.m_bOverwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws SmAgentApiException {
        int status;
        block25: {
            Fips140Mode fipsMode = Fips140Mode.getFips140ModeObject();
            fipsMode.setMode(Util.resolveSetting());
            SmRegHost reghost = new SmRegHost();
            if (args == null || args.length == 0) {
                reghost.usage();
                System.exit(-1);
            }
            for (int k = 0; k < args.length; ++k) {
                if ("-i".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_address = args[k].trim();
                    continue;
                }
                if ("-f".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_filename = args[k].trim();
                    continue;
                }
                if ("-u".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_username = args[k];
                    continue;
                }
                if ("-p".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_password = args[k];
                    continue;
                }
                if ("-hn".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_hostname = args[k].trim();
                    continue;
                }
                if ("-hc".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_hostconfig = args[k].trim();
                    continue;
                }
                if ("-sh".equals(args[k])) {
                    if (++k >= args.length) continue;
                    reghost.m_sharedSecret = args[k];
                    continue;
                }
                if ("-rs".equals(args[k])) {
                    reghost.m_bRollover = true;
                    continue;
                }
                if ("-o".equals(args[k])) {
                    reghost.m_bOverwrite = true;
                    continue;
                }
                if (!"-cf".equals(args[k])) continue;
                String fipsModeUserInput = null;
                if (++k < args.length) {
                    fipsModeUserInput = args[k].trim();
                }
                if ("COMPAT".equals(fipsModeUserInput)) {
                    fipsMode.setMode(1);
                    continue;
                }
                if ("MIGRATE".equals(fipsModeUserInput)) {
                    fipsMode.setMode(2);
                    continue;
                }
                if ("ONLY".equals(fipsModeUserInput)) {
                    fipsMode.setMode(3);
                    continue;
                }
                System.err.println(c_bundle.getString("M_INVALID_FIPSMODE") + " " + fipsModeUserInput);
                fipsMode.setMode(1);
            }
            if (fipsMode.wantFips()) {
                try {
                    SM_CONF_SHARED_SECRET.setFormat("{AES}");
                }
                catch (SmConfigException e) {
                    System.err.println(c_bundle.getString("M_FAILED_SHSECRET_FIPSMODE"));
                }
            }
            if (reghost.m_bRollover && reghost.m_sharedSecret != null && reghost.m_sharedSecret.length() > 0) {
                System.err.println(c_bundle.getString("M_CANNOT_ROLLOVER"));
                System.exit(-1);
            }
            status = -1;
            try {
                try {
                    if (reghost.m_sharedSecret == null || reghost.m_sharedSecret.length() == 0) {
                        reghost.register();
                    } else {
                        reghost.registerFile();
                    }
                    System.out.println(c_bundle.getString("M_SUCCESS"));
                    status = 0;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    System.err.println(c_bundle.getString("M_FAILURE"));
                    Object var6_8 = null;
                    reghost.close();
                    break block25;
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                reghost.close();
                throw throwable;
            }
            reghost.close();
        }
        System.exit(status);
    }

    public void register() throws SmAgentApiException {
        if (this.m_address == null || this.m_address.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_ADDRESS"));
        }
        if (this.m_filename == null || this.m_filename.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_FILENAME"));
        }
        if (this.m_hostname == null || this.m_hostname.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_HOSTNAME"));
        }
        if (this.m_hostconfig == null || this.m_hostconfig.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_HOSTCONFIG"));
        }
        if (this.m_username == null || this.m_username.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_USERNAME"));
        }
        if (this.m_password == null || this.m_password.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_PASSWORD"));
        }
        if (!this.init()) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (!this.login()) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_FAILED_LOGIN"));
        }
        if (!this.registerHost()) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_FAILED_REGISTER_HOST"));
        }
        this.registerFile();
    }

    public void registerFile() throws SmAgentApiException {
        if (this.m_address == null || this.m_address.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_ADDRESS"));
        }
        if (this.m_filename == null || this.m_filename.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_FILENAME"));
        }
        if (this.m_hostname == null || this.m_hostname.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_HOSTNAME"));
        }
        if (this.m_hostconfig == null || this.m_hostconfig.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_HOSTCONFIG"));
        }
        if (this.m_sharedSecret == null || this.m_sharedSecret.length() == 0) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_SHARED_SECRET"));
        }
        if (!this.backup()) {
            throw new SmAgentApiException(-1, c_bundle.getString("M_FAILED_BACKUP"));
        }
        SmConfigFile file = SmConfigFile.getInstance(this.m_filename, true);
        if (file != null) {
            Object[] args = new Object[]{this.m_filename};
            file.removeAll();
            file.addComment(MessageFormat.format(c_bundle.getString("M_HEADER"), args));
        }
        String policyServer = this.m_address;
        int port = 44442;
        InetSocketAddress addr = Util.parseHostNPort(policyServer);
        port = addr.getPort();
        policyServer = addr.getHostName();
        StringBuffer policyServerNPorts = new StringBuffer();
        policyServerNPorts.append(policyServer);
        if (port == 44442) {
            policyServerNPorts.append(PORT_SEPARATOR);
            policyServerNPorts.append(44441);
            policyServerNPorts.append(PORT_SEPARATOR);
            policyServerNPorts.append(44442);
            policyServerNPorts.append(PORT_SEPARATOR);
            policyServerNPorts.append(44443);
        } else {
            policyServerNPorts.append(PORT_SEPARATOR);
            policyServerNPorts.append(port);
            policyServerNPorts.append(PORT_SEPARATOR);
            policyServerNPorts.append(port);
            policyServerNPorts.append(PORT_SEPARATOR);
            policyServerNPorts.append(port);
        }
        ArrayList<String> policyServerAttribute = new ArrayList<String>();
        policyServerAttribute.add(policyServerNPorts.toString());
        file.setAttribute(SM_CONF_HOST_NAME, this.m_hostname);
        file.setAttribute(SM_CONF_HOSTCONFIG, this.m_hostconfig);
        file.setAttribute(SM_CONF_POLICY_SERVER, policyServerAttribute);
        file.setAttribute(SM_CONF_REQUEST_TIMEOUT, String.valueOf(DEFAULT_REQUEST_TIMEOUT));
        file.updateSharedSecret(this.m_sharedSecret, System.currentTimeMillis() / 1000L);
        Fips140Mode fipsMode = Fips140Mode.getFips140ModeObject();
        if (fipsMode.isMigrateMode()) {
            file.setAttribute(SM_CONF_FIPS_MODE, "MIGRATE");
        } else if (fipsMode.isFipsOnlyMode()) {
            file.setAttribute(SM_CONF_FIPS_MODE, "ONLY");
        } else {
            file.setAttribute(SM_CONF_FIPS_MODE, "COMPAT");
        }
        file.write();
        try {
            file.close();
        }
        catch (SmConfigException e) {
            // empty catch block
        }
    }

    private boolean init() throws SmAgentApiException {
        if (this.m_address == null || this.m_address.length() == 0) {
            return false;
        }
        String agentName = DEFAULT_TUNNEL_NAME;
        String sharedSecret = DEFAULT_TUNNEL_SECRET;
        ArrayList clusters = new ArrayList();
        ArrayList<String> servers = new ArrayList<String>();
        servers.add(this.m_address);
        clusters.add(servers);
        this.m_handle = new SmAgentApiImpl();
        SmInitDef initDef = new SmInitDef(null, this.m_address, agentName, sharedSecret, 2, 2, 2, (long)DEFAULT_REQUEST_TIMEOUT, false, 0, null);
        Fips140Mode fipsMode = Fips140Mode.getFips140ModeObject();
        if (!fipsMode.isUnset()) {
            initDef.setCryptoOpMode(fipsMode.getMode());
        }
        this.m_handle.init(initDef);
        return true;
    }

    private boolean login() throws SmAgentApiException {
        if (this.m_handle == null || this.m_username == null || this.m_username.length() == 0 || this.m_password == null || this.m_password.length() == 0) {
            this.m_sessionSpec = null;
            return false;
        }
        try {
            StringBuffer data = new StringBuffer();
            StringBuffer params = new StringBuffer();
            params.append(SmRegHost.token(TUNNEL_USERNAME, this.m_username));
            params.append(SmRegHost.token(TUNNEL_PASSWORD, this.m_password));
            data.append(SmRegHost.token(TUNNEL_COMMAND, TUNNEL_LOGIN));
            data.append(SmRegHost.token(TUNNEL_PARAMS, params));
            SmTunnelServiceRequest request = new SmTunnelServiceRequest(TUNNEL_LIBRARY, TUNNEL_FUNCTION, null, data.toString().getBytes("UTF-8"));
            SmAgentApiServicesResult result = this.m_handle.tunnel(null, null, null, request);
            if (result == null || !result.isSuccess()) {
                this.m_sessionSpec = null;
                return false;
            }
            Util.display(5, CLASS_NAME, "login", "tunnel service returned succesfully");
            List attributes = result.getAttributeList();
            boolean bSuccess = false;
            String message = null;
            if (attributes != null) {
                for (SmAttribute attr : attributes) {
                    if (attr != null && Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "login", "got attribute ID: " + attr.getId());
                    }
                    if (attr == null || attr.getId() != 164 || attr.getValue() == null) continue;
                    String value = new String(attr.getValue(), "UTF-8");
                    String[] lines = value.split(TOKEN_SEPARATOR);
                    if (TUNNEL_SUCCESS.equals(lines[0])) {
                        bSuccess = true;
                    }
                    for (int k = 1; k < lines.length; ++k) {
                        String key;
                        int index = lines[k].indexOf(TUNNEL_TOKEN_DELIM);
                        if (index <= 0 || !TUNNEL_MESSAGE.equals(key = lines[k].substring(TUNNEL_TOKEN_BEGIN.length(), index))) continue;
                        message = lines[k].substring(index + TUNNEL_TOKEN_DELIM.length(), lines[k].length() - TUNNEL_TOKEN_END.length());
                    }
                }
            }
            if (!bSuccess) {
                this.m_sessionSpec = null;
                if (message != null) {
                    System.out.println(message);
                }
            } else {
                this.m_sessionSpec = message;
            }
            return bSuccess;
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiException(e);
        }
    }

    private boolean registerHost() throws SmAgentApiException {
        if (this.m_handle == null || this.m_address == null || this.m_address.length() == 0 || this.m_hostname == null || this.m_hostname.length() == 0 || this.m_hostconfig == null || this.m_hostconfig.length() == 0 || this.m_sessionSpec == null || this.m_sessionSpec.length() == 0) {
            return false;
        }
        try {
            StringBuffer data = new StringBuffer();
            StringBuffer params = new StringBuffer();
            params.append(SmRegHost.token(TUNNEL_HOSTNAME, this.m_hostname));
            params.append(SmRegHost.token(TUNNEL_HOSTCONFIG, this.m_hostconfig));
            params.append(SmRegHost.token(TUNNEL_ADDRESS, this.m_address));
            params.append(SmRegHost.token(TUNNEL_ROLLOVER, new Boolean(this.m_bRollover).toString()));
            params.append(SmRegHost.token(TUNNEL_OVERWRITE, new Boolean(this.m_bOverwrite).toString()));
            data.append(SmRegHost.token(TUNNEL_SESSION_SPEC, this.m_sessionSpec));
            data.append(SmRegHost.token(TUNNEL_COMMAND, TUNNEL_REGISTER_HOST));
            data.append(SmRegHost.token(TUNNEL_PARAMS, params));
            SmTunnelServiceRequest request = new SmTunnelServiceRequest(TUNNEL_LIBRARY, TUNNEL_FUNCTION, null, data.toString().getBytes("UTF-8"));
            SmAgentApiServicesResult result = this.m_handle.tunnel(null, null, null, request);
            if (result == null || !result.isSuccess()) {
                return false;
            }
            List attributes = result.getAttributeList();
            boolean bSuccess = false;
            String message = null;
            if (attributes != null) {
                for (SmAttribute attr : attributes) {
                    if (attr == null || attr.getId() != 164 || attr.getValue() == null) continue;
                    String value = new String(attr.getValue(), "UTF-8");
                    String[] lines = value.split(TOKEN_SEPARATOR);
                    if (TUNNEL_SUCCESS.equals(lines[0])) {
                        bSuccess = true;
                    }
                    for (int k = 1; k < lines.length; ++k) {
                        int index = lines[k].indexOf(TUNNEL_TOKEN_DELIM);
                        if (index <= 0) continue;
                        String key = lines[k].substring(TUNNEL_TOKEN_BEGIN.length(), index);
                        String token = lines[k].substring(index + TUNNEL_TOKEN_DELIM.length(), lines[k].length() - TUNNEL_TOKEN_END.length());
                        if (bSuccess && TUNNEL_HOSTNAME.equals(key)) {
                            this.m_hostname = token;
                            continue;
                        }
                        if (bSuccess && TUNNEL_SHARED_SECRET.equals(key)) {
                            this.m_sharedSecret = token;
                            continue;
                        }
                        if (!TUNNEL_MESSAGE.equals(key)) continue;
                        message = lines[k].substring(index + TUNNEL_TOKEN_DELIM.length(), lines[k].length() - TUNNEL_TOKEN_END.length());
                    }
                }
            }
            if (!bSuccess && message != null) {
                System.out.println(message);
            }
            return bSuccess;
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiException(e);
        }
    }

    private static StringBuffer token(String key, String value) {
        return new StringBuffer().append(TUNNEL_TOKEN_BEGIN).append(key).append(TUNNEL_TOKEN_DELIM).append(value).append(TUNNEL_TOKEN_END).append(TOKEN_SEPARATOR);
    }

    private static StringBuffer token(String key, StringBuffer value) {
        return new StringBuffer().append(TUNNEL_TOKEN_BEGIN).append(key).append(TUNNEL_TOKEN_DELIM).append(value).append(TUNNEL_TOKEN_END).append(TOKEN_SEPARATOR);
    }

    private boolean backup() {
        File file = new File(this.m_filename);
        if (file.exists() && file.isFile()) {
            File backup = new File(this.m_filename + BACKUP_SUFFIX);
            if (backup.exists() && backup.isFile() && !backup.delete()) {
                return false;
            }
            return file.renameTo(backup);
        }
        return true;
    }

    private void usage() {
        Object[] args = new Object[]{this.getClass().getName()};
        System.out.println(MessageFormat.format(c_bundle.getString("M_USAGE"), args));
    }

    private void close() throws SmAgentApiException {
        if (this.m_handle != null) {
            this.m_handle.close();
            this.m_handle = null;
        }
    }

    protected void finalize() throws SmAgentApiException {
        this.close();
    }
}

