/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.policyapi.SmODBCQuery;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmUserDir_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testaddUserDir() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testUserdir" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testUserDir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testUserDir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testUserDir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddLDAPUserDir() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("ldapuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-ldapuserdir");
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        smUserDirectory.setSearchRoot("o=mycompany.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(50);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence");
        smUserDirectory.setPasswordAttr("userPassword");
        smUserDirectory.setPasswordDataAttr("audio");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("ldapuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("ldapuserdir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("ldapuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddWinNTUserDir() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("winntuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-winntuserdir");
        smUserDirectory.setNamespace("WinNT:");
        smUserDirectory.setServer("127.0.0.1");
        smUserDirectory.setSearchRoot("o=mycompany.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(50);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence");
        smUserDirectory.setPasswordAttr("userPassword");
        smUserDirectory.setPasswordDataAttr("audio");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("winntuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("winntuserdir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("winntuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddCustomUserDir() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("customuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-customuserdir");
        smUserDirectory.setNamespace("Custom:");
        smUserDirectory.setServer("127.0.0.1");
        smUserDirectory.setSearchRoot("o=mycompany.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(50);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence");
        smUserDirectory.setPasswordAttr("userPassword");
        smUserDirectory.setPasswordDataAttr("audio");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("customuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("customuserdir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("customuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddODBCUserDir() throws SmApiException {
        SmODBCQuery smODBCQuery = new SmODBCQuery();
        smODBCQuery.setName("odbcscheme" + this.random);
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("odbcuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-odbcuserdir");
        smUserDirectory.setNamespace("ODBC:");
        smUserDirectory.setODBCQuery((Object)smODBCQuery);
        smUserDirectory.setServer("127.0.0.1");
        smUserDirectory.setSearchRoot("o=mycompany.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(50);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence");
        smUserDirectory.setPasswordAttr("userPassword");
        smUserDirectory.setPasswordDataAttr("audio");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("odbcuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("odbcuserdir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("odbcuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddDuplicateWinNTUserDir() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("winntuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-winntuserdir");
        smUserDirectory.setNamespace("WinNT:");
        smUserDirectory.setServer("127.0.0.1");
        smUserDirectory.setSearchRoot("o=mycompany.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(50);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence");
        smUserDirectory.setPasswordAttr("userPassword");
        smUserDirectory.setPasswordDataAttr("audio");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("winntuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        SmUserDirectory smUserDirectory2 = new SmUserDirectory();
        smUserDirectory2.setName("winntuserdir" + this.random);
        smUserDirectory2.setDescription("test-sample-winntuserdir");
        smUserDirectory2.setNamespace("WinNT:");
        smUserDirectory2.setServer("127.0.0.1");
        smUserDirectory2.setSearchRoot("o=mycompany.com");
        smUserDirectory2.setUserLookupStart("(&(uid=");
        smUserDirectory2.setUserLookupEnd("(objectclass=*)");
        smUserDirectory2.setUniversalIDAttr("uid");
        smUserDirectory2.setDisabledAttr("carLicence");
        smUserDirectory2.setPasswordAttr("userPassword");
        smUserDirectory2.setPasswordDataAttr("audio");
        smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory2);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Add User Directory with same name. (INVALID OID)", (boolean)smUserDirectory2.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Add User Direcotry with same name. (INVALID OID)", (boolean)smUserDirectory2.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("winntuserdir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("winntuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testModifyCustomUserDir() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("customuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-customuserdir");
        smUserDirectory.setNamespace("Custom:");
        smUserDirectory.setServer("127.0.0.1");
        smUserDirectory.setSearchRoot("o=mycompany.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(50);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence");
        smUserDirectory.setPasswordAttr("userPassword");
        smUserDirectory.setPasswordDataAttr("audio");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to add User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to add User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("customuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertTrue((String)"Unable to fetch User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to fetch User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory.setName("modifycustomuserdir" + this.random);
        smUserDirectory.setDescription("test-sample-modifycustomuserdir");
        smUserDirectory.setNamespace("Custom:");
        smUserDirectory.setServer("127.0.0.0");
        smUserDirectory.setSearchRoot("o=mycompany2.com");
        smUserDirectory.setUserLookupStart("(&(uid=");
        smUserDirectory.setUserLookupEnd("(objectclass=*)");
        smUserDirectory.setSearchResults(51);
        smUserDirectory.setSearchScope(2);
        smUserDirectory.setSearchTimeout(45);
        smUserDirectory.setUniversalIDAttr("uid");
        smUserDirectory.setDisabledAttr("carLicence2");
        smUserDirectory.setPasswordAttr("userPassword2");
        smUserDirectory.setPasswordDataAttr("video");
        smApiResult = SetupConnection.policyapi.modifyUserDirectory(smUserDirectory);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to modify User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertFalse((String)"Unable to modify User Direcotry(INVALID OID)", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("modifycustomuserdir" + this.random);
        SmUserDir_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("modifycustomuserdir" + this.random, smUserDirectory);
        SmUserDir_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (INVALID OID)", (boolean)smUserDirectory.getOid().isValid());
        SmUserDir_test.assertTrue((String)"Unable to delete User Directory (NULL OID)", (boolean)smUserDirectory.getOid().isNull());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmUserDir_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmUserDir_test.class);
        return new SetupConnection((Test)testSuite);
    }
}

