/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupRuleTestData;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmRule;
import com.netegrity.sdk.policyapi.SmTime;
import java.util.Calendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmRule_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testaddGlobalRuleWithNameActionAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionAgent");
        smRule.setAction("OnAuthAccept");
        smRule.setDomain((Object)SmObjId.NULL_OID);
        smRule.setRealm((Object)SmObjId.NULL_OID);
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch the object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch the object (NULL OID)", (boolean)smRule.getOid().isNull());
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule.setEnabled(false);
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        SmRule_test.assertEquals((String)"Enabled state has not been modified", (boolean)false, (boolean)smRule.getEnabled());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule.setEnabled(true);
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        SmRule_test.assertEquals((String)"Enabled state has not been modified", (boolean)true, (boolean)smRule.getEnabled());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule.setDescription("Modified description");
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertEquals((String)"Description has not been modified", (String)"Modified description", (String)smRule.getDescription());
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Rule has not been deleted", (boolean)smRule.getOid().isNull());
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionAgentWithActiveExpression() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionAgentWithActiveExpression" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionAgentWithActiveExpression");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smRule.setActiveExpression("<@lib=\"a\" func=\"b\" param=\"c\"@>");
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgentWithActiveExpression" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgentWithActiveExpression" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionAgentWithTimeRestriction() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionAgentWithTimeRestriction" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionAgentWithTimeRestriction");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        SmTime smTime = new SmTime();
        byte[] byArray = new byte[24];
        for (int i = 0; i < 24; ++i) {
            byArray[i] = 85;
        }
        smTime.setTimeGrid(byArray);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2010);
        calendar.set(2, 6);
        calendar.set(5, 1);
        smTime.setEndDate(calendar);
        smRule.setTime(smTime);
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgentWithTimeRestriction" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgentWithTimeRestriction" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAuthAcceptAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthAcceptAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAuthAcceptAgent");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        SmApiResult smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthAcceptAgent" + this.random);
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthAcceptAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAuthAttemptAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthAttemptAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAuthAttemptAgent");
        smRule.setAction("OnAuthAttempt");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthAttemptAgent" + this.random);
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthAttemptAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAuthChallengeAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthChallengeAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAuthChallengeAgent");
        smRule.setAction("OnAuthChallenge");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        SmApiResult smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthChallengeAgent" + this.random);
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthAttemptAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAuthRejectAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthRejectAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAuthRejectAgent");
        smRule.setAction("OnAuthReject");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthRejectAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthRejectAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAuthUserNotFoundAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionOnAuthUserNotFoundAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAuthUserNotFoundAgent");
        smRule.setAction("OnAuthUserNotFound");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthUserNotFoundAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAuthUserNotFoundAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testGlobalRuleWithEjbAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testGlobalRuleWithEjbAgent" + this.random);
        smRule.setDescription("testGlobalRuleWithEjbAgent");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.ejbAgent.getOid());
        smRule.setActiveExpression("<@lib=\"a\" func=\"b\" param=\"c\"@>");
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testGlobalRuleWithEjbAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testGlobalRuleWithEjbAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAccessAcceptAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionOnAccessAcceptAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAccessAcceptAgent");
        smRule.setAction("OnAccessAccept");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAccessAcceptAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAccessAcceptAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionOnAccessRejectAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionOnAccessRejectAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionOnAccessRejectAgent");
        smRule.setAction("OnAccessReject");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAccessRejectAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAccessRejectAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testchangeDomainOfGlobalRuletoLocalDomain() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testchangeDomainOfGlobalRuletoLocalDomain" + this.random);
        smRule.setDescription("testchangeDomainOfGlobalRuletoLocalDomain");
        smRule.setAction("OnAuthAccept");
        smRule.setDomain((Object)SmObjId.NULL_OID);
        smRule.setRealm((Object)SmObjId.NULL_OID);
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        SmApiResult smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testchangeDomainOfGlobalRuletoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule.setRealm((Object)SetupRuleTestData.realm);
        smRule.setDomain((Object)SetupRuleTestData.domain);
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testchangeDomainOfGlobalRuletoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertEquals((String)"Domain of global rule is not null", (String)SmObjId.NULL_OID.toString(), (String)smRule.getDomain().toString());
        SmRule_test.assertEquals((String)"Realm of global rule is not null", (String)SmObjId.NULL_OID.toString(), (String)smRule.getRealm().toString());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testchangeDomainOfGlobalRuletoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testchangeDomainOfGlobalRuletoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testchangeDomainOflocalRuletoGlobalDomain() throws SmApiException {
        SetupRuleTestData.rule.setRealm((Object)SmObjId.NULL_OID);
        SetupRuleTestData.rule.setDomain((Object)SmObjId.NULL_OID);
        SmApiResult smApiResult = SetupRuleTestData.policyapi.modifyRule(SetupRuleTestData.rule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testchangeDomainRealmOfLocalRuletoGlobalDomainRealm() throws SmApiException {
        SetupRuleTestData.rule.setRealm((Object)SmObjId.NULL_OID);
        SetupRuleTestData.rule.setDomain((Object)SmObjId.NULL_OID);
        SmApiResult smApiResult = SetupRuleTestData.policyapi.modifyRule(SetupRuleTestData.rule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testModifyGlobalRuleNametoEmptyString() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testModifyGlobalRuleNametoEmptyString" + this.random);
        smRule.setDescription("testModifyGlobalRuleNametoEmptyString");
        smRule.setAction("OnAuthAccept");
        smRule.setDomain((Object)SmObjId.NULL_OID);
        smRule.setRealm((Object)SmObjId.NULL_OID);
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        SmApiResult smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleNametoEmptyString" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule.setName("");
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleNametoEmptyString" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testModifyGlobalRuleNametoNameContainingAsterisk() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testModifyGlobalRuleNametoNameContainingAsterisk" + this.random);
        smRule.setDescription("testModifyGlobalRuleNametoNameContainingAsterisk");
        smRule.setAction("OnAuthAccept");
        smRule.setDomain((Object)SmObjId.NULL_OID);
        smRule.setRealm((Object)SmObjId.NULL_OID);
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleNametoNameContainingAsterisk" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        smRule.setName("abc*abc" + this.random);
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleNametoNameContainingAsterisk" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionOnAccessRejectAgent" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testModifyGlobalRuleAgenttoEmptyString() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testModifyGlobalRuleAgenttoEmptyString" + this.random);
        smRule.setDescription("testModifyGlobalRuleAgenttoEmptyString");
        smRule.setAction("OnAuthAccept");
        smRule.setDomain((Object)SmObjId.NULL_OID);
        smRule.setRealm((Object)SmObjId.NULL_OID);
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleAgenttoEmptyString" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        smRule.setAgent((Object)"");
        smApiResult = SetupRuleTestData.policyapi.modifyRule(smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleAgenttoEmptyString" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testModifyGlobalRuleAgenttoEmptyString" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testcheckGlobalRuleDefaultResource() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testcheckGlobalRuleDefaultResource" + this.random);
        smRule.setDescription("testcheckGlobalRuleDefaultResource");
        smRule.setAction("OnAuthAccept");
        smRule.setDomain((Object)SmObjId.NULL_OID);
        smRule.setRealm((Object)SmObjId.NULL_OID);
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testcheckGlobalRuleDefaultResource" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertEquals((String)"Resource doesn't matches with *", (String)"*", (String)smRule.getResource());
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupRuleTestData.policyapi.getRule("testcheckGlobalRuleDefaultResource" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionAgentGroup() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameActionAgentGroup" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionAgentGroup");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.aggroup.getOid());
        SmApiResult smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgentGroup" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Unable to fetch Rule (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to fetch Rule (NULL OID)", (boolean)smRule.getOid().isNull());
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testaddGlobalRuleWithNameActionAgentGroup" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionRadiusAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionRadiusAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionRadiusAgent");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.radagent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameAgentWithoutAction() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testaddGlobalRuleWithNameAgentWithoutAction" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameAgentWithoutAction");
        smRule.setAgent((Object)SetupRuleTestData.radagent.getOid());
        SmApiResult smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testdeleteNonExistantGlobalRule() throws SmApiException {
        SmRule smRule = new SmRule();
        smRule.setName("testDeleteNonExistantGlobalRule" + this.random);
        SmApiResult smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithInvalidCharsInName() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRule***WithInvalidCharsInName" + this.random);
        smRule.setDescription("testaddGlobalRule***WithInvalidCharsInName");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.agent.getOid());
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalRuleWithNameActionWithoutAgent() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testaddGlobalRuleWithNameActionWithoutAgent" + this.random);
        smRule.setDescription("testaddGlobalRuleWithNameActionWithoutAgent");
        smRule.setAction("OnAuthAccept");
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testGlobalRuleWithEjbAgentOnAuthReject() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testGlobalRuleWithEjbAgentOnAuthReject" + this.random);
        smRule.setDescription("testGlobalRuleWithEjbAgentOnAuthReject");
        smRule.setAction("invoke");
        smRule.setAgent((Object)SetupRuleTestData.ejbAgent.getOid());
        smRule.setActiveExpression("<@lib=\"a\" func=\"b\" param=\"c\"@>");
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Rule added with invalid action. (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertTrue((String)"Rule added with invalid action. (OID NOT NULL)", (boolean)smRule.getOid().isNull());
    }

    public void testGlobalRuleWithDuplicateName() throws SmApiException {
        SmRule smRule = new SmRule();
        SmApiResult smApiResult = new SmApiResult();
        smRule.setName("testGlobalRuleWithDuplicateName" + this.random);
        smRule.setDescription("testGlobalRuleWithDuplicateName");
        smRule.setAction("OnAuthAccept");
        smRule.setAgent((Object)SetupRuleTestData.ejbAgent.getOid());
        smRule.setActiveExpression("<@lib=\"a\" func=\"b\" param=\"c\"@>");
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule, true);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRule.getOid().isValid());
        SmRule_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRule.getOid().isNull());
        SmRule smRule2 = new SmRule();
        smRule2.setName("testGlobalRuleWithDuplicateName" + this.random);
        smRule2.setDescription("testGlobalRuleWithDuplicateName");
        smRule2.setAction("OnAuthAccept");
        smRule2.setAgent((Object)SetupRuleTestData.ejbAgent.getOid());
        smRule2.setActiveExpression("<@lib=\"a\" func=\"b\" param=\"c\"@>");
        smApiResult = SetupRuleTestData.policyapi.addRule(smRule2, true);
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRule_test.assertTrue((String)"Rule with duplicate name added. (VALID OID)", (boolean)smRule2.getOid().isValid());
        SmRule_test.assertTrue((String)"Rule with duplicate name added. (OID NOT NULL)", (boolean)smRule2.getOid().isNull());
        smApiResult = SetupRuleTestData.policyapi.deleteRule(smRule);
        SmRule_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smRule = new SmRule();
        smApiResult = SetupRuleTestData.policyapi.getRule("testGlobalRuleWithDuplicateName" + this.random, SmObjId.NULL_OID.toString(), SmObjId.NULL_OID.toString(), smRule);
        SmRule_test.assertTrue((String)"Rule has not been deleted", (boolean)smRule.getOid().isNull());
        SmRule_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmRule_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmRule_test.class);
        return new SetupRuleTestData((Test)testSuite);
    }
}

