/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.func_test.SetupDomainResponseTestData;
import com.netegrity.sdk.func_test.SetupRealmTestData;
import com.netegrity.sdk.policyapi.SmAgent;
import com.netegrity.sdk.policyapi.SmRealm;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmRealm_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testaddWebRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("webagent" + this.random);
        smAgent.setAgentType((Object)"Web Agent");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("webrealm" + this.random);
        smRealm.setResourceFilter("/webrealm/");
        smRealm.setDescription("test-sample-webrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("webagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddAffilateRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("affilateagent" + this.random);
        smAgent.setAgentType((Object)"Affiliate Agent");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("affilaterealm" + this.random);
        smRealm.setResourceFilter("/affilaterealm/");
        smRealm.setDescription("test-sample-affilaterealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("affilaterealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("affilateagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("affilaterealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddEJBRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("ejbagent" + this.random);
        smAgent.setAgentType((Object)"EJB Agent");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("ejbrealm" + this.random);
        smRealm.setResourceFilter("/ejbrealm/");
        smRealm.setDescription("test-sample-ejbrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("ejbrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("ejbagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("ejbrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddServletRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("servletagent" + this.random);
        smAgent.setAgentType((Object)"Servlet Agent");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("servletrealm" + this.random);
        smRealm.setResourceFilter("/servletrealm/");
        smRealm.setDescription("test-sample-servletrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("servletrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("servletagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("servletrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testadd3ComRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("3comagent" + this.random);
        smAgent.setAgentType((Object)"3Com");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("3comrealm" + this.random);
        smRealm.setResourceFilter("/3comrealm/");
        smRealm.setDescription("test-sample-3comrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("3comrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("3comagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("3comrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddAscendRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("ascendagent" + this.random);
        smAgent.setAgentType((Object)"Ascend");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("ascendrealm" + this.random);
        smRealm.setResourceFilter("/ascendrealm/");
        smRealm.setDescription("test-sample-ascendrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("ascendrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("ascendagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("ascendrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddBayNetworksRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("baynetworksagent" + this.random);
        smAgent.setAgentType((Object)"Bay Networks");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("baynetworksrealm" + this.random);
        smRealm.setResourceFilter("/baynetworksrealm/");
        smRealm.setDescription("test-sample-baynetworksrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("baynetworksrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("baynetworksagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("baynetworksrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddCheckPointRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("checkpointagent" + this.random);
        smAgent.setAgentType((Object)"CheckPoint");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("checkpointrealm" + this.random);
        smRealm.setResourceFilter("/checkpointrealm/");
        smRealm.setDescription("test-sample-checkpointrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("checkpointrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("checkpointagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("checkpointrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddCiscoRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("ciscoagent" + this.random);
        smAgent.setAgentType((Object)"Sisco");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("ciscorealm" + this.random);
        smRealm.setResourceFilter("/ciscorealm/");
        smRealm.setDescription("test-sample-ciscorealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("ciscorealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("ciscoagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("ciscorealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddGenericRadiusRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("genericradiusagent" + this.random);
        smAgent.setAgentType((Object)"Generic RADIUS");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("genericradiusrealm" + this.random);
        smRealm.setResourceFilter("/genericradiusrealm/");
        smRealm.setDescription("test-sample-genericradiusrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("genericradiusrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("genericradiusagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("genericradiusrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddLivingstonRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("livingstonagent" + this.random);
        smAgent.setAgentType((Object)"Livingston");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("livingstonrealm" + this.random);
        smRealm.setResourceFilter("/livingstonrealm/");
        smRealm.setDescription("test-sample-livingstonrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("livingstonrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("livingstonagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("livingstonrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddNetworkAssociatesRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("networkassociatesagent" + this.random);
        smAgent.setAgentType((Object)"Network Associates' Sniffer");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("networkassociatesrealm" + this.random);
        smRealm.setResourceFilter("/networkassociatesrealm/");
        smRealm.setDescription("test-sample-networkassociatesrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("networkassociatesrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("networkassociatesagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("networkassociatesrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddShivaRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("shivaagent" + this.random);
        smAgent.setAgentType((Object)"Shiva");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("shivarealm" + this.random);
        smRealm.setResourceFilter("/shivarealm/");
        smRealm.setDescription("test-sample-shivarealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("shivarealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("shivaagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("shivarealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddTeleBitRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("telebitagent" + this.random);
        smAgent.setAgentType((Object)"TeleBit");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("telebitrealm" + this.random);
        smRealm.setResourceFilter("/telebitrealm/");
        smRealm.setDescription("test-sample-telebitrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("telebitrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("telebitagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("telebitrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddUSRoboticsRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("usroboticsagent" + this.random);
        smAgent.setAgentType((Object)"U.S. Robotics");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("usroboticsrealm" + this.random);
        smRealm.setResourceFilter("/usroboticsrealm/");
        smRealm.setDescription("test-sample-usroboticsrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("usroboticsrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("usroboticsagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("usroboticsrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddDuplicateWebRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("webduplicateagent" + this.random);
        smAgent.setAgentType((Object)"SmAgentType.DefaultAgentType");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("webduplicaterealm" + this.random);
        smRealm.setResourceFilter("/webduplicaterealm/");
        smRealm.setDescription("test-sample-webduplicaterealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webduplicaterealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        SmRealm smRealm2 = new SmRealm();
        smRealm2.setName("webduplicaterealm" + this.random);
        smRealm2.setResourceFilter("/webduplicaterealm2/");
        smRealm2.setDescription("test-sample-webduplicaterealm");
        smRealm2.setDomain((Object)SetupRealmTestData.domain);
        smRealm2.setAgent((Object)smAgent);
        smRealm2.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm2);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Realm created with same name (INVALID OID)", (boolean)smRealm2.getOid().isValid());
        SmRealm_test.assertTrue((String)"Realm created with same name (NULL OID)", (boolean)smRealm2.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("webduplicateagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webduplicaterealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddDuplicateFilterWebRealm() throws SmApiException {
        SmAgent smAgent = new SmAgent();
        smAgent.setName("webduplicatefilteragent" + this.random);
        smAgent.setAgentType((Object)"SmAgentType.DefaultAgentType");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        SmApiResult smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        SmRealm smRealm = new SmRealm();
        smRealm.setName("webduplicatefilterrealm" + this.random);
        smRealm.setResourceFilter("/webduplicatefilterrealm/");
        smRealm.setDescription("test-sample-webduplicatefilterrealm");
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setAgent((Object)smAgent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webduplicatefilterrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        SmRealm smRealm2 = new SmRealm();
        smRealm2.setName("webduplicatefilterrealm" + this.random);
        smRealm2.setResourceFilter("/webduplicatefilterrealm/");
        smRealm2.setDescription("test-sample-webduplicatefilterrealm2");
        smRealm2.setDomain((Object)SetupRealmTestData.domain);
        smRealm2.setAgent((Object)smAgent);
        smRealm2.setScheme((Object)SetupRealmTestData.scheme);
        smApiResult = SetupRealmTestData.policyapi.addRealm(smRealm2);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Realm created with same filter (INVALID OID)", (boolean)smRealm2.getOid().isValid());
        SmRealm_test.assertTrue((String)"Realm created with same filter (NULL OID)", (boolean)smRealm2.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgent("webduplicatefilterrealm" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webduplicatefilterrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddChildRealm() throws SmApiException {
        SmRealm smRealm = new SmRealm();
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setName("webrealm" + this.random);
        smRealm.setResourceFilter("/webrealm/");
        smRealm.setDescription("test-sample-webrealm");
        smRealm.setAgent((Object)SetupRealmTestData.agent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        SmApiResult smApiResult = SetupConnection.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        SmRealm smRealm2 = new SmRealm();
        smRealm2.setDomain((Object)SetupRealmTestData.domain);
        smRealm2.setName("webchildrealm" + this.random);
        smRealm2.setResourceFilter("webchildrealm/");
        smRealm2.setDescription("test-sample-webchildrealm");
        smRealm2.setAgent((Object)SetupRealmTestData.agent);
        smRealm2.setParentRealmOid((Object)smRealm.getOid());
        smApiResult = SetupConnection.policyapi.addRealm(smRealm2);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new child Realm (INVALID OID)", (boolean)smRealm2.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new child Realm (NULL OID)", (boolean)smRealm2.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webchildrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm2.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm2.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm2);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        smApiResult = SetupConnection.policyapi.deleteAgent("webagent" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webchildrealm" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public void testaddModifyRealm() throws SmApiException {
        SmRealm smRealm = new SmRealm();
        smRealm.setDomain((Object)SetupRealmTestData.domain);
        smRealm.setName("webrealm1" + this.random);
        smRealm.setResourceFilter("/webrealm1/");
        smRealm.setDescription("test-sample-webrealm1");
        smRealm.setAgent((Object)SetupRealmTestData.agent);
        smRealm.setScheme((Object)SetupRealmTestData.scheme);
        SmApiResult smApiResult = SetupConnection.policyapi.addRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webrealm1" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to fetch Realm (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to fetch Realm (NULL OID)", (boolean)smRealm.getOid().isNull());
        SmAgent smAgent = new SmAgent();
        smAgent.setName("webagent" + this.random);
        smAgent.setAgentType((Object)"SmAgentType.DefaultAgentType");
        smAgent.setIpAddr("127.0.0.1");
        smAgent.setSecret("firewall");
        smApiResult = SetupConnection.policyapi.addAgent(smAgent);
        smRealm.setName("webrealm2" + this.random);
        smRealm.setResourceFilter("webrealm2/");
        smRealm.setAgent((Object)smAgent);
        smApiResult = SetupConnection.policyapi.modifyRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to modify object (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertFalse((String)"Unable to modify object (NULL OID)", (boolean)smRealm.getOid().isNull());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        SmRealm_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupDomainResponseTestData.policyapi.deleteRealm(smRealm);
        smApiResult = SetupConnection.policyapi.deleteAgent("webagent1" + this.random);
        smRealm = new SmRealm();
        smApiResult = SetupDomainResponseTestData.policyapi.getRealm("webrealm2" + this.random, SetupRealmTestData.domain.getName(), smRealm);
        SmRealm_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmRealm_test.assertTrue((String)"Unable to delete Realm. (INVALID OID)", (boolean)smRealm.getOid().isValid());
        SmRealm_test.assertTrue((String)"Unable to delete Realm. (NULL OID)", (boolean)smRealm.getOid().isNull());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmRealm_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmRealm_test.class);
        return new SetupRealmTestData((Test)testSuite);
    }
}

