/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.policyapi.SmAuthValidateMap;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmAuthValidateMap_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testaddAuthValidateMap1() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir1" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir1" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthDir1" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create AuthValidateMap Object. (INVALID OID).", (boolean)smAuthValidateMap.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create AuthValidateMap Object. (NULL OID).", (boolean)smAuthValidateMap.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir1" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir1" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddAuthValidateMap2() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir2" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir2" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("Jun&it-sample-authdir");
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap added with invalid Authentication directory name.", (int)1367, (int)smApiResult.getError());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir2" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir2" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddAuthValidateMap3() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir3" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir3" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("Invalid mapping type");
        smAuthValidateMap.setAuthUserDir("testSampleUserdir3" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap added with invalid Authentication-Validation mapping type", (int)1239, (int)smApiResult.getError());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir3" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir3" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddAuthValidateMap4() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir4" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir4" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap Object created without Authentication directory name", (int)1303, (int)smApiResult.getError());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir4" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir4" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testaddAuthValidateMap5() throws SmApiException {
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleUserdir5" + this.random);
        SmApiResult smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap Object created without Validation directory Oid.", (int)1303, (int)smApiResult.getError());
    }

    public void testmodifyAuthValidateMap1() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir6" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir6" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthDir");
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create AuthValidateMap Object. (INVALID OID).", (boolean)smAuthValidateMap.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create AuthValidateMap Object. (NULL OID).", (boolean)smAuthValidateMap.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to fetch AuthValidateMap to modify. (INVALID OID).", (boolean)smAuthValidateMap2.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to fetch AuthValidateMap to modify. (NULL OID).", (boolean)smAuthValidateMap2.getOid().isNull());
        smAuthValidateMap2.setAuthUserDir("testSampleUserdir6Modified" + this.random);
        smAuthValidateMap2.setAuthValidateType("UserDN");
        SmUserDirectory smUserDirectory2 = new SmUserDirectory();
        smUserDirectory2.setName("testSampleUserdir7" + this.random);
        smUserDirectory2.setNamespace("LDAP:");
        smUserDirectory2.setServer("127.0.0.1");
        smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory2.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory2.getOid().isNull());
        smAuthValidateMap2.setValidateUserDir((Object)smUserDirectory2.getOid());
        smApiResult = SetupConnection.policyapi.modifyAuthValidateMap(smAuthValidateMap2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir6" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir6" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir7" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir7" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testmodifyAuthValidateMap2() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir8" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir8" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir8" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smAuthValidateMap2.setAuthUserDir("");
        smApiResult = SetupConnection.policyapi.modifyAuthValidateMap(smAuthValidateMap2);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap Modified without specifying Authentication directory name.", (int)1303, (int)smApiResult.getError());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir8" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir8" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testmodifyAuthValidateMap3() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir9" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir9" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir9" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smAuthValidateMap2.setAuthUserDir("Jun&it-sample-authdir");
        smApiResult = SetupConnection.policyapi.modifyAuthValidateMap(smAuthValidateMap2);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap modified with invalid Authentication directory name", (int)1367, (int)smApiResult.getError());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir9" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir9" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testmodifyAuthValidateMap4() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir10" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir10" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir10" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smAuthValidateMap2.setValidateUserDir((Object)"Junit-sample-authdir&");
        smApiResult = SetupConnection.policyapi.modifyAuthValidateMap(smAuthValidateMap2);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"AuthValidateMap modified with Validation directory Oid as null", (int)2323, (int)smApiResult.getError());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir10" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir10" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testgetAuthValidateMap1() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir11" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir11" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir11" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create new object(INVALID OID)", (boolean)smAuthValidateMap.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smAuthValidateMap.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"UniversalID", (String)smAuthValidateMap2.getAuthValidateType());
        SmAuthValidateMap_test.assertEquals((String)("testSampleAuthdir11" + this.random), (String)smAuthValidateMap2.getAuthUserDir());
        SmAuthValidateMap_test.assertEquals((String)smUserDirectory.getOid().toString(), (String)smAuthValidateMap2.getValidateUserDir().toString());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir11" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir11" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testgetAuthValidateMap2() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir12" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir12" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir12" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create AuthValidateMap Object. (INVALID OID)", (boolean)smAuthValidateMap.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create AuthValidateMap Object. (NULL OID)", (boolean)smAuthValidateMap.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir12" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir12" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        smApiResult = SetupConnection.policyapi.getAuthValidateMap(smAuthValidateMap.getOid(), smAuthValidateMap2);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"Could not delete AuthValidateMap object. ", (int)2323, (int)smApiResult.getError());
    }

    public void testdeleteAuthValidateMap1() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir13" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir13" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir13" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir13" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir13" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testdeleteAuthValidateMap2() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir14" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir14" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir14" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir14" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir14" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertEquals((String)"Non existing AuthValidateMap object deleted.", (int)2323, (int)smApiResult.getError());
    }

    public void testgetGlobalObjectNames1() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir15" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to create user directory (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir15" + this.random, smUserDirectory);
        smAuthValidateMap.setValidateUserDir((Object)smUserDirectory.getOid());
        smAuthValidateMap.setAuthValidateType("UniversalID");
        smAuthValidateMap.setAuthUserDir("testSampleAuthdir15" + this.random);
        smApiResult = SetupConnection.policyapi.addAuthValidateMap(smAuthValidateMap);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        Vector vector = new Vector();
        smApiResult = SetupConnection.policyapi.getGlobalObjectNames("AuthValidateMaps", vector);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        Enumeration enumeration = vector.elements();
        String string = "";
        SmAuthValidateMap smAuthValidateMap2 = new SmAuthValidateMap();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            smApiResult = SetupConnection.policyapi.getAuthValidateMap(SmObjId.valueOf((String)string), smAuthValidateMap2);
            SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
            if (!smAuthValidateMap2.getAuthUserDir().equals(smAuthValidateMap.getAuthUserDir()) || !smAuthValidateMap2.getValidateUserDir().toString().equals(smAuthValidateMap.getValidateUserDir().toString()) || !smAuthValidateMap2.getAuthValidateType().equals(smAuthValidateMap.getAuthValidateType())) continue;
            bl = true;
            break;
        }
        SmAuthValidateMap_test.assertTrue((boolean)bl);
        smApiResult = SetupConnection.policyapi.deleteAuthValidateMap(smAuthValidateMap.getOid());
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir15" + this.random);
        SmAuthValidateMap_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smUserDirectory = new SmUserDirectory();
        smApiResult = SetupConnection.policyapi.getUserDirectory("testSampleUserdir7" + this.random, smUserDirectory);
        SmAuthValidateMap_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (invalid OID).", (boolean)smUserDirectory.getOid().isValid());
        SmAuthValidateMap_test.assertTrue((String)"Unable to delete user directory. (OID NOT NULL).", (boolean)smUserDirectory.getOid().isNull());
    }

    public void testReadProperties1() throws Throwable {
        try {
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.readProperties((Hashtable)null);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testReadProperties2() throws Throwable {
        try {
            Hashtable hashtable = new Hashtable();
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.readProperties(hashtable);
            SmAuthValidateMap_test.assertEquals(null, (String)smAuthValidateMap.toString());
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testWriteProperties1() throws Throwable {
        try {
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.writeProperties((Hashtable)null);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testWriteProperties2() throws Throwable {
        try {
            Hashtable hashtable = new Hashtable();
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.writeProperties(hashtable);
            SmAuthValidateMap_test.assertEquals(null, (String)smAuthValidateMap.toString());
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testSetAuthUserDir() throws Throwable {
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap("");
        smAuthValidateMap.setAuthUserDir("");
        SmAuthValidateMap_test.assertEquals((String)"", (String)smAuthValidateMap.getAuthUserDir());
    }

    public void testSetValidateUserDir() throws Throwable {
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap("");
        smAuthValidateMap.setValidateUserDir((Object)SmObjId.NULL_OID);
        SmAuthValidateMap_test.assertEquals((String)SmObjId.NULL_OID.toString(), (String)smAuthValidateMap.getValidateUserDir().toString());
    }

    public void testSetAuthValidateType() throws Throwable {
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap("");
        smAuthValidateMap.setAuthValidateType("");
        SmAuthValidateMap_test.assertEquals((String)"", (String)smAuthValidateMap.getAuthValidateType());
    }

    public void testSmAuthValidateMap1() throws Throwable {
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap();
        SmAuthValidateMap_test.assertEquals(null, (String)smAuthValidateMap.toString());
    }

    public void testSmAuthValidateMap2() throws Throwable {
        try {
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            SmAuthValidateMap_test.assertEquals(null, (String)smAuthValidateMap.toString());
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testGetAuthValidateMap1() throws Throwable {
        try {
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.setName((String)null);
            smAuthValidateMap.setDescription((String)null);
            smAuthValidateMap.setAuthUserDir((String)null);
            smAuthValidateMap.setValidateUserDir((Object)null);
            String string = smAuthValidateMap.getAuthValidateType();
            SmAuthValidateMap_test.assertEquals((String)"UserDN", (String)string);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testGetAuthUserDir1() throws Throwable {
        try {
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.setName((String)null);
            smAuthValidateMap.setDescription((String)null);
            smAuthValidateMap.setValidateUserDir((Object)null);
            String string = smAuthValidateMap.getAuthUserDir();
            SmAuthValidateMap_test.assertEquals((String)"", (String)string.toString());
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public void testGetAuthValidateDir1() throws Throwable {
        try {
            SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap((String)null);
            smAuthValidateMap.setName((String)null);
            smAuthValidateMap.setDescription((String)null);
            smAuthValidateMap.setValidateUserDir((Object)null);
            SmObjId smObjId = smAuthValidateMap.getValidateUserDir();
            SmAuthValidateMap_test.assertNotNull((Object)smObjId);
            SmAuthValidateMap_test.assertEquals((String)"00-", (String)smObjId.toString());
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        SmAuthValidateMap_test.fail((String)"expected NullPointerException");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmAuthValidateMap_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmAuthValidateMap_test.class);
        return new SetupConnection((Test)testSuite);
    }
}

