/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.policyapi.SmScheme;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmAuthScheme_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testaddAnonymousAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("anonymousauthscheme" + this.random);
        smScheme.setDescription("test-sample-anonymousauthscheme");
        smScheme.setType(13);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Anonymous Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Anonymous Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("anonymousauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Anonymous Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Anonymous Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("anonymousauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("anonymousauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Anonymous Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Anonymous Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddBasicOverSSLAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("basicoversslauthscheme" + this.random);
        smScheme.setDescription("test-sample-basicoversslauthscheme");
        smScheme.setType(5);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Basic Over SSL Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Basic Over SSL Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("basicoversslauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Basic Over SSL Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Basic Over SSL Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("basicoversslauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("basicoversslauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Basic Over SSL Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Basic Over SSL Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddBasicAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("basicauthscheme" + this.random);
        smScheme.setDescription("test-sample-basicauthscheme");
        smScheme.setType(1);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("basicauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("basicauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("basicauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Basic Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddCryptoCardRBAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("cryptocardrbauthscheme" + this.random);
        smScheme.setDescription("test-sample-cryptocardrbauthscheme");
        smScheme.setType(2);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add CRYPTOCard RB-1 Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add CRYPTOCard RB-1 Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("cryptocardrbauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch CRYPTOCard RB-1 Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch CRYPTOCard RB-1 Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("cryptocardrbauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("cryptocardrbauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete CRYPTOCard RB-1 Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete CRYPTOCard RB-1 Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddHTMLFormAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("htmlformauthscheme" + this.random);
        smScheme.setDescription("test-sample-htmlformauthscheme");
        smScheme.setType(4);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("htmlformauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("htmlformauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("htmlformauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete HTML Form Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddRadiusChapPapAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("radiuschappapauthscheme" + this.random);
        smScheme.setDescription("test-sample-radiuschappapauthscheme");
        smScheme.setType(12);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add RADIUS CHAP/PAP Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add RADIUS CHAP/PAP Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("radiuschappapauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch RADIUS CHAP/PAP Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch RADIUS CHAP/PAP Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("radiuschappapauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("radiuschappapauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete RADIUS CHAP/PAP Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete RADIUS CHAP/PAP Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddRadiusServerAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("radiusserverauthscheme" + this.random);
        smScheme.setDescription("test-sample-radiusserverauthscheme");
        smScheme.setType(6);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add RADIUS Server Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add RADIUS Server Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("radiusserverauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch RADIUS Server Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch RADIUS Server Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("radiusserverauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("radiusserverauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete RADIUS Server Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete RADIUS Server Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddSafeWordAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("safewordauthscheme" + this.random);
        smScheme.setDescription("test-sample-safewordauthscheme");
        smScheme.setType(7);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add SafeWord Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add SafeWord Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("safewordauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch SafeWord Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch SafeWord Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("safewordauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("safewordauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete SafeWord Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete SafeWord Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddSecureIDHTMLFormAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("secureidhtmlformauthscheme" + this.random);
        smScheme.setDescription("test-sample-secureidhtmlformauthscheme");
        smScheme.setType(17);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add SecurID HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add SecurID HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("secureidhtmlformauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch SecurID HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch SecurID HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("secureidhtmlformauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("secureidhtmlformauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete SecurID HTML Form Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete SecurID HTML Form Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddWindowsAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("windowsauthscheme" + this.random);
        smScheme.setDescription("test-sample-windowsauthscheme");
        smScheme.setType(14);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Windows Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Windows Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("windowsauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Windows Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Windows Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("windowsauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("windowsauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Windows Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Windows Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddX509ClienCertAndBasicAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("x509clientcertandbasicauthscheme" + this.random);
        smScheme.setDescription("test-sample-x509clientcertandbasicauthscheme");
        smScheme.setType(10);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add X509 Client Cert and Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add X509 Client Cert and Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("x509clientcertandbasicauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch X509 Client Cert and Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch X509 Client Cert and Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("x509clientcertandbasicauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("x509clientcertandbasicauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete X509 Client Cert and Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete X509 Client Cert and Basic Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddX509ClienCertOrBasicAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("x509clientcertorbasicauthscheme" + this.random);
        smScheme.setDescription("test-sample-x509clientcertorbasicauthscheme");
        smScheme.setType(11);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add X509 Client Cert or Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add X509 Client Cert or Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("x509clientcertorbasicauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch X509 Client Cert or Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch X509 Client Cert or Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("x509clientcertorbasicauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("x509clientcertorbasicauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete X509 Client Cert or Basic Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete X509 Client Cert or Basic Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddX509ClienCertAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("x509clientcertauthscheme" + this.random);
        smScheme.setDescription("test-sample-x509clientcertauthscheme");
        smScheme.setType(11);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add X509 Client Cert Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add X509 Client Cert Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("x509clientcertauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch X509 Client Cert Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch X509 Client Cert Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("x509clientcertauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("x509clientcertauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete X509 Client Cert Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete X509 Client Cert Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddCustomAuthScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("customauthscheme" + this.random);
        smScheme.setDescription("test-sample-customauthscheme");
        smScheme.setType(15);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Custom Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Custom Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("customauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Custom Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Custom Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("customauthscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("customauthscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Custom Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Custom Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testModifyScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("scheme" + this.random);
        smScheme.setDescription("test-sample-scheme");
        smScheme.setType(1);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("scheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme.setName("modifyscheme" + this.random);
        smScheme.setDescription("test-sample-modifyscheme");
        smScheme.setType(15);
        smScheme.setLevel(20);
        smScheme.setSecret("firewall2");
        smScheme.setParameter("modifyschemeparam");
        smScheme.setLibrary("modifyschemelib");
        smApiResult = SetupConnection.policyapi.modifyScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to modify Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to modify Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("modifyscheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("modifyscheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("modifyscheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddDuplicateScheme() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("duplicatescheme" + this.random);
        smScheme.setDescription("test-sample-duplicatescheme");
        smScheme.setType(1);
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to add Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to add Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("duplicatescheme" + this.random, smScheme);
        SmAuthScheme_test.assertTrue((String)"Unable to fetch Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertFalse((String)"Unable to fetch Scheme. (INVALID OID)", (boolean)smScheme.getOid().isNull());
        SmScheme smScheme2 = new SmScheme();
        smScheme2.setName("duplicatescheme" + this.random);
        smScheme2.setDescription("test-sample-duplicatescheme");
        smScheme2.setType(1);
        smApiResult = SetupConnection.policyapi.addScheme(smScheme2);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Scheme added with same name. (INVALID OID)", (boolean)smScheme2.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Scheme added with same name. (INVALID OID)", (boolean)smScheme2.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteScheme("duplicatescheme" + this.random);
        SmAuthScheme_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smScheme = new SmScheme();
        smApiResult = SetupConnection.policyapi.getScheme("duplicatescheme" + this.random, smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Custom Auth Scheme. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Unable to delete Custom Auth Scheme. (NULL OID)", (boolean)smScheme.getOid().isNull());
    }

    public void testaddAnonymousSchemeWithCreds() throws SmApiException {
        SmScheme smScheme = new SmScheme();
        smScheme.setName("anonymousauthscheme" + this.random);
        smScheme.setDescription("test-sample-anonymousauthscheme");
        smScheme.setType(13);
        smScheme.setLevel(10);
        smScheme.setSecret("firewall");
        smScheme.setParameter("schemeparam");
        smScheme.setLibrary("schemelib");
        smScheme.setAllowSaveCreds(true);
        SmApiResult smApiResult = SetupConnection.policyapi.addScheme(smScheme);
        SmAuthScheme_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAuthScheme_test.assertTrue((String)"Anonymous Auth Scheme added. (INVALID OID)", (boolean)smScheme.getOid().isValid());
        SmAuthScheme_test.assertTrue((String)"Anonymous Auth Scheme added. (INVALID OID)", (boolean)smScheme.getOid().isNull());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmAuthScheme_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmAuthScheme_test.class);
        return new SetupConnection((Test)testSuite);
    }
}

