/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.policyapi.SmAgent;
import com.netegrity.sdk.policyapi.SmAgentGroup;
import com.netegrity.sdk.policyapi.SmDomain;
import com.netegrity.sdk.policyapi.SmObject;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmResponse;
import com.netegrity.sdk.policyapi.SmResponseGroup;
import com.netegrity.sdk.policyapi.SmRule;
import com.netegrity.sdk.policyapi.SmRuleGroup;
import junit.framework.Test;

class SetupPolicyApiTestData
extends SetupConnection {
    public static SmAgent agent;
    public static SmAgent radagent;
    public static SmAgentGroup aggroup;
    public static SmDomain domain;
    public static SmRealm realm;
    public static SmRule rule;
    public static SmRuleGroup rulegroup;
    public static SmResponseGroup responsegroup;
    public static SmResponse response;

    SetupPolicyApiTestData(Test test) {
        super(test);
    }

    protected void setUp() {
        this.Connect();
        this.CreateObjects();
    }

    private void CreateObjects() {
        long l = System.currentTimeMillis();
        agent = new SmAgent();
        agent.setName("agent" + l);
        radagent = new SmAgent();
        radagent.setName("radagent" + l);
        radagent.setAgentType((Object)"3Com");
        aggroup = new SmAgentGroup();
        aggroup.setName("aggroup" + l);
        domain = new SmDomain();
        domain.setName("domain" + l);
        realm = new SmRealm();
        realm.setName("realm" + l);
        realm.setResourceFilter("/");
        realm.setDomain((Object)domain);
        realm.setAgent((Object)agent.getOid());
        realm.setAgentType((Object)"Web Agent");
        rule = new SmRule();
        rule.setName("rule" + l);
        rule.setDomain((Object)domain);
        rule.setRealm((Object)realm);
        rule.setAgentType((Object)"Web Agent");
        rulegroup = new SmRuleGroup();
        rulegroup.setName("rulegroup" + l);
        rulegroup.setAgentType((Object)"Web Agent");
        responsegroup = new SmResponseGroup();
        responsegroup.setName("responsegroup" + l);
        responsegroup.setAgentType((Object)"Web Agent");
        response = new SmResponse();
        response.setName("testDomainResponse" + l);
        try {
            policyapi.addAgent(agent);
            SmApiResult smApiResult = policyapi.addGroup("", (SmObject)aggroup);
            policyapi.addAgent(radagent);
            policyapi.addDomain(domain);
            realm.setAgent((Object)agent.getOid());
            realm.setDomain((Object)domain);
            realm.setAgentType((Object)"Web Agent");
            rule.setDomain((Object)domain);
            rule.setAgentType((Object)"Web Agent");
            rulegroup.setDomain((Object)domain);
            responsegroup.setDomain((Object)domain);
            response.setDomain((Object)domain);
            policyapi.addRealm(realm);
            policyapi.addGroup(domain.getOid().toString(), (SmObject)responsegroup);
            policyapi.addGroup(domain.getOid().toString(), (SmObject)rulegroup);
            policyapi.addResponse(response);
            policyapi.addRule(rule);
        }
        catch (SmApiException smApiException) {
            // empty catch block
        }
    }

    protected void tearDown() throws SmApiException {
        policyapi.deleteDomain(domain.getName());
        policyapi.deleteAgent(agent.getName());
        policyapi.deleteAgent(radagent.getName());
        policyapi.deleteGroup(3, aggroup.getName(), "");
        super.tearDown();
    }
}

