/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiConnection;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.policyapi.SmPolicyApi;
import com.netegrity.sdk.policyapi.SmPolicyApiImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import junit.extensions.TestSetup;
import junit.framework.Test;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ServerDef;

class SetupConnection
extends TestSetup {
    private static AgentAPI agentapi = null;
    private static ServerDef serverdef = null;
    private static InitDef initdef = null;
    private static SmApiSession session = null;
    public static SmPolicyApi policyapi = null;
    private static final String BUNDLE_NAME = "jsdk-junit";
    private static ResourceBundle bundle = null;

    public SetupConnection(Test test) {
        super(test);
    }

    protected void setUp() {
        this.Connect();
    }

    protected void tearDown() throws SmApiException {
        session.logout();
        policyapi = null;
    }

    protected void Connect() {
        if (policyapi == null) {
            try {
                bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println("Failed to load the resource bundle jsdk-junit");
            }
            catch (ClassCastException classCastException) {
                System.out.println("Failed to load the resource bundle jsdk-junit");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("Failed to load the resource bundle jsdk-junit");
            }
            agentapi = new AgentAPI();
            serverdef = new ServerDef();
            SetupConnection.serverdef.serverIpAddress = bundle.getString("PS_IP");
            SetupConnection.serverdef.connectionMin = new Integer(bundle.getString("PS_CONMIN"));
            SetupConnection.serverdef.connectionMax = new Integer(bundle.getString("PS_CONMAX"));
            SetupConnection.serverdef.connectionStep = new Integer(bundle.getString("PS_CONSTEP"));
            SetupConnection.serverdef.timeout = new Integer(bundle.getString("PS_TIMEOUT"));
            SetupConnection.serverdef.authenticationPort = new Integer(bundle.getString("PS_AUPORT"));
            SetupConnection.serverdef.authorizationPort = new Integer(bundle.getString("PS_AZPORT"));
            SetupConnection.serverdef.accountingPort = new Integer(bundle.getString("PS_ACPORT"));
            initdef = new InitDef(new String("SMTUNNEL"), new String("SMTUNNEL"), false, serverdef);
            int n = agentapi.init(initdef);
            if (n != 0) {
                System.out.println("\nagent api init failed");
            }
            session = new SmApiSession(new SmApiConnection(agentapi));
            SmApiResult smApiResult = null;
            try {
                smApiResult = session.login(bundle.getString("ADMIN_NAME"), bundle.getString("ADMIN_PWD"), InetAddress.getLocalHost(), 0);
                if (!smApiResult.isSuccess()) {
                    System.out.println("\nsession login failed");
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("\nUnknownHostException");
            }
            catch (SmApiException smApiException) {
                System.out.println("\nexception: " + smApiException.getMessage());
            }
            policyapi = new SmPolicyApiImpl(session);
        }
    }
}

