/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.tli;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.bz;
import com.ca.siteminder.sdk.agentapi.tli.a9;
import com.ca.siteminder.sdk.agentapi.tli.ba;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.Iterator;

public class a8
implements a9,
SmAgentApiConstants {
    private int a;
    private static final String b = "SmAgentTcpTransport";
    private Selector c;
    private SelectionKey d;
    private SocketChannel e;

    public static final a8 a(SocketAddress socketAddress) throws IOException {
        if (socketAddress instanceof InetSocketAddress) {
            boolean useIPv6 = ((InetSocketAddress)socketAddress).getAddress() instanceof Inet6Address;
            return a8.a(useIPv6);
        }
        throw new IllegalArgumentException("use InetSocketAddress");
    }

    public static final a8 a(boolean useIPv6) throws IOException {
        String methodName = "newInstance";
        String OS = System.getProperty("os.name");
        if (-1 != OS.indexOf("Windows") && useIPv6) {
            if (bz.a()) {
                bz.a(5, b, "newInstance", "Platform is Windows and is IPv6, using class SmAgentTcpIPv6WinTransport");
            }
            return new ba(new Socket());
        }
        if (bz.a()) {
            bz.a(5, b, "newInstance", "Using SmAgentTcpTransport class");
        }
        return new a8(Selector.open(), SocketChannel.open());
    }

    protected void finalize() throws Throwable {
        if (this.d != null) {
            try {
                this.d.cancel();
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        if (this.e != null) {
            try {
                this.e.close();
            }
            catch (Throwable t3) {
                // empty catch block
            }
        }
        if (this.c != null) {
            try {
                this.c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    protected a8(Selector selector, SocketChannel socketChannel) {
        block4: {
            this.a = 3000;
            String methodName = b;
            this.c = selector;
            this.e = socketChannel;
            String timeoutStr = System.getProperty("NONBLOCKING_CONNECTION_SLEEP_TIME");
            if (timeoutStr != null) {
                try {
                    this.a = Integer.parseInt(timeoutStr);
                    if (bz.a()) {
                        bz.a(5, b, b, "Modifying nonblocking connection sleep time to " + this.a);
                    }
                }
                catch (NumberFormatException e2) {
                    if (!bz.a()) break block4;
                    bz.a(2, b, b, e2.toString());
                }
            }
        }
    }

    public boolean a() {
        return this.e.isConnected();
    }

    public boolean b(SocketAddress sa) throws IOException, UnresolvedAddressException {
        block7: {
            String methodName = "connect";
            try {
                String keepAliveSetting = System.getenv("SM_ENABLE_TCP_KEEPALIVE");
                if (keepAliveSetting != null && 1 == Integer.parseInt(keepAliveSetting)) {
                    Socket sock = this.e.socket();
                    sock.setKeepAlive(true);
                    if (bz.a()) {
                        bz.a(5, b, "connect", "SM_ENABLE_TCP_KEEPALIVE is enabled, setting keep alive option");
                    }
                }
            }
            catch (SecurityException e2) {
                if (bz.a()) {
                    bz.a(2, b, "connect", "Unable to get SM_ENABLE_TCP_KEEPALIVE environment variable : " + e2);
                }
            }
            catch (NumberFormatException e3) {
                if (!bz.a()) break block7;
                bz.a(2, b, "connect", "Unable to parse SM_ENABLE_TCP_KEEPALIVE as integer : " + e3);
            }
        }
        if (this.e.connect(sa)) {
            this.e.configureBlocking(false);
            return true;
        }
        return false;
    }

    public int a(ByteBuffer buf) throws IOException {
        return this.a(buf, 0L);
    }

    public int a(ByteBuffer buf, long timeout) throws IOException {
        long dropDeadTime;
        String methodName = "write";
        if (bz.a()) {
            bz.a(5, b, "write", "tcp write: timeout " + timeout);
        }
        long l2 = dropDeadTime = timeout > 0L ? System.currentTimeMillis() + timeout : timeout;
        if (this.d == null) {
            this.d = this.e.register(this.c, 4);
        } else {
            this.d.interestOps(4);
        }
        if (bz.a()) {
            bz.a(5, b, "write", "tcp write: registered selector...valid status = " + this.d.isValid());
        }
        int writeLength = buf.remaining();
        int bytesWritten = 0;
        Throwable removeFailure = null;
        do {
            int numChans = 0;
            long now = System.currentTimeMillis();
            if (bz.a()) {
                bz.a(5, b, "write", "dropDeadTime = " + dropDeadTime + ", bytesWritten = " + bytesWritten + ", writeLength = " + writeLength);
            }
            if (dropDeadTime > 0L && now >= dropDeadTime) {
                bz.a(5, b, "write", "tcp write: timeout!");
                return bytesWritten > 0 ? bytesWritten : -2;
            }
            if (removeFailure != null) {
                if (bz.a()) {
                    bz.a(2, b, "write", "Failed to clean up selection set: " + removeFailure);
                    removeFailure.printStackTrace();
                }
                removeFailure = null;
            }
            bz.a(5, b, "write", "tcp write: trying to write...");
            try {
                if (bz.a()) {
                    SelectionKey testKey = this.e.keyFor(this.c);
                    if (testKey == null) {
                        bz.a(5, b, "write", "tcp write: NO KEY FOR CHANNEL!");
                    } else {
                        bz.a(5, b, "write", "tcp write: chan interest mask = " + testKey.interestOps());
                    }
                }
                if (dropDeadTime < 0L) {
                    numChans = this.c.selectNow();
                    if (bz.a()) {
                        bz.a(4, b, "write", "dropDeadTime < 0 selected total channels = " + numChans);
                    }
                } else if (dropDeadTime == 0L) {
                    numChans = this.c.select();
                    if (bz.a()) {
                        bz.a(4, b, "write", "0 dropDeadTime selected total channels = " + numChans);
                    }
                } else {
                    long maxTO = dropDeadTime - now;
                    numChans = this.c.select(maxTO);
                    if (bz.a()) {
                        bz.a(4, b, "write", "Selected channels with maxTO = " + maxTO + " is " + numChans);
                    }
                }
            }
            catch (IOException e2) {
                if (bz.a()) {
                    bz.a(2, b, "write", "IOException trying to select a channel: " + e2);
                }
                throw e2;
            }
            if (numChans == 0) {
                if (bz.a()) {
                    bz.a(4, b, "write", "numChans = 0, bytes written = " + bytesWritten);
                }
                return bytesWritten > 0 ? bytesWritten : -2;
            }
            Iterator<SelectionKey> it = this.c.selectedKeys().iterator();
            SelectionKey curKey = it.next();
            try {
                it.remove();
            }
            catch (RuntimeException e3) {
                removeFailure = e3;
            }
            try {
                if (!curKey.isValid() || !curKey.isWritable()) continue;
                SocketChannel chan = (SocketChannel)curKey.channel();
                if (bz.a()) {
                    bz.a(5, b, "write", "tcp write: buf limit " + buf.limit() + ", capacity " + buf.capacity() + ", remaining " + buf.remaining());
                }
                int curBytesWritten = chan.write(buf);
                if (bz.a()) {
                    bz.a(5, b, "write", "Current bytes written to the channel = " + curBytesWritten);
                }
                if (curBytesWritten < 0) {
                    if (bz.a()) {
                        bz.a(4, b, "write", "Current channel bytes written < 0, " + (curBytesWritten == -1 ? "EOF from server" : "Unknown error."));
                    }
                    throw new IOException("EOF from server");
                }
                bytesWritten += curBytesWritten;
            }
            catch (IOException e4) {
                if (bz.a()) {
                    bz.a(2, b, "write", "IOException writing to the channel: " + e4);
                }
                throw e4;
            }
        } while (dropDeadTime >= 0L && bytesWritten < writeLength);
        if (bz.a()) {
            bz.a(5, b, "write", "Completed execution bytes written = " + bytesWritten);
        }
        return bytesWritten;
    }

    public int a(ByteBuffer buf, int len) throws IOException {
        return this.a(buf, len, 0L);
    }

    public int a(ByteBuffer buffer, int readLength, long timeout) throws IOException {
        String methodName = "read";
        if (buffer.capacity() < readLength) {
            throw new BufferOverflowException();
        }
        long dropDeadTime = timeout > 0L ? System.currentTimeMillis() + timeout : timeout;
        buffer.clear();
        buffer.limit(readLength);
        if (bz.a()) {
            bz.a(5, b, "read", "Reading " + readLength + " bytes with timeout of " + timeout + "ms");
        }
        if (this.d == null) {
            this.d = this.e.register(this.c, 1);
        } else {
            this.d.interestOps(1);
        }
        if (bz.a()) {
            bz.a(5, b, "read", "tcp read: registered selector...valid status = " + this.d.isValid());
        }
        int bytesRead = 0;
        Throwable removeFailure = null;
        do {
            int numChans = 0;
            long now = System.currentTimeMillis();
            if (bz.a()) {
                bz.a(5, b, "read", "dropDeadTime = " + dropDeadTime + ", bytesRead = " + bytesRead + ", readLength = " + readLength);
            }
            if (dropDeadTime > 0L && now >= dropDeadTime) {
                if (bz.a()) {
                    bz.a(4, b, "read", "now >= dropDeadTime > 0, bytesRead = " + bytesRead);
                }
                return bytesRead > 0 ? bytesRead : -2;
            }
            if (removeFailure != null) {
                if (bz.a()) {
                    bz.a(2, b, "read", "Failed to clean up selection set: " + removeFailure);
                    removeFailure.printStackTrace();
                }
                removeFailure = null;
            }
            try {
                if (bz.a()) {
                    SelectionKey testKey = this.e.keyFor(this.c);
                    if (testKey == null) {
                        bz.a(5, b, "read", "tcp read: NO KEY FOR CHANNEL!");
                    } else {
                        bz.a(5, b, "read", "tcp read: chan interest mask = " + testKey.interestOps());
                    }
                }
                if (dropDeadTime < 0L) {
                    numChans = this.c.selectNow();
                    if (bz.a()) {
                        bz.a(4, b, "read", "dropDeadTime < 0 selected total channels = " + numChans);
                    }
                } else if (dropDeadTime == 0L) {
                    numChans = this.c.select();
                    if (bz.a()) {
                        bz.a(4, b, "read", "0 dropDeadTime selected total channels = " + numChans);
                    }
                } else {
                    long maxTO = dropDeadTime - now;
                    numChans = this.c.select(maxTO);
                    if (bz.a()) {
                        bz.a(4, b, "read", "Selected channels with maxTO = " + maxTO + " is " + numChans);
                    }
                }
            }
            catch (IOException e2) {
                if (bz.a()) {
                    bz.a(2, b, "read", "IOException trying to select a channel: " + e2);
                }
                throw e2;
            }
            if (numChans == 0) {
                if (bz.a()) {
                    bz.a(4, b, "read", "numChans = 0, bytes read = " + bytesRead);
                }
                return bytesRead > 0 ? bytesRead : -2;
            }
            Iterator<SelectionKey> it = this.c.selectedKeys().iterator();
            SelectionKey curKey = it.next();
            try {
                it.remove();
            }
            catch (RuntimeException e3) {
                removeFailure = e3;
            }
            try {
                if (!curKey.isValid() || !curKey.isReadable()) continue;
                SocketChannel chan = (SocketChannel)curKey.channel();
                int curReadBytes = chan.read(buffer);
                if (bz.a()) {
                    bz.a(5, b, "read", "Current bytes read from the channel = " + curReadBytes);
                }
                if (curReadBytes < 0) {
                    if (bz.a()) {
                        bz.a(4, b, "read", "Current channel bytes read < 0, " + (curReadBytes == -1 ? "EOF from server" : "Unknown error."));
                    }
                    throw new IOException("EOF from server");
                }
                bytesRead += curReadBytes;
            }
            catch (IOException e4) {
                if (bz.a()) {
                    bz.a(2, b, "read", "IOException reading the channel: " + e4);
                }
                throw e4;
            }
        } while (dropDeadTime >= 0L && bytesRead < readLength);
        if (bytesRead > 0) {
            buffer.flip();
        }
        if (bz.a()) {
            bz.a(5, b, "read", "Completed execution: bytes read = " + bytesRead + ", returning " + (bytesRead > 0 ? bytesRead : -2));
        }
        return bytesRead > 0 ? bytesRead : -2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void b() throws IOException {
        if (this.d != null) {
            try {
                this.d.cancel();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.e == null) return;
        if (this.e.socket() != null) {
            try {
                this.e.socket().setSoLinger(true, 0);
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        try {
            this.e.close();
            Object var3_5 = null;
            if (this.c == null) return;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (this.c == null) throw throwable;
            this.c.close();
            throw throwable;
        }
        this.c.close();
    }

    public void c() {
        try {
            this.e.socket().setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

