/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi;

import com.ca.siteminder.sdk.agentapi.LegacyAgentApi;
import com.ca.siteminder.sdk.agentapi.SmAgentApi;
import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiImpl;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiResult;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuditResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuthenticationResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuthorizationResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmRealmDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceProtectionResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmServiceSession;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmSessionDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserAgentDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserCredentials;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmVerifyCredsResult;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementResult;
import com.ca.siteminder.sdk.agentapi.management.SmAgentInstanceDef;
import com.ca.siteminder.sdk.agentapi.management.SmManagementContextDef;
import com.ca.siteminder.sdk.agentapi.management.SmTokenDescriptor;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesResult;
import com.ca.siteminder.sdk.agentapi.services.SmTunnelServiceRequest;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagementResult;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import netegrity.siteminder.javaagent.AgentInstanceDef;
import netegrity.siteminder.javaagent.Attribute;
import netegrity.siteminder.javaagent.AttributeList;
import netegrity.siteminder.javaagent.AuthReasonDef;
import netegrity.siteminder.javaagent.BinaryBuffer;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ManagementContextDef;
import netegrity.siteminder.javaagent.RealmDef;
import netegrity.siteminder.javaagent.ResourceContextDef;
import netegrity.siteminder.javaagent.ServerDef;
import netegrity.siteminder.javaagent.ServiceSession;
import netegrity.siteminder.javaagent.SessionDef;
import netegrity.siteminder.javaagent.TokenDescriptor;
import netegrity.siteminder.javaagent.TunnelServiceRequest;
import netegrity.siteminder.javaagent.UserCredentials;

public class LegacyAgentApiAdapter
implements LegacyAgentApi,
SmAgentApiConstants {
    private SmAgentApi m_smAgentApiHandle = null;
    private static final String CLASS_NAME = "LegacyAgentApiAdapter";

    public static SmInitDef create(InitDef initDef) throws SmAgentApiNotInitializedException, SmAgentApiConnectionException {
        SmInitDef smInitDef = null;
        try {
            smInitDef = LegacyAgentApiAdapter.create(initDef, null);
        }
        catch (SmConfigException smConfigException) {
            // empty catch block
        }
        return smInitDef;
    }

    public static SmInitDef create(InitDef initDef, String configFileName) throws SmAgentApiNotInitializedException, SmAgentApiConnectionException, SmConfigException {
        String methodName = "create";
        if (initDef == null) {
            return null;
        }
        SmConfigFile configFile = null;
        String hostName = initDef.getHostName();
        String sharedSecret = initDef.getSharedSecret();
        boolean failover = initDef.isFailOver();
        int failoverThreshold = initDef.failOverThreshold();
        if (failoverThreshold < 0) {
            failoverThreshold = failover ? 1 : 0;
        }
        ArrayList clusters = new ArrayList();
        Vector servers = initDef.getServers();
        int connectionMax = 0;
        int connectionMin = 0;
        int connectionStep = 0;
        int timeout = 0;
        if (configFileName != null) {
            try {
                configFile = SmConfigFile.getInstance(configFileName);
            }
            catch (SmConfigException e2) {
                Util.display(3, CLASS_NAME, "create", "Unable to retrieve host configuration file... shared secret rollover will not work");
                throw e2;
            }
        }
        if (servers != null) {
            int i2;
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "create", "InitDef: hostname = " + hostName + ", totalServers = " + servers.size() + ", sharedSecret = " + sharedSecret);
            }
            for (i2 = 0; i2 < servers.size(); ++i2) {
                if (servers.get(i2) == null) continue;
                clusters.add(new ArrayList());
            }
            for (i2 = 0; i2 < servers.size(); ++i2) {
                ServerDef server = (ServerDef)servers.get(i2);
                if (server == null) {
                    Util.display(3, CLASS_NAME, "create", "Null ServerDef in InitDef, ignoring");
                    continue;
                }
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "create", "Processing server " + server.serverIpAddress + ", clusterSeq = " + server.clusterSeq + ", acct port " + server.accountingPort + ", auth port = " + server.authenticationPort + ", az port = " + server.authorizationPort);
                }
                int clusterIndex = server.clusterSeq > 0 ? server.clusterSeq - 1 : 0;
                ArrayList<String> clusterDef = null;
                if (clusterIndex < clusters.size()) {
                    clusterDef = (ArrayList<String>)clusters.get(clusterIndex);
                } else {
                    Util.display(2, CLASS_NAME, "create", "Error attempting to get cluster at clusterIndex=" + clusterIndex + ", clusters.size=" + clusters.size() + ". Add new cluster to the end of array");
                    clusterDef = new ArrayList<String>();
                    clusters.add(clusterDef);
                }
                int port = LegacyAgentApiAdapter.selectPort(server);
                clusterDef.add(Util.cleanIPv6Address(server.serverIpAddress) + ":" + port);
                if (connectionMax < server.connectionMax) {
                    connectionMax = server.connectionMax;
                }
                if (connectionMin < server.connectionMin) {
                    connectionMin = server.connectionMin;
                }
                if (connectionStep < server.connectionStep) {
                    connectionStep = server.connectionStep;
                }
                if (timeout >= server.timeout) continue;
                timeout = server.timeout;
            }
        } else {
            Util.display(4, CLASS_NAME, "create", "InitDef no servers found, proceeding");
        }
        SmInitDef smInitDef = new SmInitDef(configFile, clusters, hostName, sharedSecret, connectionMax, connectionMin, connectionStep, (long)timeout, failover, failoverThreshold, null);
        smInitDef.setCryptoOpMode(initDef.getCryptoOpMode());
        return smInitDef;
    }

    private static int selectPort(ServerDef server) {
        if (server.accountingPort > 0) {
            return server.accountingPort;
        }
        if (server.authenticationPort > 0) {
            return server.authenticationPort;
        }
        if (server.authorizationPort > 0) {
            return server.authorizationPort;
        }
        return 44442;
    }

    public int init(InitDef initDef) {
        return this.init(initDef, null);
    }

    public int init(InitDef initDef, String configFileName) {
        String methodName = "init";
        if (initDef == null) {
            return -1;
        }
        int status = -1;
        try {
            SmInitDef smInitDef = LegacyAgentApiAdapter.create(initDef, configFileName);
            if (smInitDef.getClusters() == null || smInitDef.getClusters().size() == 0) {
                Util.display(2, CLASS_NAME, "init", "Can't initialized with null or empty clusters list");
                return -1;
            }
            this.m_smAgentApiHandle = new SmAgentApiImpl();
            this.m_smAgentApiHandle.init(smInitDef);
            status = 0;
        }
        catch (SmAgentApiConnectionException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Failed to connect server: " + e2);
            }
            return 0;
        }
        catch (SmCryptoProviderException e3) {
            return -1;
        }
        catch (SmConfigException e4) {
            return -1;
        }
        catch (Exception e5) {
            e5.printStackTrace(System.out);
            return -1;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unInit() {
        if (this.m_smAgentApiHandle == null) {
            return -3;
        }
        try {
            this.m_smAgentApiHandle.close();
        }
        catch (SmAgentApiException e2) {
            int n2 = -1;
            return n2;
        }
        finally {
            this.m_smAgentApiHandle = null;
        }
        return 0;
    }

    public int isProtected(String clientIpAddress, ResourceContextDef rcd, RealmDef rd) {
        return this.isProtectedEx(clientIpAddress, rcd, rd, null);
    }

    public int isProtectedEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, String transactionId) {
        block9: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (clientIpAddress == null) {
                return -1;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmResourceProtectionResult result = this.m_smAgentApiHandle.isProtected(transactionId, agentDef, resourceDef);
                if (result != null) {
                    SmRealmDef realmDef = result.getRealmDef();
                    if (realmDef == null) {
                        return -1;
                    }
                    if (!result.isSuccess()) {
                        return 2;
                    }
                    rd.oid = realmDef.getOid();
                    rd.name = realmDef.getName();
                    rd.domOid = realmDef.getDomainOid();
                    rd.credentials = realmDef.getCredentials();
                    rd.formLocation = realmDef.getFormLocation();
                    return 1;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block9;
                Util.display(2, CLASS_NAME, "isProtectedEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int isProtectedDLP(String clientIpAddress, ResourceContextDef rcd, RealmDef rd) {
        return this.isProtectedDLPEx(clientIpAddress, rcd, rd, null);
    }

    public int isProtectedDLPEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, String transactionId) {
        block9: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (clientIpAddress == null) {
                return -1;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmResourceProtectionResult result = this.m_smAgentApiHandle.isProtectedDLP(transactionId, agentDef, resourceDef);
                if (result != null) {
                    SmRealmDef realmDef = result.getRealmDef();
                    if (realmDef == null) {
                        return -1;
                    }
                    if (!result.isSuccess()) {
                        return 2;
                    }
                    rd.oid = realmDef.getOid();
                    rd.name = realmDef.getName();
                    rd.domOid = realmDef.getDomainOid();
                    rd.credentials = realmDef.getCredentials();
                    rd.formLocation = realmDef.getFormLocation();
                    return 1;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block9;
                Util.display(2, CLASS_NAME, "isProtectedDLPEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int login(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al2) {
        return this.loginEx(clientIpAddress, rcd, rd, uc, sd, al2, null);
    }

    public int login(String clientIpAddress, String domain, String scheme, String agent, UserCredentials uc, SessionDef sd, AttributeList al2) {
        ResourceContextDef rcd = agent == null ? null : new ResourceContextDef(agent, null, null, null);
        return this.login(clientIpAddress, rcd, null, domain, scheme, uc, sd, al2, null);
    }

    public int loginEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al2, String transactionId) {
        return this.login(clientIpAddress, rcd, rd, null, null, uc, sd, al2, null);
    }

    protected int login(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, String domain, String scheme, UserCredentials uc, SessionDef sd, AttributeList al2, String transactionId) {
        block11: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (uc == null) {
                return -52;
            }
            if (sd == null) {
                return -53;
            }
            if (al2 == null) {
                return -55;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                SmUserCredentials credentials = new SmUserCredentials(uc.name, uc.password, uc.certUserDN, uc.certIssuerDN, uc.certBinary);
                SmAuthenticationResult result = null;
                result = sd.spec != null && sd.spec.length() > 0 ? this.m_smAgentApiHandle.validate(transactionId, agentDef, resourceDef, realmDef, sessionDef) : this.m_smAgentApiHandle.loginEx(transactionId, agentDef, resourceDef, realmDef, credentials, sessionDef, uc.reason);
                if (result != null) {
                    this.fillLegacySessionDef(result.getSessionDef(), sd, result.getReason());
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    if (result.isCallNotCompleted()) {
                        return 3;
                    }
                    if (!result.isSuccess()) {
                        return 2;
                    }
                    return 1;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block11;
                Util.display(2, CLASS_NAME, "loginEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int validate(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al2) {
        return this.validateEx(clientIpAddress, rcd, rd, uc, sd, al2, null);
    }

    public int validateEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al2, String transactionId) {
        block8: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = rcd == null ? null : new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = rd == null ? null : new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                SmAuthenticationResult result = this.m_smAgentApiHandle.validate(transactionId, agentDef, resourceDef, realmDef, sessionDef);
                if (result != null) {
                    this.fillLegacySessionDef(result.getSessionDef(), sd, result.getReason());
                    if (al2 != null) {
                        this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    }
                    if (result.isCallNotCompleted()) {
                        return 3;
                    }
                    if (!result.isSuccess()) {
                        return 2;
                    }
                    return 1;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block8;
                Util.display(2, CLASS_NAME, "validateEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int validateServiceToken(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al2) {
        return this.validateServiceTokenEx(clientIpAddress, rcd, rd, uc, sd, al2, null);
    }

    public int validateServiceTokenEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al2, String transactionId) {
        block8: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = rcd == null ? null : new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = rd == null ? null : new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                SmAuthenticationResult result = this.m_smAgentApiHandle.validateServiceToken(transactionId, agentDef, resourceDef, realmDef, sessionDef);
                if (result != null) {
                    this.fillLegacySessionDef(result.getSessionDef(), sd, result.getReason());
                    if (al2 != null) {
                        this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    }
                    if (result.isCallNotCompleted()) {
                        return 3;
                    }
                    if (!result.isSuccess()) {
                        return 2;
                    }
                    return 1;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block8;
                Util.display(2, CLASS_NAME, "validateServiceTokenEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int authorize(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al2) {
        return this.authorizeEx(clientIpAddress, transactionId, rcd, rd, sd, al2, null, null, null);
    }

    public int authorizeEx(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al2, StringBuffer unresolvedList, StringBuffer resolvedList, Boolean isSimpleAuth) {
        block16: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (al2 == null) {
                return -55;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                if (sd instanceof ServiceSession) {
                    sessionDef.setAllEndUserAttributes(((ServiceSession)sd).getAllEndUserAttributes());
                }
                SmAuthorizationResult result = null;
                if (unresolvedList == null && resolvedList == null) {
                    result = this.m_smAgentApiHandle.authorize(transactionId, agentDef, resourceDef, realmDef, sessionDef, sd.reason);
                } else if (unresolvedList != null && resolvedList != null) {
                    result = this.m_smAgentApiHandle.authorize(transactionId, agentDef, resourceDef, realmDef, sessionDef, sd.reason, unresolvedList.toString(), resolvedList.toString());
                    unresolvedList.delete(0, unresolvedList.length());
                    resolvedList.delete(0, resolvedList.length());
                } else {
                    return -1;
                }
                if (result != null) {
                    if (result.isCallNotCompleted()) {
                        if (unresolvedList != null && resolvedList != null) {
                            unresolvedList.append(result.getUnresolvedVariables());
                            resolvedList.append(result.getResolvedVariables());
                        }
                        return 4;
                    }
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block16;
                Util.display(2, CLASS_NAME, "authorizeEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int authorizeDLP(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al2) {
        return this.authorizeDLPEx(clientIpAddress, transactionId, rcd, rd, sd, al2, null, null, null);
    }

    public int authorizeDLPEx(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al2, StringBuffer unresolvedList, StringBuffer resolvedList, Boolean isSimpleAuth) {
        block16: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (al2 == null) {
                return -55;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                if (sd instanceof ServiceSession) {
                    sessionDef.setAllEndUserAttributes(((ServiceSession)sd).getAllEndUserAttributes());
                }
                SmAuthorizationResult result = null;
                if (unresolvedList == null && resolvedList == null) {
                    result = this.m_smAgentApiHandle.authorizeDLP(transactionId, agentDef, resourceDef, realmDef, sessionDef, sd.reason);
                } else if (unresolvedList != null && resolvedList != null) {
                    result = this.m_smAgentApiHandle.authorizeDLP(transactionId, agentDef, resourceDef, realmDef, sessionDef, sd.reason, unresolvedList.toString(), resolvedList.toString());
                    unresolvedList.delete(0, unresolvedList.length());
                    resolvedList.delete(0, resolvedList.length());
                } else {
                    return -1;
                }
                if (result != null) {
                    if (result.isCallNotCompleted()) {
                        if (unresolvedList != null && resolvedList != null) {
                            unresolvedList.append(result.getUnresolvedVariables());
                            resolvedList.append(result.getResolvedVariables());
                        }
                        return 4;
                    }
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block16;
                Util.display(2, CLASS_NAME, "authorizeDLPEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int logout(String clientIpAddress, SessionDef sd) {
        return this.logoutEx(clientIpAddress, sd, null);
    }

    public int logoutEx(String clientIpAddress, SessionDef sd, String transactionId) {
        block5: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                SmAgentApiResult result = this.m_smAgentApiHandle.logout(transactionId, agentDef, sessionDef, sd.reason);
                if (result != null) {
                    return result.isSuccess() ? 1 : 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block5;
                Util.display(2, CLASS_NAME, "logoutEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int audit(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd) {
        block8: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                SmAuditResult result = this.m_smAgentApiHandle.audit(transactionId, agentDef, resourceDef, realmDef, sessionDef);
                if (result != null) {
                    this.fillLegacySessionDef(result.getSessionDef(), sd, result.getReason());
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block8;
                Util.display(2, CLASS_NAME, "audit", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int doManagement(ManagementContextDef mc, AttributeList al2) {
        block7: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (mc == null) {
                return -56;
            }
            if (al2 == null) {
                return -55;
            }
            try {
                SmManagementContextDef mgmtContext = new SmManagementContextDef(mc.command, mc.data);
                SmAgentApiManagementResult result = this.m_smAgentApiHandle.doManagement(mgmtContext);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block7;
                Util.display(2, CLASS_NAME, "doManagement", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int setAgentInstanceInfo(AgentInstanceDef aid) {
        block5: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (aid == null) {
                return -58;
            }
            try {
                SmAgentInstanceDef smAgentInstanceDef = new SmAgentInstanceDef(aid.getAgentProductType(), aid.getAgentProductVersion(), aid.getAgentProductSubtype(), aid.getAgentProductOStype(), aid.getAgentIdFile(), aid.getACOName(), aid.getHCOName(), aid.getFIPSMode());
                SmAgentApiManagementResult result = this.m_smAgentApiHandle.setAgentInstanceInfo(smAgentInstanceDef);
                if (result != null) {
                    return result.isSuccess() ? 1 : 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block5;
                Util.display(2, CLASS_NAME, "setAgentInstanceInfo", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int updateAttributes(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList requestAttrs, AttributeList responseAttrs) {
        block12: {
            String methodName = "updateAttributes";
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (sd == null) {
                return -53;
            }
            if (requestAttrs == null) {
                return -55;
            }
            if (responseAttrs == null) {
                return -55;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                ArrayList<SmAttribute> attributes = new ArrayList<SmAttribute>();
                for (int k2 = 0; k2 < requestAttrs.getAttributeCount(); ++k2) {
                    Attribute next = requestAttrs.getAttributeAt(k2);
                    if (next == null) continue;
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "updateAttributes", "Processing attribute for update id = " + next.id);
                    }
                    attributes.add(new SmAttribute(next.id, next.ttl, next.flags, next.oid, next.value));
                }
                SmAgentApiManagementResult result = this.m_smAgentApiHandle.updateAttributes(transactionId, agentDef, resourceDef, realmDef, sessionDef, attributes);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), responseAttrs);
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block12;
                Util.display(2, CLASS_NAME, "updateAttributes", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int getAgentConfig(String templateName, AttributeList attributeList) {
        block7: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (templateName == null) {
                return -1;
            }
            if (attributeList == null) {
                return -1;
            }
            try {
                SmAgentApiManagementResult result = this.m_smAgentApiHandle.getAgentConfig(templateName);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), attributeList);
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block7;
                Util.display(2, CLASS_NAME, "getAgentConfig", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int createSSOToken(SessionDef sd, AttributeList al2, StringBuffer SSOToken) {
        block8: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sd == null) {
                return -53;
            }
            if (SSOToken == null) {
                return -1;
            }
            if (al2 == null) {
                return -55;
            }
            try {
                SmServiceSession sessionDef = new SmServiceSession(sd.idleTimeout, sd.maxTimeout, sd.currentServerTime, sd.sessionStartTime, sd.sessionLastTime, sd.id, sd.spec);
                ArrayList<SmAttribute> attributes = new ArrayList<SmAttribute>();
                for (int k2 = 0; k2 < al2.getAttributeCount(); ++k2) {
                    Attribute next = al2.getAttributeAt(k2);
                    if (next == null) continue;
                    attributes.add(new SmAttribute(next.id, next.ttl, next.flags, next.oid, next.value));
                }
                String token = this.m_smAgentApiHandle.createSSOToken(sessionDef, attributes);
                if (token != null) {
                    SSOToken.append(token);
                    return 0;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block8;
                Util.display(2, CLASS_NAME, "createSSOToken", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int decodeSSOToken(String SSOToken, TokenDescriptor td, AttributeList al2, boolean updateToken, StringBuffer updatedSSOToken) {
        block10: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (SSOToken == null) {
                return -1;
            }
            if (al2 == null) {
                return -55;
            }
            try {
                SmTokenDescriptor descriptor = this.m_smAgentApiHandle.decodeSSOToken(SSOToken, updateToken);
                if (descriptor != null) {
                    List attributes = descriptor.getAttributes();
                    if (attributes != null) {
                        for (SmAttribute attr : attributes) {
                            if (attr == null) continue;
                            al2.addAttribute(attr.getId(), attr.getTtl(), attr.getFlags(), attr.getOid(), attr.getValue());
                        }
                    }
                    if (td != null) {
                        td.ver = descriptor.getVersion();
                        td.bThirdParty = descriptor.isThirdParty();
                    }
                    if (updatedSSOToken != null && descriptor.getUpdatedToken() != null) {
                        updatedSSOToken.append(descriptor.getUpdatedToken());
                    }
                    return 0;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block10;
                Util.display(2, CLASS_NAME, "decodeSSOToken", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int tunnel(short server, String clientIpAddress, String transactionId, ResourceContextDef rcd, TunnelServiceRequest tsr, AttributeList responseAttrs) {
        block7: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (tsr == null) {
                return -54;
            }
            if (responseAttrs == null) {
                return -55;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = rcd == null ? null : new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmTunnelServiceRequest requestDef = new SmTunnelServiceRequest(tsr.library, tsr.function, tsr.parameter, tsr.data);
                SmAgentApiServicesResult result = this.m_smAgentApiHandle.tunnel(transactionId, agentDef, resourceDef, requestDef);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), responseAttrs);
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block7;
                Util.display(2, CLASS_NAME, "tunnel", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int getMaxTunnelBufSize() {
        try {
            return this.m_smAgentApiHandle.getTunnelBufferSize();
        }
        catch (Exception e2) {
            return -1;
        }
    }

    public int transact(int serverNumber, BinaryBuffer bb2) {
        return -100;
    }

    public int getMaxTransactBufSize() {
        return SmAgentTliBuffer.getDefaultBufferSize() + 512;
    }

    public int getSessionVariables(String sessionId, ResourceContextDef rcd, AttributeList requestAttrs, AttributeList responseAttrs) {
        return this.getSessionVariablesEx(sessionId, rcd, requestAttrs, responseAttrs, null);
    }

    public int getSessionVariablesEx(String sessionId, ResourceContextDef rcd, AttributeList requestAttrs, AttributeList responseAttrs, String transactionId) {
        block10: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sessionId == null) {
                return -57;
            }
            if (requestAttrs == null) {
                return -55;
            }
            if (responseAttrs == null) {
                return -55;
            }
            try {
                SmResourceContextDef resourceDef = rcd == null ? null : new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                Vector<SmAttribute> variables = new Vector<SmAttribute>();
                for (int k2 = 0; k2 < requestAttrs.getAttributeCount(); ++k2) {
                    Attribute next = requestAttrs.getAttributeAt(k2);
                    if (next == null) continue;
                    variables.add(new SmAttribute(next.id, next.ttl, next.flags, next.oid, next.value));
                }
                SmAgentApiSessionManagementResult result = this.m_smAgentApiHandle.getSessionVariables(transactionId, sessionId, resourceDef, variables);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), responseAttrs);
                    if (result.isUnresolved()) {
                        return 4;
                    }
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block10;
                Util.display(2, CLASS_NAME, "getSessionVariablesEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int setSessionVariables(String sessionId, ResourceContextDef rcd, AttributeList requestAttrs, AttributeList responseAttrs) {
        return this.setSessionVariablesEx(sessionId, rcd, requestAttrs, responseAttrs, null);
    }

    public int setSessionVariablesEx(String sessionId, ResourceContextDef rcd, AttributeList requestAttrs, AttributeList responseAttrs, String transactionId) {
        block10: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sessionId == null) {
                return -57;
            }
            if (requestAttrs == null) {
                return -55;
            }
            if (responseAttrs == null) {
                return -55;
            }
            try {
                SmResourceContextDef resourceDef = rcd == null ? null : new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                Vector<SmAttribute> variables = new Vector<SmAttribute>();
                for (int k2 = 0; k2 < requestAttrs.getAttributeCount(); ++k2) {
                    Attribute next = requestAttrs.getAttributeAt(k2);
                    if (next == null) continue;
                    variables.add(new SmAttribute(next.id, next.ttl, next.flags, next.oid, next.value));
                }
                SmAgentApiSessionManagementResult result = this.m_smAgentApiHandle.setSessionVariables(transactionId, sessionId, resourceDef, variables);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), responseAttrs);
                    if (result.isUnresolved()) {
                        return 4;
                    }
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block10;
                Util.display(2, CLASS_NAME, "setSessionVariablesEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int delSessionVariables(String sessionId, ResourceContextDef rcd, AttributeList requestAttrs, AttributeList responseAttrs) {
        return this.delSessionVariablesEx(sessionId, rcd, requestAttrs, responseAttrs, null);
    }

    public int delSessionVariablesEx(String sessionId, ResourceContextDef rcd, AttributeList requestAttrs, AttributeList responseAttrs, String transactionId) {
        block10: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (sessionId == null) {
                return -57;
            }
            if (requestAttrs == null) {
                return -55;
            }
            if (responseAttrs == null) {
                return -55;
            }
            try {
                SmResourceContextDef resourceDef = rcd == null ? null : new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                Vector<SmAttribute> variables = new Vector<SmAttribute>();
                for (int k2 = 0; k2 < requestAttrs.getAttributeCount(); ++k2) {
                    Attribute next = requestAttrs.getAttributeAt(k2);
                    if (next == null) continue;
                    variables.add(new SmAttribute(next.id, next.ttl, next.flags, next.oid, next.value));
                }
                SmAgentApiSessionManagementResult result = this.m_smAgentApiHandle.delSessionVariables(transactionId, sessionId, resourceDef, variables);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), responseAttrs);
                    if (result.isUnresolved()) {
                        return 4;
                    }
                    if (result.isSuccess()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block10;
                Util.display(2, CLASS_NAME, "delSessionVariablesEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public int makeCertificateHash(BinaryBuffer cert, BinaryBuffer hash) {
        if (cert == null || hash == null) {
            return -1;
        }
        try {
            hash.buff = SmCryptoProvider.digest(cert.buff, "SHA-1");
            return 0;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return -1;
        }
    }

    public int verifyCredentials(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, AttributeList al2, AuthReasonDef authReason) {
        return this.verifyCredentialsEx(clientIpAddress, rcd, rd, uc, al2, null, authReason);
    }

    protected int verifyCredentialsEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, AttributeList al2, String transactionId, AuthReasonDef authReason) {
        block11: {
            if (this.m_smAgentApiHandle == null) {
                return -3;
            }
            if (rcd == null) {
                return -50;
            }
            if (rd == null) {
                return -51;
            }
            if (uc == null) {
                return -52;
            }
            if (al2 == null) {
                return -55;
            }
            if (authReason == null) {
                return -59;
            }
            try {
                SmUserAgentDef agentDef = new SmUserAgentDef(clientIpAddress);
                SmResourceContextDef resourceDef = new SmResourceContextDef(rcd.agent, rcd.server, rcd.resource, rcd.action);
                SmRealmDef realmDef = new SmRealmDef(rd.name, rd.oid, rd.domOid, rd.credentials, rd.formLocation);
                SmUserCredentials credentials = new SmUserCredentials(uc.name, uc.password, uc.certUserDN, uc.certIssuerDN, uc.certBinary);
                SmVerifyCredsResult result = null;
                result = this.m_smAgentApiHandle.verifyCredentials(transactionId, agentDef, resourceDef, realmDef, credentials, uc.reason);
                if (result != null) {
                    this.fillLegacyAttributesFromResponse(result.getAttributeList(), al2);
                    authReason.reason = result.getReason();
                    if (result.isCallNotCompleted()) {
                        return 3;
                    }
                    if (!result.isSuccess()) {
                        return 2;
                    }
                    return 1;
                }
            }
            catch (SmAgentApiException e2) {
                if (!Util.isLogEnabled()) break block11;
                Util.display(2, CLASS_NAME, "verifyCredentialsEx", "Failed: Reason: " + e2.getErrorCode());
                e2.printStackTrace();
            }
        }
        return -1;
    }

    private void fillLegacyAttributesFromResponse(List responseAttributes, AttributeList legacyAttributes) {
        String methodName = "fillLegacyAttributesFromResponse";
        if (legacyAttributes == null) {
            Util.display(3, CLASS_NAME, "fillLegacyAttributesFromResponse", "Null legacy attribute list passed in, ignoring setting legacy attributes");
            return;
        }
        legacyAttributes.removeAllAttributes();
        if (responseAttributes == null || responseAttributes.size() == 0) {
            Util.display(4, CLASS_NAME, "fillLegacyAttributesFromResponse", "No response attributes received, ignoring setting legacy attributes");
            return;
        }
        for (SmAttribute attr : responseAttributes) {
            if (attr != null) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "fillLegacyAttributesFromResponse", "Filling legacy attribute list with id = " + attr.getId());
                }
                legacyAttributes.addAttribute(attr.getId(), attr.getTtl(), attr.getFlags(), attr.getOid(), attr.getValue());
                continue;
            }
            Util.display(3, CLASS_NAME, "fillLegacyAttributesFromResponse", "Found null response attribute in response attribute list");
        }
    }

    private void fillLegacySessionDef(SmSessionDef responseSessionDef, SessionDef legacySessionDef, int reason) {
        if (responseSessionDef != null) {
            legacySessionDef.idleTimeout = responseSessionDef.getIdleTimeout();
            legacySessionDef.maxTimeout = responseSessionDef.getMaxTimeout();
            legacySessionDef.currentServerTime = responseSessionDef.getCurrentServerTime();
            legacySessionDef.sessionStartTime = responseSessionDef.getSessionStartTime();
            legacySessionDef.sessionLastTime = responseSessionDef.getSessionLastTime();
            legacySessionDef.id = responseSessionDef.getId();
            legacySessionDef.spec = responseSessionDef.getSpec();
            legacySessionDef.reason = reason;
            if (legacySessionDef instanceof ServiceSession && responseSessionDef instanceof SmServiceSession) {
                ((ServiceSession)legacySessionDef).setAllEndUserAttributes(((SmServiceSession)responseSessionDef).getAllEndUserAttributes());
            }
        }
    }
}

