/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.KeyGenerator;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.PasswordKey;
import com.rsa.crypto.SecretKey;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.key.j;
import com.rsa.crypto.ncm.key.l;
import com.rsa.crypto.ncm.key.m;
import com.rsa.crypto.ncm.key.r;
import com.rsa.cryptoj.c.bj;
import com.rsa.cryptoj.c.ca;
import com.rsa.cryptoj.c.ce;
import com.rsa.cryptoj.c.cf;
import com.rsa.cryptoj.c.cj;
import com.rsa.cryptoj.c.cl;
import com.rsa.cryptoj.c.dc;
import com.rsa.cryptoj.c.di;
import com.rsa.cryptoj.c.dk;
import com.rsa.cryptoj.c.dn;
import com.rsa.cryptoj.c.eg;
import com.rsa.cryptoj.c.ex;
import com.rsa.cryptoj.c.fe;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_KeyAttributes;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.a;
import java.util.Arrays;
import java.util.List;

public abstract class JSAFE_SecretKey
extends JSAFE_Object
implements JSAFE_Key {
    private static final long serialVersionUID = 5431287991481089904L;
    public static final int ENCRYPT_KEY = 0;
    public static final int MAC_KEY = 1;
    private static final String l = "Clear";
    protected static final String a = "Invalid key length.";
    private static final String m = "Invalid key data.";
    private static final String n = "Invalid key format.";
    private static final String o = "Key object not set with password.";
    protected static final String b = "Key object not set with a salt.";
    protected CryptoModule c;
    protected SecretKey d;
    protected PasswordKey h;
    protected int i;
    protected SecureRandom j;
    protected String k;
    private JSAFE_KeyAttributes p;

    protected JSAFE_SecretKey() {
    }

    public static JSAFE_SecretKey getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_SecretKey.a(string, string2, ce.a());
    }

    public static JSAFE_SecretKey getInstance(String string, JSAFE_Session jSAFE_Session) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_SecretKey.a(string, jSAFE_Session);
    }

    public static JSAFE_SecretKey getInstance(String string, String string2, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_SecretKey.a(string, string2, fIPS140Context.a());
    }

    private static JSAFE_SecretKey a(String string, String string2, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        ca[] caArray;
        JSAFE_SecretKey.a(string, string2);
        for (ca ca2 : caArray = JSAFE_SecretKey.a(string2)) {
            if (ca2.equals(ca.c)) {
                throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
            }
            try {
                cj cj2 = cl.a(cf2, ca2);
                return ex.a(string, cj2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj2) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
    }

    private static JSAFE_SecretKey a(String string, JSAFE_Session jSAFE_Session) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        try {
            if (jSAFE_Session != null) {
                CryptoModule cryptoModule = jSAFE_Session.a();
                return ex.a(string, cryptoModule);
            }
            throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (bj bj2) {
            // empty catch block
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
    }

    @Override
    public String getDevice() {
        return this.c.getDeviceType();
    }

    public String[] getDeviceList() {
        Object[] objectArray = new String[this.a()];
        Arrays.fill(objectArray, this.getDevice());
        return objectArray;
    }

    protected abstract int a();

    @Override
    public String getAlgorithm() {
        if (this.i > 0 && this.k.equals("AES")) {
            return this.k + Integer.toString(this.i);
        }
        return this.k;
    }

    public byte[] getSalt() throws JSAFE_InvalidKeyException {
        throw new JSAFE_InvalidKeyException(b);
    }

    public void setSalt(byte[] byArray, int n2, int n3) {
    }

    public void setPassword(char[] cArray, int n2, int n3) {
        if (this.h != null) {
            this.h.clearSensitiveData();
            this.h = null;
        }
        if (cArray == null) {
            return;
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            return;
        }
        this.h = this.c.getKeyBuilder().newPasswordKey(cArray, n2, n3);
    }

    public char[] getPassword() throws JSAFE_InvalidKeyException {
        if (this.h == null) {
            throw new JSAFE_InvalidKeyException(o);
        }
        return this.h.getPassword();
    }

    @Override
    public int getMaximumKeyLength() {
        return di.b(this.k);
    }

    @Override
    public int getMinimumKeyLength() {
        return di.a(this.k);
    }

    @Override
    public String[] getSupportedSetFormats() {
        return new String[]{l};
    }

    @Override
    public String[] getSupportedGetFormats() {
        if (this.d == null || this.d.getKeyData() == null || this.d.getKeyData().length == 0) {
            return new String[0];
        }
        return new String[]{l};
    }

    @Override
    public String getKeyWrappingFormat(boolean bl2) {
        if (!bl2) {
            return l;
        }
        return this.getAlgorithm() + "SecretKeyBER";
    }

    public void setSecretKeyData(String string, byte[] byArray, int n2, int n3) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException {
        this.b(string);
        this.setSecretKeyData(byArray, n2, n3);
    }

    public void setSecretKeyData(byte[] byArray, int n2, int n3) throws JSAFE_InvalidKeyException {
        if (byArray == null || n2 < 0 || n3 < 0 || byArray.length - n2 < n3) {
            throw new JSAFE_InvalidKeyException(a);
        }
        if (this.getDevice().equalsIgnoreCase(ca.c.toString())) {
            CryptoModule cryptoModule;
            byte[] byArray2 = byArray;
            if (n2 > 0) {
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
            }
            if ((cryptoModule = this.c) instanceof cj) {
                cryptoModule = ((cj)cryptoModule).c();
            }
            this.d = ((l)cryptoModule.getKeyBuilder()).a(byArray2);
            return;
        }
        if (!this.checkKeyLength(n3 * 8)) {
            throw new JSAFE_InvalidKeyException(a);
        }
        this.d = this.c.getKeyBuilder().newSecretKey(byArray, n2, n3);
    }

    @Override
    public void setKeyData(String string, byte[][] byArray) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException {
        this.b(string);
        this.setKeyData(byArray);
    }

    @Override
    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException(m);
        }
        this.setSecretKeyData(byArray[0], 0, byArray[0].length);
    }

    @Override
    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.equalsIgnoreCase("KeyToken")) {
            return this.f();
        }
        byte[] byArray = this.getSecretKeyData(string);
        if (byArray.length == 0) {
            return new byte[0][];
        }
        return new byte[][]{byArray};
    }

    @Override
    public byte[][] getKeyData() {
        byte[] byArray = this.getSecretKeyData();
        if (byArray.length == 0) {
            return new byte[0][];
        }
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    public byte[] getSecretKeyData(String string) throws JSAFE_UnimplementedException {
        if (l.equals(string)) {
            return this.getSecretKeyData();
        }
        if (!(this.getAlgorithm() + "SecretKeyBER").equals(string)) {
            throw new JSAFE_UnimplementedException(n);
        }
        return this.b();
    }

    private byte[][] f() {
        byte[][] byArrayArray = new byte[][]{((r)this.d).getManufacturerID(), ((r)this.d).getKeyID()};
        return byArrayArray;
    }

    byte[] b() throws JSAFE_UnimplementedException {
        byte[] byArray = null;
        try {
            byArray = this.getSecretKeyData();
            byte[] byArray2 = eg.a(this.getAlgorithm(), byArray);
            return byArray2;
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new JSAFE_UnimplementedException("Cannot compute Secret Key BER.");
        }
        finally {
            dk.a(byArray);
        }
    }

    public byte[] getSecretKeyData() {
        if (this.d == null || this.d.getKeyData() == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.d.getKeyData().length];
        System.arraycopy(this.d.getKeyData(), 0, byArray, 0, this.d.getKeyData().length);
        return byArray;
    }

    public abstract boolean checkKeyLength(int var1);

    public void generateInit(int[] nArray, java.security.SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        this.generateInit(nArray, secureRandom, null);
    }

    public void generateInit(int[] nArray, java.security.SecureRandom secureRandom, byte[] ... byArray) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        if (nArray == null) {
            nArray = new int[]{di.c(this.k)};
        } else if (nArray.length != 1) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters for key generation: expected 1");
        }
        int n2 = nArray[0];
        n2 = this.a(n2);
        if (!this.checkKeyLength(n2)) {
            throw new JSAFE_InvalidParameterException(a);
        }
        this.i = n2;
        if (secureRandom != null) {
            this.j = com.rsa.jsafe.a.b(secureRandom);
        }
        this.c();
        this.a(byArray);
    }

    protected abstract void c() throws JSAFE_InvalidUseException;

    protected abstract void a(byte[] ... var1) throws JSAFE_InvalidParameterException;

    private int a(int n2) {
        if (n2 <= 0) {
            return n2;
        }
        if (this.k.equals("3DES_EDE")) {
            if (n2 == 56) {
                n2 = 64;
            }
            if (n2 == 112) {
                n2 = 128;
            }
            if (n2 == 168) {
                n2 = 192;
            }
        } else if (this.k.equals("DES")) {
            if (n2 == 56) {
                n2 = 64;
            }
        } else if (this.k.equals("DESX") && n2 == 120) {
            n2 = 192;
        }
        return n2;
    }

    public void generateReInit() throws JSAFE_InvalidUseException {
        if (this.i < 0) {
            throw new JSAFE_InvalidUseException("Cannot ReInit, object not initialized.");
        }
    }

    public abstract void generate() throws JSAFE_InvalidParameterException;

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSAFE_SecretKey jSAFE_SecretKey = (JSAFE_SecretKey)super.clone();
        jSAFE_SecretKey.d = (SecretKey)dc.a(this.d);
        jSAFE_SecretKey.h = (PasswordKey)dc.a(this.h);
        jSAFE_SecretKey.i = this.i;
        jSAFE_SecretKey.j = this.j == null ? null : this.j.newInstance();
        jSAFE_SecretKey.k = this.k;
        return jSAFE_SecretKey;
    }

    @Override
    public void clearSensitiveData() {
        dn.a.a(this.d);
        dn.a.a(this.h);
    }

    public void setSecretKeyAttributes(JSAFE_KeyAttributes jSAFE_KeyAttributes) {
        this.p = jSAFE_KeyAttributes;
    }

    private void b(String string) throws JSAFE_UnimplementedException {
        if (string == null) {
            throw new JSAFE_UnimplementedException(n);
        }
        if (string.equalsIgnoreCase(l) || string.equalsIgnoreCase("KeyToken")) {
            return;
        }
        throw new JSAFE_UnimplementedException(n);
    }

    SecretKey d() {
        if (this.d == null) {
            return this.h;
        }
        return this.d;
    }

    SecretKey e() {
        if (this.h == null) {
            return this.d;
        }
        return this.h;
    }

    protected void a(KeyGenerator keyGenerator) {
        List<fe> list = JSAFE_KeyAttributes.a(this.p);
        if (list != null) {
            m m2 = (m)keyGenerator;
            for (fe fe2 : list) {
                m2.a(fe2.a(), fe2.b());
            }
        }
    }

    @Override
    public void delete() throws SecurityException {
        if (this.c.getDeviceType().equalsIgnoreCase(ca.c.toString()) && this.d != null) {
            j j2 = (j)((Object)this.d);
            try {
                j2.deleteKeyFromDevice();
            }
            catch (CryptoException cryptoException) {
                throw new SecurityException(cryptoException);
            }
        }
    }
}

