/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.c.a;
import com.rsa.cryptoj.c.ce;
import com.rsa.cryptoj.c.cf;
import com.rsa.cryptoj.c.d;
import com.rsa.cryptoj.c.ka;
import com.rsa.cryptoj.c.ov;
import com.rsa.cryptoj.c.pw;
import com.rsa.cryptoj.c.px;
import com.rsa.cryptoj.c.pz;
import com.rsa.cryptoj.c.qa;
import com.rsa.jcp.OCSPException;
import com.rsa.jcp.OCSPResponderConfig;
import com.rsa.jcp.OCSPStatusType;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.b;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public final class OCSP {
    private OCSP() {
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        return OCSP.sendRequest(string, x509Certificate, publicKey, OCSP.createRequestExtensions(new ArrayList<byte[]>()));
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey, byte[] byArray) throws OCSPException {
        pw pw2;
        cf cf2 = ce.a();
        try {
            pw2 = new pw(cf2, ka.a, x509Certificate, publicKey, new OCSPResponderConfig(string), byArray);
        }
        catch (com.rsa.cryptoj.c.b b2) {
            throw new OCSPException("Invalid DER-encoded extensions.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException.getMessage());
        }
        pz pz2 = new pz(cf2, ka.a);
        byte[] byArray2 = pz2.a(pw2, string, null);
        if (byArray2 == null) {
            throw new OCSPException("OCSP request was unsuccessful: " + pz2.a());
        }
        return byArray2;
    }

    public static OCSPStatusType checkRevocationStatus(byte[] byArray, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        px.a a2;
        cf cf2 = ce.a();
        px px2 = new px(cf2, ka.a, byArray);
        if (!px2.c()) {
            throw new OCSPException(px2.d());
        }
        try {
            a2 = px2.a(x509Certificate, publicKey);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException);
        }
        if (a2 == null) {
            throw new OCSPException("Response did not contain status for specified certificate.");
        }
        return OCSPStatusType.a(a2.f());
    }

    public static byte[] createNonceExtension(byte[] byArray) {
        d d2 = qa.a(byArray);
        return a.c(d2);
    }

    public static byte[] createRequestExtensions(List<byte[]> list) {
        boolean bl2 = false;
        ArrayList<d> arrayList = new ArrayList<d>();
        for (byte[] byArray : list) {
            try {
                d d2 = a.a("Extension", byArray, 0);
                if (d2.a("extnID").equals(ov.dg.c())) {
                    bl2 = true;
                }
                arrayList.add(d2);
            }
            catch (com.rsa.cryptoj.c.b b2) {
                throw new InvalidParameterException("Input contained invalid extension encoding.");
            }
        }
        if (!bl2) {
            arrayList.add(qa.a());
        }
        return a.c(a.a("Extensions", arrayList));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Context fIPS140Context) {
        return OCSP.a(x509Certificate, bl2, b.a(fIPS140Context));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2) {
        return OCSP.a(x509Certificate, bl2, ce.a());
    }

    private static byte[] a(X509Certificate x509Certificate, boolean bl2, cf cf2) {
        cf2.l();
        if (bl2) {
            d d2 = a.a("Name", x509Certificate.getSubjectX500Principal().getEncoded(), 0);
            return a.c(d2.c(a.c(1)));
        }
        return qa.a(x509Certificate.getPublicKey(), true, cf2, ka.a);
    }
}

