/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.key;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.DHParams;
import com.rsa.crypto.DSAParams;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.ECParams;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.KeyPair;
import com.rsa.crypto.PQGParams;
import com.rsa.crypto.PrivateKey;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.alg.SecureRandomWrapper;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAlgorithmIdentifier;
import com.rsa.crypto.ncm.ccme.CCMECryptoContext;
import com.rsa.crypto.ncm.ccme.CCMECryptoObject;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.crypto.ncm.ccme.CCMEParameters;
import com.rsa.crypto.ncm.key.DHParamsImpl;
import com.rsa.crypto.ncm.key.KeyPairImpl;
import com.rsa.crypto.ncm.key.n;
import com.rsa.crypto.ncm.key.u;
import com.rsa.crypto.ncm.log.NativeCryptoObjectEvent;
import com.rsa.cryptoj.c.bz;
import com.rsa.cryptoj.c.co;
import com.rsa.cryptoj.c.dd;

public class KeyPairGeneratorImpl
extends CCMECryptoObject
implements n {
    private static final String l = "Unsupported parameters";
    private static final String m = "_KEY_GENERATION";
    private static final int n = 65537;
    private static final int o = 1;
    private static final int p = 0;
    private SecureRandom q;
    private CCMECryptoObject r;
    private int s;
    private final String t;
    private boolean u = true;
    private DomainParams v;
    private int w = 0;
    private static final int x = 0;
    private static final int y = 1;

    public KeyPairGeneratorImpl(b b2, String string) {
        super(b2);
        this.t = string;
        this.s = CCMEAlgorithmIdentifier.getAlgId(string + m);
    }

    private void a(SecureRandom secureRandom) {
        SecureRandomWrapper secureRandomWrapper = null;
        if (this.r != null && this.r instanceof SecureRandomWrapper) {
            secureRandomWrapper = (SecureRandomWrapper)this.r;
        }
        if (secureRandom != this.r && (secureRandomWrapper == null || secureRandom != secureRandomWrapper.a())) {
            this.r = null;
            if (secureRandomWrapper != null) {
                secureRandomWrapper.clearSensitiveData();
            }
            this.r = secureRandom instanceof CCMECryptoObject ? (CCMECryptoObject)((Object)secureRandom) : new SecureRandomWrapper(this.cryptoModule, secureRandom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(AlgorithmParams algorithmParams, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.freeObject();
        this.c(algorithmParams);
        if (secureRandom == null) {
            throw new InvalidAlgorithmParameterException("Random cannot be null.");
        }
        if (this.isPKCS11Object()) {
            this.q = secureRandom;
        } else {
            this.a(secureRandom);
        }
        if (this.t.equals("RSA")) {
            this.a(algorithmParams);
        } else {
            AlgorithmParams algorithmParams2 = algorithmParams;
            synchronized (algorithmParams2) {
                DomainParams domainParams;
                if (algorithmParams instanceof CCMEParameters && !(algorithmParams instanceof DHParamsImpl)) {
                    CCMEParameters cCMEParameters = (CCMEParameters)algorithmParams;
                    cCMEParameters.recreateParams();
                    domainParams = cCMEParameters;
                } else {
                    domainParams = this.b(algorithmParams);
                }
                try {
                    this.v = (DomainParams)algorithmParams;
                    this.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.r, this.s, domainParams);
                    if (bz.a()) {
                        bz.b().objectCreated(new NativeCryptoObjectEvent("Native", "Asymmetric KeyPair Generator", this.t, this.getImplementationName()));
                    }
                }
                finally {
                    if (domainParams instanceof CCMEParameters) {
                        ((CCMEParameters)domainParams).destroy();
                    }
                }
            }
        }
        this.w = 1;
    }

    private void a(AlgorithmParams algorithmParams) {
        boolean bl2 = false;
        this.s = CCMEAlgorithmIdentifier.getAlgId("RSA_KEY_GENERATION");
        Integer n2 = ((AlgInputParams)algorithmParams).get("keyBits") == null ? -1 : (Integer)((AlgInputParams)algorithmParams).get("keyBits");
        if (n2 < 256 || n2 > 4096) {
            throw new InvalidAlgorithmParameterException("RSA key size must be at least 256 bits and at most 2147483647 bits");
        }
        long l2 = 65537L;
        if (((AlgInputParams)algorithmParams).get("pubExp") != null) {
            l2 = dd.d((byte[])((AlgInputParams)algorithmParams).get("pubExp"));
        }
        if (l2 % 2L == 0L || l2 == 1L) {
            throw new InvalidAlgorithmParameterException("Invalid Public Exponent.");
        }
        Integer n3 = (Integer)((AlgInputParams)algorithmParams).get("keyType");
        if (n3 == null) {
            n3 = this.isPKCS11Object() ? 1 : 0;
        }
        if (n3 == 0 && n2 >= 1024) {
            this.s = CCMEAlgorithmIdentifier.getAlgId("RSA_KEY_GENERATION_X931");
            bl2 = true;
        }
        int n4 = 2;
        if (n3 != null && n3 == 2) {
            n4 = 3;
            this.s = CCMEAlgorithmIdentifier.getAlgId("RSA_KEY_GENERATION");
            bl2 = false;
        }
        if (bl2 && n2 % 256 != 0) {
            throw new InvalidAlgorithmParameterException("Strong key gen and multiprime gen require at least 1024-bit keysize.");
        }
        try {
            this.createRSAObject(this.cryptoModule.b(), this.cryptoModule.e(), this.r, this.s, n2, l2, n4);
        }
        catch (CCMEException cCMEException) {
            if (cCMEException.getErrorCode() == 10018) {
                throw new InvalidAlgorithmParameterException(cCMEException.getMessage());
            }
            throw cCMEException;
        }
    }

    private DomainParams b(AlgorithmParams algorithmParams) {
        DomainParams domainParams;
        if (algorithmParams instanceof DHParams) {
            domainParams = com.rsa.crypto.ncm.key.u.a(this.cryptoModule, (DHParams)algorithmParams);
        } else if (algorithmParams instanceof ECParams) {
            domainParams = com.rsa.crypto.ncm.key.u.a(this.cryptoModule, (ECParams)algorithmParams);
        } else if (algorithmParams instanceof DSAParams) {
            domainParams = com.rsa.crypto.ncm.key.u.a(this.cryptoModule, (DSAParams)algorithmParams);
        } else if (algorithmParams instanceof PQGParams) {
            domainParams = this.t.equals("DSA") ? com.rsa.crypto.ncm.key.u.b(this.cryptoModule, (PQGParams)algorithmParams) : com.rsa.crypto.ncm.key.u.a(this.cryptoModule, (PQGParams)algorithmParams);
        } else {
            throw new InvalidAlgorithmParameterException("Invalid Parameter type for KeyPairGeneration.");
        }
        return domainParams;
    }

    private void c(AlgorithmParams algorithmParams) throws InvalidAlgorithmParameterException {
        if (this.t.equals("RSA")) {
            if (!(algorithmParams instanceof AlgInputParams)) {
                throw new InvalidAlgorithmParameterException(l);
            }
            Integer n2 = (Integer)((AlgInputParams)algorithmParams).get("keyBits");
            if (n2 == null) {
                throw new InvalidAlgorithmParameterException("Expected keyBits parameter not present.");
            }
            if (n2 < 256 || n2 > Integer.MAX_VALUE) {
                throw new InvalidAlgorithmParameterException("RSA key size must be at least 256 bits and at most 2147483647 bits");
            }
            Integer n3 = (Integer)((AlgInputParams)algorithmParams).get("keyType");
            if (n3 != null) {
                if (n3 != 1 && n2 < 1024) {
                    throw new InvalidAlgorithmParameterException("Strong key gen and multiprime gen require at least 1024-bit keysize.");
                }
                if (n3 == 0 && n2 % 256 != 0) {
                    throw new InvalidAlgorithmParameterException("RSA key sizes greater than 1024 must be a multiple of 256 for strong gen.");
                }
            }
        } else if (this.t.equals("DSA")) {
            if (!(algorithmParams instanceof DSAParams) && !(algorithmParams instanceof PQGParams)) {
                throw new InvalidAlgorithmParameterException(l);
            }
            if (((PQGParams)algorithmParams).getP().getBitLength() < 512 || ((PQGParams)algorithmParams).getQ().getBitLength() < 160) {
                throw new InvalidAlgorithmParameterException("Key size too small.");
            }
        } else if (this.t.equals("EC") ? !(algorithmParams instanceof ECParams) : this.t.equals("DH") && !(algorithmParams instanceof DHParams) && !(algorithmParams instanceof PQGParams)) {
            throw new InvalidAlgorithmParameterException(l);
        }
    }

    @Override
    public KeyPair generate() {
        return this.generate(co.f());
    }

    @Override
    public KeyPair generate(boolean bl2) {
        return this.a(null, bl2);
    }

    @Override
    public KeyPair a(String string) {
        return this.a(string, false);
    }

    private KeyPair a(String string, boolean bl2) {
        if (this.r == null && this.q == null) {
            throw new IllegalStateException("Random not set.");
        }
        if (this.w == 0) {
            this.reInit();
        }
        byte[] byArray = null;
        if (this.isPKCS11Object() && this.u) {
            byArray = new byte[20];
            this.q.nextBytes(byArray);
        }
        KeyPairImpl keyPairImpl = new KeyPairImpl(this.cryptoModule, this.t, this.v);
        this.generateNative(keyPairImpl, keyPairImpl.getPrivate(), keyPairImpl.getPublic(), this.isPKCS11Object(), byArray, string, bl2);
        this.w = 0;
        return keyPairImpl;
    }

    @Override
    public Object clone() {
        throw new CryptoException("This functionality is not supported by the native module.");
    }

    private native void generateNative(KeyPair var1, PrivateKey var2, PublicKey var3, boolean var4, byte[] var5, String var6, boolean var7);

    private native void createObject(CCMECryptoContext var1, byte[] var2, CCMECryptoObject var3, int var4, DomainParams var5);

    private native void createRSAObject(CCMECryptoContext var1, byte[] var2, CCMECryptoObject var3, int var4, int var5, long var6, int var8);

    private native void reInit();

    @Override
    public void a(int n2, boolean bl2) throws CryptoException {
        this.setPKCS11AttributeNative(n2, bl2);
        if (n2 == 1) {
            this.u = bl2;
        }
    }

    private native void setPKCS11AttributeNative(int var1, boolean var2) throws CryptoException;
}

