/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.key;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.DSAParams;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.MessageDigest;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAlgorithmIdentifier;
import com.rsa.crypto.ncm.ccme.CCMECryptoObject;
import com.rsa.crypto.ncm.ccme.CCMEPKeyContext;
import com.rsa.crypto.ncm.ccme.CCMEParameters;
import com.rsa.crypto.ncm.key.DSAParamsImpl;
import com.rsa.crypto.ncm.key.ParamGeneratorImpl;
import com.rsa.crypto.ncm.key.u;

public class DSAParamGenerator
extends ParamGeneratorImpl {
    private static final String j = "DSA_FIPS186_3_PARAMETER_GENERATION";
    protected String a;
    protected int b;
    protected int c;
    private byte[] k;
    private byte[] l;
    private byte[] m;
    private CCMEParameters n;

    public DSAParamGenerator(b b2, String string) {
        super(b2, CCMEAlgorithmIdentifier.getAlgId(j));
    }

    @Override
    public void initGen(AlgorithmParams algorithmParams, SecureRandom secureRandom) {
        AlgInputParams algInputParams = (AlgInputParams)algorithmParams;
        Object object = algInputParams.get("paramsForBaseGen");
        if (object == null) {
            this.b = (Integer)algInputParams.get("primeLen");
            this.c = algInputParams.get("subprimeLen") != null ? (Integer)algInputParams.get("subprimeLen") : DSAParamGenerator.a(this.b);
            String string = this.a = algInputParams.get("digest") != null ? (String)algInputParams.get("digest") : DSAParamGenerator.b(this.c);
            if (!this.a(this.b, this.c)) {
                throw new InvalidAlgorithmParameterException("Invalid DSA FIPS 186 prime size.");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Base generation not supported");
        }
        this.a(secureRandom);
    }

    @Override
    public void initVerify(AlgorithmParams algorithmParams, SecureRandom secureRandom) {
        Object object = algorithmParams instanceof AlgInputParams ? ((AlgInputParams)algorithmParams).get("domainParams") : algorithmParams;
        if (!(object instanceof DSAParams)) {
            throw new InvalidAlgorithmParameterException("Expected paramsToVerify to be DSAParams");
        }
        this.a(secureRandom);
        this.n = (CCMEParameters)((Object)u.a(this.cryptoModule, (DSAParams)object));
        this.k = ((DSAParams)((Object)this.n)).getP().toOctetString();
        this.l = ((DSAParams)((Object)this.n)).getQ().toOctetString();
        this.m = ((DSAParams)((Object)this.n)).getG().toOctetString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify() {
        if (this.isHandleNull()) {
            this.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.e);
        }
        this.a();
        this.initVerifyDSANative(this.f, this.k, this.l, this.m);
        try {
            boolean bl2 = this.verifyNative(this.n);
            return bl2;
        }
        finally {
            this.freeObject();
        }
    }

    protected boolean a(int n2, int n3) {
        if (n2 == 1024 && n3 == 160) {
            return true;
        }
        if (n2 == 2048 && (n3 == 224 || n3 == 256)) {
            return true;
        }
        return n2 == 3072 && n3 == 256;
    }

    protected static int a(int n2) {
        if (n2 < 512 || n2 > 4096) {
            throw new InvalidAlgorithmParameterException("primeP size MUST be between 512 and 4096.");
        }
        if (n2 <= 1024) {
            return 160;
        }
        if (n2 <= 2048) {
            return 224;
        }
        return 256;
    }

    protected static String b(int n2) {
        if (n2 == 160) {
            return "SHA1";
        }
        if (n2 == 224) {
            return "SHA224";
        }
        if (n2 == 256) {
            return "SHA256";
        }
        throw new InvalidAlgorithmParameterException("primeQ size can only be 160, 224 or 256 bits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlgorithmParams generate() {
        if (this.isHandleNull()) {
            this.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.e);
        }
        this.a();
        DSAParamsImpl dSAParamsImpl = new DSAParamsImpl(this.cryptoModule);
        this.initDSANative(this.cryptoModule.c(), this.cryptoModule.e(), dSAParamsImpl, this.f, null, this.b, this.c);
        try {
            this.generateNative(dSAParamsImpl);
        }
        finally {
            this.freeObject();
            try {
                ((CCMEParameters)dSAParamsImpl).cache();
            }
            finally {
                dSAParamsImpl.destroy();
            }
        }
        return dSAParamsImpl;
    }

    protected native void initDSANative(CCMEPKeyContext var1, byte[] var2, DomainParams var3, CCMECryptoObject var4, MessageDigest var5, int var6, int var7);

    protected native void initVerifyDSANative(CCMECryptoObject var1, byte[] var2, byte[] var3, byte[] var4);
}

