/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.ccme;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.ncm.ccme.CCMEHandle;
import com.rsa.crypto.ncm.ccme.CCMEProvider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class CCMEPKCS11Provider
extends CCMEHandle
implements CCMEProvider {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final byte[] manufacturerID;

    public CCMEPKCS11Provider(String string) {
        this.createPKCS11Provider(string);
        this.manufacturerID = this.getManufacturerIDNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPin(byte[] byArray, char[] cArray) {
        byte[] byArray2 = this.secureEncode(cArray);
        try {
            this.setPinNative(byArray, byArray2);
        }
        finally {
            Arrays.fill(byArray2, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] secureEncode(char[] cArray) {
        CharsetEncoder charsetEncoder = UTF8_CHARSET.newEncoder();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(charsetEncoder.maxBytesPerChar() * (float)cArray.length));
        try {
            CoderResult coderResult = charsetEncoder.reset().encode(CharBuffer.wrap(cArray), byteBuffer, true);
            if (coderResult == CoderResult.UNDERFLOW) {
                coderResult = charsetEncoder.flush(byteBuffer);
            }
            if (coderResult != CoderResult.UNDERFLOW) {
                throw new CryptoException();
            }
            byteBuffer.flip();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            Arrays.fill(byteBuffer.array(), (byte)0);
        }
    }

    public byte[] getManufacturerID() {
        return (byte[])this.manufacturerID.clone();
    }

    @Override
    public synchronized void close() {
        if (!this.isHandleNull()) {
            this.freeProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private native void createPKCS11Provider(String var1);

    private native void setPinNative(byte[] var1, byte[] var2);

    public native byte[] getManufacturerIDNative();

    private native void freeProvider();
}

